/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nearcache.impl.invalidation;

import com.hazelcast.cluster.Member;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.map.IMapEvent;
import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.UUID;

public abstract class Invalidation
implements IMapEvent,
IdentifiedDataSerializable {
    private String dataStructureName;
    private UUID sourceUuid;
    private UUID partitionUuid;
    private long sequence = -1L;

    public Invalidation() {
    }

    public Invalidation(String dataStructureName) {
        this.dataStructureName = Preconditions.checkNotNull(dataStructureName, "dataStructureName cannot be null");
    }

    public Invalidation(String dataStructureName, UUID sourceUuid, UUID partitionUuid, long sequence2) {
        this.dataStructureName = Preconditions.checkNotNull(dataStructureName, "dataStructureName cannot be null");
        this.sourceUuid = sourceUuid;
        this.partitionUuid = Preconditions.checkNotNull(partitionUuid, "partitionUuid cannot be null");
        this.sequence = Preconditions.checkPositive("sequence", sequence2);
    }

    public final UUID getPartitionUuid() {
        return this.partitionUuid;
    }

    public final UUID getSourceUuid() {
        return this.sourceUuid;
    }

    public final long getSequence() {
        return this.sequence;
    }

    public Data getKey() {
        throw new UnsupportedOperationException("getKey is not supported");
    }

    @Override
    public final String getName() {
        return this.dataStructureName;
    }

    @Override
    public Member getMember() {
        throw new UnsupportedOperationException();
    }

    @Override
    public EntryEventType getEventType() {
        return EntryEventType.INVALIDATION;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.dataStructureName);
        UUIDSerializationUtil.writeUUID(out, this.sourceUuid);
        out.writeLong(this.sequence);
        boolean nullUuid = this.partitionUuid == null;
        out.writeBoolean(nullUuid);
        if (!nullUuid) {
            out.writeLong(this.partitionUuid.getMostSignificantBits());
            out.writeLong(this.partitionUuid.getLeastSignificantBits());
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.dataStructureName = in.readString();
        this.sourceUuid = UUIDSerializationUtil.readUUID(in);
        this.sequence = in.readLong();
        boolean nullUuid = in.readBoolean();
        if (!nullUuid) {
            this.partitionUuid = new UUID(in.readLong(), in.readLong());
        }
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    public String toString() {
        return "dataStructureName='" + this.dataStructureName + "', sourceUuid='" + this.sourceUuid + "', partitionUuid='" + this.partitionUuid + ", sequence=" + this.sequence;
    }
}

