/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.catalog;

import java.util.List;
import java.util.Optional;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.exception.CatalogException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseAlreadyExistException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseNotExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableAlreadyExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableNotExistException;
import org.apache.seatunnel.api.table.factory.Factory;

public interface Catalog {
    default public Optional<Factory> getFactory() {
        return Optional.empty();
    }

    public void open() throws CatalogException;

    public void close() throws CatalogException;

    public String getDefaultDatabase() throws CatalogException;

    public boolean databaseExists(String var1) throws CatalogException;

    public List<String> listDatabases() throws CatalogException;

    public List<String> listTables(String var1) throws CatalogException, DatabaseNotExistException;

    public boolean tableExists(TablePath var1) throws CatalogException;

    public CatalogTable getTable(TablePath var1) throws CatalogException, TableNotExistException;

    public void createTable(TablePath var1, CatalogTable var2, boolean var3) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException;

    public void dropTable(TablePath var1, boolean var2) throws TableNotExistException, CatalogException;

    public void createDatabase(TablePath var1, boolean var2) throws DatabaseAlreadyExistException, CatalogException;

    public void dropDatabase(TablePath var1, boolean var2) throws DatabaseNotExistException, CatalogException;
}

