/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.core.starter.seatunnel.args;

import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.util.ArrayList;
import java.util.List;
import org.apache.seatunnel.common.config.Common;
import org.apache.seatunnel.common.config.DeployMode;
import org.apache.seatunnel.core.starter.command.AbstractCommandArgs;
import org.apache.seatunnel.core.starter.command.Command;
import org.apache.seatunnel.core.starter.command.ConfDecryptCommand;
import org.apache.seatunnel.core.starter.command.ConfEncryptCommand;
import org.apache.seatunnel.core.starter.enums.MasterType;
import org.apache.seatunnel.core.starter.seatunnel.command.ClientExecuteCommand;
import org.apache.seatunnel.core.starter.seatunnel.command.SeaTunnelConfValidateCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCommandArgs
extends AbstractCommandArgs {
    @Parameter(names={"-m", "--master", "-e", "--deploy-mode"}, description="SeaTunnel job submit master, support [local, cluster]", validateWith={MasterTypeValidator.class}, converter=SeaTunnelMasterTargetConverter.class)
    private MasterType masterType = MasterType.CLUSTER;
    @Parameter(names={"-r", "--restore"}, description="restore with savepoint by jobId")
    private String restoreJobId;
    @Parameter(names={"-s", "--savepoint"}, description="savepoint job by jobId")
    private String savePointJobId;
    @Parameter(names={"-cn", "--cluster"}, description="The name of cluster")
    private String clusterName;
    @Parameter(names={"-j", "--job-id"}, description="Get job status by JobId")
    private String jobId;
    @Parameter(names={"-can", "--cancel-job"}, description="Cancel job by JobId")
    private String cancelJobId;
    @Parameter(names={"--metrics"}, description="Get job metrics by JobId")
    private String metricsJobId;
    @Parameter(names={"-l", "--list"}, description="list job status")
    private boolean listJob = false;
    @Parameter(names={"-cj", "--close-job"}, description="Close client the task will also be closed")
    private boolean closeJob = true;

    @Override
    public Command<?> buildCommand() {
        Common.setDeployMode(this.getDeployMode());
        if (this.checkConfig) {
            return new SeaTunnelConfValidateCommand(this);
        }
        if (this.encrypt) {
            return new ConfEncryptCommand(this);
        }
        if (this.decrypt) {
            return new ConfDecryptCommand(this);
        }
        return new ClientExecuteCommand(this);
    }

    @Override
    public DeployMode getDeployMode() {
        return DeployMode.CLIENT;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientCommandArgs)) {
            return false;
        }
        ClientCommandArgs other = (ClientCommandArgs)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isListJob() != other.isListJob()) {
            return false;
        }
        if (this.isCloseJob() != other.isCloseJob()) {
            return false;
        }
        MasterType this$masterType = this.getMasterType();
        MasterType other$masterType = other.getMasterType();
        if (this$masterType == null ? other$masterType != null : !((Object)((Object)this$masterType)).equals((Object)other$masterType)) {
            return false;
        }
        String this$restoreJobId = this.getRestoreJobId();
        String other$restoreJobId = other.getRestoreJobId();
        if (this$restoreJobId == null ? other$restoreJobId != null : !this$restoreJobId.equals(other$restoreJobId)) {
            return false;
        }
        String this$savePointJobId = this.getSavePointJobId();
        String other$savePointJobId = other.getSavePointJobId();
        if (this$savePointJobId == null ? other$savePointJobId != null : !this$savePointJobId.equals(other$savePointJobId)) {
            return false;
        }
        String this$clusterName = this.getClusterName();
        String other$clusterName = other.getClusterName();
        if (this$clusterName == null ? other$clusterName != null : !this$clusterName.equals(other$clusterName)) {
            return false;
        }
        String this$jobId = this.getJobId();
        String other$jobId = other.getJobId();
        if (this$jobId == null ? other$jobId != null : !this$jobId.equals(other$jobId)) {
            return false;
        }
        String this$cancelJobId = this.getCancelJobId();
        String other$cancelJobId = other.getCancelJobId();
        if (this$cancelJobId == null ? other$cancelJobId != null : !this$cancelJobId.equals(other$cancelJobId)) {
            return false;
        }
        String this$metricsJobId = this.getMetricsJobId();
        String other$metricsJobId = other.getMetricsJobId();
        return !(this$metricsJobId == null ? other$metricsJobId != null : !this$metricsJobId.equals(other$metricsJobId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ClientCommandArgs;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result2 = super.hashCode();
        result2 = result2 * 59 + (this.isListJob() ? 79 : 97);
        result2 = result2 * 59 + (this.isCloseJob() ? 79 : 97);
        MasterType $masterType = this.getMasterType();
        result2 = result2 * 59 + ($masterType == null ? 43 : ((Object)((Object)$masterType)).hashCode());
        String $restoreJobId = this.getRestoreJobId();
        result2 = result2 * 59 + ($restoreJobId == null ? 43 : $restoreJobId.hashCode());
        String $savePointJobId = this.getSavePointJobId();
        result2 = result2 * 59 + ($savePointJobId == null ? 43 : $savePointJobId.hashCode());
        String $clusterName = this.getClusterName();
        result2 = result2 * 59 + ($clusterName == null ? 43 : $clusterName.hashCode());
        String $jobId = this.getJobId();
        result2 = result2 * 59 + ($jobId == null ? 43 : $jobId.hashCode());
        String $cancelJobId = this.getCancelJobId();
        result2 = result2 * 59 + ($cancelJobId == null ? 43 : $cancelJobId.hashCode());
        String $metricsJobId = this.getMetricsJobId();
        result2 = result2 * 59 + ($metricsJobId == null ? 43 : $metricsJobId.hashCode());
        return result2;
    }

    public MasterType getMasterType() {
        return this.masterType;
    }

    public String getRestoreJobId() {
        return this.restoreJobId;
    }

    public String getSavePointJobId() {
        return this.savePointJobId;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getCancelJobId() {
        return this.cancelJobId;
    }

    public String getMetricsJobId() {
        return this.metricsJobId;
    }

    public boolean isListJob() {
        return this.listJob;
    }

    public boolean isCloseJob() {
        return this.closeJob;
    }

    public void setMasterType(MasterType masterType) {
        this.masterType = masterType;
    }

    public void setRestoreJobId(String restoreJobId) {
        this.restoreJobId = restoreJobId;
    }

    public void setSavePointJobId(String savePointJobId) {
        this.savePointJobId = savePointJobId;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public void setCancelJobId(String cancelJobId) {
        this.cancelJobId = cancelJobId;
    }

    public void setMetricsJobId(String metricsJobId) {
        this.metricsJobId = metricsJobId;
    }

    public void setListJob(boolean listJob) {
        this.listJob = listJob;
    }

    public void setCloseJob(boolean closeJob) {
        this.closeJob = closeJob;
    }

    @Override
    public String toString() {
        return "ClientCommandArgs(masterType=" + (Object)((Object)this.getMasterType()) + ", restoreJobId=" + this.getRestoreJobId() + ", savePointJobId=" + this.getSavePointJobId() + ", clusterName=" + this.getClusterName() + ", jobId=" + this.getJobId() + ", cancelJobId=" + this.getCancelJobId() + ", metricsJobId=" + this.getMetricsJobId() + ", listJob=" + this.isListJob() + ", closeJob=" + this.isCloseJob() + ")";
    }

    public static class MasterTypeValidator
    implements IParameterValidator {
        private static final Logger log = LoggerFactory.getLogger(MasterTypeValidator.class);

        @Override
        public void validate(String name, String value) throws ParameterException {
            if (name.equals("-e") || name.equals("--deploy-mode")) {
                log.warn("\n******************************************************************************************\n-e and --deploy-mode will be deprecated in 2.3.1, please use -m and --master instead of it\n******************************************************************************************");
            }
        }
    }

    public static class SeaTunnelMasterTargetConverter
    implements IStringConverter<MasterType> {
        private static final List<MasterType> MASTER_TYPE_LIST = new ArrayList<MasterType>();

        @Override
        public MasterType convert(String value) {
            MasterType masterType = MasterType.valueOf(value.toUpperCase());
            if (MASTER_TYPE_LIST.contains((Object)masterType)) {
                return masterType;
            }
            throw new IllegalArgumentException("SeaTunnel job on st-engine submitted target only support these options: [local, cluster]");
        }

        static {
            MASTER_TYPE_LIST.add(MasterType.LOCAL);
            MASTER_TYPE_LIST.add(MasterType.CLUSTER);
        }
    }
}

