/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.imap.storage.file.common;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.seatunnel.engine.imap.storage.api.exception.IMapStorageException;
import org.apache.seatunnel.engine.imap.storage.file.bean.IMapFileData;
import org.apache.seatunnel.engine.imap.storage.file.common.WALDataUtils;
import org.apache.seatunnel.engine.serializer.api.Serializer;

public class WALReader {
    private static final int DEFAULT_QUERY_LIST_SIZE = 1024;
    private FileSystem fs;
    private final Serializer serializer;

    public WALReader(FileSystem fs, Serializer serializer) throws IOException {
        this.serializer = serializer;
        this.fs = fs;
    }

    private List<IMapFileData> readAllData(Path parentPath) throws IOException {
        List<String> fileNames = this.getFileNames(parentPath);
        if (CollectionUtils.isEmpty(fileNames)) {
            return new ArrayList<IMapFileData>();
        }
        ArrayList<IMapFileData> result2 = new ArrayList<IMapFileData>(1024);
        for (String fileName : fileNames) {
            result2.addAll(this.readData(new Path(parentPath, fileName)));
        }
        return result2;
    }

    public Set<Object> loadAllKeys(Path parentPath) throws IOException {
        List<IMapFileData> allData = this.readAllData(parentPath);
        if (CollectionUtils.isEmpty(allData)) {
            return new HashSet<Object>();
        }
        Collections.sort(allData);
        HashSet<Object> result2 = new HashSet<Object>(allData.size());
        HashMap<Object, Long> deleteMap = new HashMap<Object, Long>();
        for (IMapFileData data : allData) {
            Object key = this.deserializeData(data.getKey(), data.getKeyClassName());
            if (deleteMap.containsKey(key)) continue;
            if (data.isDeleted()) {
                deleteMap.put(key, data.getTimestamp());
                continue;
            }
            if (result2.contains(key)) continue;
            result2.add(key);
        }
        return result2;
    }

    public Map<Object, Object> loadAllData(Path parentPath, Set<Object> searchKeys) throws IOException {
        List<IMapFileData> allData = this.readAllData(parentPath);
        if (CollectionUtils.isEmpty(allData)) {
            return new HashMap<Object, Object>();
        }
        Collections.sort(allData);
        HashMap<Object, Object> result2 = new HashMap<Object, Object>(allData.size());
        HashMap<Object, Long> deleteMap = new HashMap<Object, Long>();
        boolean searchByKeys = CollectionUtils.isNotEmpty(searchKeys);
        for (IMapFileData data : allData) {
            Object key = this.deserializeData(data.getKey(), data.getKeyClassName());
            if (searchByKeys && !searchKeys.contains(data.getKey()) || deleteMap.containsKey(key)) continue;
            if (data.isDeleted()) {
                deleteMap.put(key, data.getTimestamp());
                continue;
            }
            if (result2.containsKey(key)) continue;
            Object value = this.deserializeData(data.getValue(), data.getValueClassName());
            result2.put(key, value);
        }
        return result2;
    }

    private List<IMapFileData> readData(Path path) throws IOException {
        ArrayList<IMapFileData> result2 = new ArrayList<IMapFileData>(1024);
        long length = this.fs.getFileStatus(path).getLen();
        try (FSDataInputStream in = this.fs.open(path);){
            byte[] datas = new byte[(int)length];
            in.readFully(datas);
            int startIndex = 0;
            while (startIndex + 12 < datas.length) {
                byte[] metadata = new byte[12];
                System.arraycopy(datas, startIndex, metadata, 0, 12);
                int dataLength = WALDataUtils.byteArrayToInt(metadata);
                if ((startIndex += 12) + dataLength > datas.length) {
                    break;
                }
                byte[] data = new byte[dataLength];
                System.arraycopy(datas, startIndex, data, 0, data.length);
                IMapFileData fileData = this.serializer.deserialize(data, IMapFileData.class);
                result2.add(fileData);
                startIndex += data.length;
            }
        }
        return result2;
    }

    private List<String> getFileNames(Path parentPath) {
        try {
            RemoteIterator fileStatusRemoteIterator = this.fs.listFiles(parentPath, true);
            ArrayList<String> fileNames = new ArrayList<String>();
            while (fileStatusRemoteIterator.hasNext()) {
                LocatedFileStatus fileStatus = (LocatedFileStatus)fileStatusRemoteIterator.next();
                if (!fileStatus.getPath().getName().endsWith("wal.txt")) continue;
                fileNames.add(fileStatus.getPath().toString());
            }
            return fileNames;
        }
        catch (IOException e) {
            throw new IMapStorageException(e, "get file names error,path is s%", parentPath);
        }
    }

    private Object deserializeData(byte[] data, String className) {
        try {
            Class<?> clazz = ClassUtils.getClass(className);
            try {
                return this.serializer.deserialize(data, clazz);
            }
            catch (IOException e) {
                throw new IMapStorageException(e, "deserialize data error: data is s%, className is s%", data, className);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IMapStorageException(e, "deserialize data error, class name is {}", className);
        }
    }
}

