/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.rest;

import com.hazelcast.internal.ascii.TextCommandService;
import com.hazelcast.internal.ascii.rest.HttpCommandProcessor;
import com.hazelcast.internal.ascii.rest.HttpGetCommand;
import com.hazelcast.internal.json.JsonArray;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.util.JsonUtil;
import com.hazelcast.map.IMap;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.seatunnel.engine.core.dag.logical.LogicalDag;
import org.apache.seatunnel.engine.core.job.JobImmutableInformation;
import org.apache.seatunnel.engine.core.job.JobInfo;
import org.apache.seatunnel.engine.core.job.JobStatus;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.log.Log4j2HttpGetCommandProcessor;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.JsonNode;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.ObjectMapper;

public class RestHttpGetCommandProcessor
extends HttpCommandProcessor<HttpGetCommand> {
    private final Log4j2HttpGetCommandProcessor original;
    private static final String SOURCE_RECEIVED_COUNT = "SourceReceivedCount";
    private static final String SINK_WRITE_COUNT = "SinkWriteCount";

    public RestHttpGetCommandProcessor(TextCommandService textCommandService) {
        this(textCommandService, new Log4j2HttpGetCommandProcessor(textCommandService));
    }

    public RestHttpGetCommandProcessor(TextCommandService textCommandService, Log4j2HttpGetCommandProcessor log4j2HttpGetCommandProcessor) {
        super(textCommandService, textCommandService.getNode().getLogger(Log4j2HttpGetCommandProcessor.class));
        this.original = log4j2HttpGetCommandProcessor;
    }

    @Override
    public void handle(HttpGetCommand httpGetCommand) {
        String uri = httpGetCommand.getURI();
        if (uri.startsWith("/hazelcast/rest/maps/running-jobs")) {
            this.handleRunningJobsInfo(httpGetCommand);
        } else {
            this.original.handle(httpGetCommand);
        }
        this.textCommandService.sendResponse(httpGetCommand);
    }

    @Override
    public void handleRejection(HttpGetCommand httpGetCommand) {
        this.handle(httpGetCommand);
    }

    private void handleRunningJobsInfo(HttpGetCommand command) {
        IMap values = this.textCommandService.getNode().getNodeEngine().getHazelcastInstance().getMap("engine_runningJobInfo");
        Map<String, Object> extensionServices = this.textCommandService.getNode().getNodeExtension().createExtensionServices();
        SeaTunnelServer seaTunnelServer = (SeaTunnelServer)extensionServices.get("st:impl:seaTunnelServer");
        JsonArray jobs = values.entrySet().stream().map(jobInfoEntry -> {
            JsonObject jobInfo = new JsonObject();
            JobImmutableInformation jobImmutableInformation = (JobImmutableInformation)this.textCommandService.getNode().getNodeEngine().getSerializationService().toObject(this.textCommandService.getNode().getNodeEngine().getSerializationService().toObject(((JobInfo)jobInfoEntry.getValue()).getJobImmutableInformation()));
            LogicalDag logicalDag = (LogicalDag)this.textCommandService.getNode().getNodeEngine().getSerializationService().toObject(jobImmutableInformation.getLogicalDag());
            String jobMetrics = seaTunnelServer.getCoordinatorService().getJobMetrics((Long)jobInfoEntry.getKey()).toJsonString();
            JobStatus jobStatus = seaTunnelServer.getCoordinatorService().getJobStatus((Long)jobInfoEntry.getKey());
            return jobInfo.add("jobId", (Long)jobInfoEntry.getKey()).add("jobName", logicalDag.getJobConfig().getName()).add("jobStatus", jobStatus.toString()).add("envOptions", JsonUtil.toJsonObject(logicalDag.getJobConfig().getEnvOptions())).add("createTime", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(jobImmutableInformation.getCreateTime()))).add("jobDag", logicalDag.getLogicalDagAsJson()).add("pluginJarsUrls", jobImmutableInformation.getPluginJarsUrls().stream().map(url -> {
                JsonObject jarUrl = new JsonObject();
                jarUrl.add("jarPath", url.toString());
                return jarUrl;
            }).collect(JsonArray::new, JsonArray::add, JsonArray::add)).add("isStartWithSavePoint", jobImmutableInformation.isStartWithSavePoint()).add("metrics", JsonUtil.toJsonObject(this.getJobMetrics(jobMetrics)));
        }).collect(JsonArray::new, JsonArray::add, JsonArray::add);
        this.prepareResponse(command, jobs);
    }

    private Map<String, Long> getJobMetrics(String jobMetrics) {
        HashMap<String, Long> metricsMap = new HashMap<String, Long>();
        long sourceReadCount = 0L;
        long sinkWriteCount = 0L;
        try {
            JsonNode jobMetricsStr = new ObjectMapper().readTree(jobMetrics);
            JsonNode sourceReceivedCountJson = jobMetricsStr.get(SOURCE_RECEIVED_COUNT);
            JsonNode sinkWriteCountJson = jobMetricsStr.get(SINK_WRITE_COUNT);
            for (int i = 0; i < jobMetricsStr.get(SOURCE_RECEIVED_COUNT).size(); ++i) {
                JsonNode sourceReader = sourceReceivedCountJson.get(i);
                JsonNode sinkWriter = sinkWriteCountJson.get(i);
                sourceReadCount += sourceReader.get("value").asLong();
                sinkWriteCount += sinkWriter.get("value").asLong();
            }
        }
        catch (NullPointerException | JsonProcessingException e) {
            return metricsMap;
        }
        metricsMap.put("sourceReceivedCount", sourceReadCount);
        metricsMap.put("sinkWriteCount", sinkWriteCount);
        return metricsMap;
    }
}

