/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task.flow;

import com.hazelcast.collection.IQueue;
import com.hazelcast.core.HazelcastInstance;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.seatunnel.api.table.type.Record;
import org.apache.seatunnel.engine.core.dag.actions.ShuffleAction;
import org.apache.seatunnel.engine.core.dag.actions.ShuffleStrategy;
import org.apache.seatunnel.engine.server.checkpoint.ActionStateKey;
import org.apache.seatunnel.engine.server.task.SeaTunnelTask;
import org.apache.seatunnel.engine.server.task.flow.AbstractFlowLifeCycle;
import org.apache.seatunnel.engine.server.task.flow.OneInputFlowLifeCycle;
import org.apache.seatunnel.engine.server.task.record.Barrier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleSinkFlowLifeCycle
extends AbstractFlowLifeCycle
implements OneInputFlowLifeCycle<Record<?>> {
    private static final Logger log = LoggerFactory.getLogger(ShuffleSinkFlowLifeCycle.class);
    private final int pipelineId;
    private final int taskIndex;
    private final ShuffleAction shuffleAction;
    private final Map<String, IQueue<Record<?>>> shuffles;
    private final int shuffleBatchSize;
    private final long shuffleBatchFlushInterval;
    private final Map<String, Queue<Record<?>>> shuffleBuffer;
    private final ShuffleStrategy shuffleStrategy;
    private int shuffleBufferSize;
    private long lastModify;

    public ShuffleSinkFlowLifeCycle(SeaTunnelTask runningTask, int taskIndex, ShuffleAction shuffleAction, HazelcastInstance hazelcastInstance, CompletableFuture<Void> completableFuture) {
        super(runningTask, completableFuture);
        this.pipelineId = runningTask.getTaskLocation().getTaskGroupLocation().getPipelineId();
        this.taskIndex = taskIndex;
        this.shuffleAction = shuffleAction;
        this.shuffleStrategy = shuffleAction.getConfig().getShuffleStrategy();
        this.shuffles = this.shuffleStrategy.createShuffles(hazelcastInstance, this.pipelineId, taskIndex);
        this.shuffleBatchSize = shuffleAction.getConfig().getBatchSize();
        this.shuffleBatchFlushInterval = shuffleAction.getConfig().getBatchFlushInterval();
        this.shuffleBuffer = new HashMap();
    }

    @Override
    public void received(Record<?> record) throws IOException {
        if (record.getData() instanceof Barrier) {
            this.shuffleFlush();
            Barrier barrier = (Barrier)record.getData();
            if (barrier.prepareClose()) {
                this.prepareClose = true;
            }
            if (barrier.snapshot()) {
                this.runningTask.addState(barrier, ActionStateKey.of(this.shuffleAction), Collections.emptyList());
            }
            this.runningTask.ack(barrier);
            for (Map.Entry<String, IQueue<Record<?>>> shuffle : this.shuffles.entrySet()) {
                IQueue<Record<?>> shuffleQueue = shuffle.getValue();
                try {
                    shuffleQueue.put(record);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            if (this.prepareClose.booleanValue()) {
                return;
            }
            this.shuffleItem(record);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        for (Map.Entry<String, IQueue<Record<?>>> shuffleItem : this.shuffles.entrySet()) {
            log.info("destroy shuffle queue: {}", (Object)shuffleItem.getKey());
            shuffleItem.getValue().destroy();
        }
    }

    public CompletableFuture<Boolean> registryScheduleFlushTask(final ScheduledExecutorService scheduledExecutorService) {
        final CompletableFuture<Boolean> completedFuture = new CompletableFuture<Boolean>();
        Runnable scheduleFlushTask = new Runnable(){

            @Override
            public void run() {
                if (!ShuffleSinkFlowLifeCycle.this.prepareClose.booleanValue() && ShuffleSinkFlowLifeCycle.this.shuffleBufferSize > 0 && System.currentTimeMillis() - ShuffleSinkFlowLifeCycle.this.lastModify > ShuffleSinkFlowLifeCycle.this.shuffleBatchFlushInterval) {
                    try {
                        ShuffleSinkFlowLifeCycle.this.shuffleFlush();
                    }
                    catch (Exception e) {
                        log.error("Execute schedule task error.", e);
                    }
                }
                if (!ShuffleSinkFlowLifeCycle.this.prepareClose.booleanValue()) {
                    1 nextScheduleFlushTask = this;
                    scheduledExecutorService.schedule(nextScheduleFlushTask, ShuffleSinkFlowLifeCycle.this.shuffleBatchFlushInterval, TimeUnit.MILLISECONDS);
                } else {
                    completedFuture.complete(true);
                }
            }
        };
        scheduledExecutorService.schedule(scheduleFlushTask, this.shuffleBatchFlushInterval, TimeUnit.MILLISECONDS);
        return completedFuture;
    }

    private synchronized void shuffleItem(Record<?> record) {
        String shuffleKey = this.shuffleStrategy.createShuffleKey(record, this.pipelineId, this.taskIndex);
        this.shuffleBuffer.computeIfAbsent(shuffleKey, key -> new LinkedList()).add(record);
        ++this.shuffleBufferSize;
        if (this.shuffleBufferSize >= this.shuffleBatchSize || this.shuffleBufferSize > 1 && System.currentTimeMillis() - this.lastModify > this.shuffleBatchFlushInterval) {
            this.shuffleFlush();
        }
        this.lastModify = System.currentTimeMillis();
    }

    private synchronized void shuffleFlush() {
        for (Map.Entry<String, Queue<Record<?>>> shuffleBatch : this.shuffleBuffer.entrySet()) {
            IQueue<Record<?>> shuffleQueue = this.shuffles.get(shuffleBatch.getKey());
            Queue<Record<?>> shuffleQueueBatch = shuffleBatch.getValue();
            if (!shuffleQueue.addAll((Collection)shuffleBatch.getValue())) {
                Record<?> shuffleItem;
                while ((shuffleItem = shuffleQueueBatch.poll()) != null) {
                    try {
                        shuffleQueue.put(shuffleItem);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            shuffleQueueBatch.clear();
        }
        this.shuffleBufferSize = 0;
    }
}

