/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task.operation.source;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.common.utils.RetryUtils;
import org.apache.seatunnel.common.utils.SerializationUtils;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.exception.TaskGroupContextNotFoundException;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.serializable.TaskDataSerializerHook;
import org.apache.seatunnel.engine.server.task.SourceSeaTunnelTask;

public class AssignSplitOperation<SplitT extends SourceSplit>
extends Operation
implements IdentifiedDataSerializable {
    private byte[] splits;
    private TaskLocation taskID;

    public AssignSplitOperation() {
    }

    public AssignSplitOperation(TaskLocation taskID, byte[] splits) {
        this.taskID = taskID;
        this.splits = splits;
    }

    @Override
    public void run() throws Exception {
        SeaTunnelServer server = (SeaTunnelServer)this.getService();
        RetryUtils.retryWithException(() -> {
            SourceSeaTunnelTask task = (SourceSeaTunnelTask)server.getTaskExecutionService().getTask(this.taskID);
            ClassLoader classLoader = server.getTaskExecutionService().getExecutionContext(this.taskID.getTaskGroupLocation()).getClassLoader();
            Object[] o = (Object[])SerializationUtils.deserialize(this.splits, classLoader);
            task.receivedSourceSplit(Arrays.stream(o).map(i -> (SourceSplit)i).collect(Collectors.toList()));
            return null;
        }, new RetryUtils.RetryMaterial(30, true, exception -> exception instanceof TaskGroupContextNotFoundException && !server.taskIsEnded(this.taskID.getTaskGroupLocation()), 2000L));
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeByteArray(this.splits);
        out.writeObject(this.taskID);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.splits = in.readByteArray();
        this.taskID = (TaskLocation)in.readObject();
    }

    @Override
    public int getFactoryId() {
        return TaskDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 3;
    }
}

