import { type PropType, type Ref, type VNode } from 'vue';
import { type HSLA, type RGBA } from 'seemly';
import { type FollowerPlacement } from 'vueuc';
import type { ExtractPublicPropTypes, MaybeArray } from '../../_utils';
import type { ActionType, ColorPickerMode } from './utils';
import type { OnClear, OnUpdateValue, RenderLabel } from './interface';
export declare const colorPickerProps: {
    readonly value: PropType<string | null>;
    readonly show: {
        readonly type: PropType<boolean | undefined>;
        readonly default: undefined;
    };
    readonly defaultShow: BooleanConstructor;
    readonly defaultValue: PropType<string | null>;
    readonly modes: {
        readonly type: PropType<ColorPickerMode[]>;
        readonly default: () => string[];
    };
    readonly placement: {
        readonly type: PropType<FollowerPlacement>;
        readonly default: "bottom-start";
    };
    readonly to: {
        type: PropType<HTMLElement | string | boolean>;
        default: undefined;
    };
    readonly showAlpha: {
        readonly type: BooleanConstructor;
        readonly default: true;
    };
    readonly showPreview: BooleanConstructor;
    readonly swatches: PropType<string[]>;
    readonly disabled: {
        readonly type: PropType<boolean | undefined>;
        readonly default: undefined;
    };
    readonly actions: {
        readonly type: PropType<ActionType[]>;
        readonly default: null;
    };
    readonly internalActions: PropType<ReadonlyArray<"redo" | "undo">>;
    readonly size: PropType<"small" | "medium" | "large">;
    readonly renderLabel: PropType<RenderLabel>;
    readonly onComplete: PropType<OnUpdateValue>;
    readonly onConfirm: PropType<OnUpdateValue>;
    readonly onClear: PropType<OnClear>;
    readonly 'onUpdate:show': PropType<MaybeArray<(value: boolean) => void>>;
    readonly onUpdateShow: PropType<MaybeArray<(value: boolean) => void>>;
    readonly 'onUpdate:value': PropType<MaybeArray<OnUpdateValue>>;
    readonly onUpdateValue: PropType<MaybeArray<OnUpdateValue>>;
    readonly theme: PropType<import("../../_mixins").Theme<"ColorPicker", {
        panelFontSize: string;
        boxShadow: string;
        color: string;
        textColor: string;
        borderRadius: string;
        border: string;
        heightSmall: string;
        heightMedium: string;
        heightLarge: string;
        fontSizeSmall: string;
        fontSizeMedium: string;
        fontSizeLarge: string;
        dividerColor: string;
    }, {
        Input: import("../../_mixins").Theme<"Input", {
            countTextColorDisabled: string;
            countTextColor: string;
            heightTiny: string;
            heightSmall: string;
            heightMedium: string;
            heightLarge: string;
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            lineHeight: string;
            lineHeightTextarea: string;
            borderRadius: string;
            iconSize: string;
            groupLabelColor: string;
            groupLabelTextColor: string;
            textColor: string;
            textColorDisabled: string;
            textDecorationColor: string;
            caretColor: string;
            placeholderColor: string;
            placeholderColorDisabled: string;
            color: string;
            colorDisabled: string;
            colorFocus: string;
            groupLabelBorder: string;
            border: string;
            borderHover: string;
            borderDisabled: string;
            borderFocus: string;
            boxShadowFocus: string;
            loadingColor: string;
            loadingColorWarning: string;
            borderWarning: string;
            borderHoverWarning: string;
            colorFocusWarning: string;
            borderFocusWarning: string;
            boxShadowFocusWarning: string;
            caretColorWarning: string;
            loadingColorError: string;
            borderError: string;
            borderHoverError: string;
            colorFocusError: string;
            borderFocusError: string;
            boxShadowFocusError: string;
            caretColorError: string;
            clearColor: string;
            clearColorHover: string;
            clearColorPressed: string;
            iconColor: string;
            iconColorDisabled: string;
            iconColorHover: string;
            iconColorPressed: string;
            suffixTextColor: string;
            paddingTiny: string;
            paddingSmall: string;
            paddingMedium: string;
            paddingLarge: string;
            clearSize: string;
        }, any>;
        Button: import("../../_mixins").Theme<"Button", {
            heightTiny: string;
            heightSmall: string;
            heightMedium: string;
            heightLarge: string;
            borderRadiusTiny: string;
            borderRadiusSmall: string;
            borderRadiusMedium: string;
            borderRadiusLarge: string;
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            opacityDisabled: string;
            colorOpacitySecondary: string;
            colorOpacitySecondaryHover: string;
            colorOpacitySecondaryPressed: string;
            colorSecondary: string;
            colorSecondaryHover: string;
            colorSecondaryPressed: string;
            colorTertiary: string;
            colorTertiaryHover: string;
            colorTertiaryPressed: string;
            colorQuaternary: string;
            colorQuaternaryHover: string;
            colorQuaternaryPressed: string;
            color: string;
            colorHover: string;
            colorPressed: string;
            colorFocus: string;
            colorDisabled: string;
            textColor: string;
            textColorTertiary: string;
            textColorHover: string;
            textColorPressed: string;
            textColorFocus: string;
            textColorDisabled: string;
            textColorText: string;
            textColorTextHover: string;
            textColorTextPressed: string;
            textColorTextFocus: string;
            textColorTextDisabled: string;
            textColorGhost: string;
            textColorGhostHover: string;
            textColorGhostPressed: string;
            textColorGhostFocus: string;
            textColorGhostDisabled: string;
            border: string;
            borderHover: string;
            borderPressed: string;
            borderFocus: string;
            borderDisabled: string;
            rippleColor: string;
            colorPrimary: string;
            colorHoverPrimary: string;
            colorPressedPrimary: string;
            colorFocusPrimary: string;
            colorDisabledPrimary: string;
            textColorPrimary: string;
            textColorHoverPrimary: string;
            textColorPressedPrimary: string;
            textColorFocusPrimary: string;
            textColorDisabledPrimary: string;
            textColorTextPrimary: string;
            textColorTextHoverPrimary: string;
            textColorTextPressedPrimary: string;
            textColorTextFocusPrimary: string;
            textColorTextDisabledPrimary: string;
            textColorGhostPrimary: string;
            textColorGhostHoverPrimary: string;
            textColorGhostPressedPrimary: string;
            textColorGhostFocusPrimary: string;
            textColorGhostDisabledPrimary: string;
            borderPrimary: string;
            borderHoverPrimary: string;
            borderPressedPrimary: string;
            borderFocusPrimary: string;
            borderDisabledPrimary: string;
            rippleColorPrimary: string;
            colorInfo: string;
            colorHoverInfo: string;
            colorPressedInfo: string;
            colorFocusInfo: string;
            colorDisabledInfo: string;
            textColorInfo: string;
            textColorHoverInfo: string;
            textColorPressedInfo: string;
            textColorFocusInfo: string;
            textColorDisabledInfo: string;
            textColorTextInfo: string;
            textColorTextHoverInfo: string;
            textColorTextPressedInfo: string;
            textColorTextFocusInfo: string;
            textColorTextDisabledInfo: string;
            textColorGhostInfo: string;
            textColorGhostHoverInfo: string;
            textColorGhostPressedInfo: string;
            textColorGhostFocusInfo: string;
            textColorGhostDisabledInfo: string;
            borderInfo: string;
            borderHoverInfo: string;
            borderPressedInfo: string;
            borderFocusInfo: string;
            borderDisabledInfo: string;
            rippleColorInfo: string;
            colorSuccess: string;
            colorHoverSuccess: string;
            colorPressedSuccess: string;
            colorFocusSuccess: string;
            colorDisabledSuccess: string;
            textColorSuccess: string;
            textColorHoverSuccess: string;
            textColorPressedSuccess: string;
            textColorFocusSuccess: string;
            textColorDisabledSuccess: string;
            textColorTextSuccess: string;
            textColorTextHoverSuccess: string;
            textColorTextPressedSuccess: string;
            textColorTextFocusSuccess: string;
            textColorTextDisabledSuccess: string;
            textColorGhostSuccess: string;
            textColorGhostHoverSuccess: string;
            textColorGhostPressedSuccess: string;
            textColorGhostFocusSuccess: string;
            textColorGhostDisabledSuccess: string;
            borderSuccess: string;
            borderHoverSuccess: string;
            borderPressedSuccess: string;
            borderFocusSuccess: string;
            borderDisabledSuccess: string;
            rippleColorSuccess: string;
            colorWarning: string;
            colorHoverWarning: string;
            colorPressedWarning: string;
            colorFocusWarning: string;
            colorDisabledWarning: string;
            textColorWarning: string;
            textColorHoverWarning: string;
            textColorPressedWarning: string;
            textColorFocusWarning: string;
            textColorDisabledWarning: string;
            textColorTextWarning: string;
            textColorTextHoverWarning: string;
            textColorTextPressedWarning: string;
            textColorTextFocusWarning: string;
            textColorTextDisabledWarning: string;
            textColorGhostWarning: string;
            textColorGhostHoverWarning: string;
            textColorGhostPressedWarning: string;
            textColorGhostFocusWarning: string;
            textColorGhostDisabledWarning: string;
            borderWarning: string;
            borderHoverWarning: string;
            borderPressedWarning: string;
            borderFocusWarning: string;
            borderDisabledWarning: string;
            rippleColorWarning: string;
            colorError: string;
            colorHoverError: string;
            colorPressedError: string;
            colorFocusError: string;
            colorDisabledError: string;
            textColorError: string;
            textColorHoverError: string;
            textColorPressedError: string;
            textColorFocusError: string;
            textColorDisabledError: string;
            textColorTextError: string;
            textColorTextHoverError: string;
            textColorTextPressedError: string;
            textColorTextFocusError: string;
            textColorTextDisabledError: string;
            textColorGhostError: string;
            textColorGhostHoverError: string;
            textColorGhostPressedError: string;
            textColorGhostFocusError: string;
            textColorGhostDisabledError: string;
            borderError: string;
            borderHoverError: string;
            borderPressedError: string;
            borderFocusError: string;
            borderDisabledError: string;
            rippleColorError: string;
            waveOpacity: string;
            fontWeight: string;
            fontWeightStrong: string;
            paddingTiny: string;
            paddingSmall: string;
            paddingMedium: string;
            paddingLarge: string;
            paddingRoundTiny: string;
            paddingRoundSmall: string;
            paddingRoundMedium: string;
            paddingRoundLarge: string;
            iconMarginTiny: string;
            iconMarginSmall: string;
            iconMarginMedium: string;
            iconMarginLarge: string;
            iconSizeTiny: string;
            iconSizeSmall: string;
            iconSizeMedium: string;
            iconSizeLarge: string;
            rippleDuration: string;
        }, any>;
    }>>;
    readonly themeOverrides: PropType<import("../../_mixins/use-theme").ExtractThemeOverrides<import("../../_mixins").Theme<"ColorPicker", {
        panelFontSize: string;
        boxShadow: string;
        color: string;
        textColor: string;
        borderRadius: string;
        border: string;
        heightSmall: string;
        heightMedium: string;
        heightLarge: string;
        fontSizeSmall: string;
        fontSizeMedium: string;
        fontSizeLarge: string;
        dividerColor: string;
    }, {
        Input: import("../../_mixins").Theme<"Input", {
            countTextColorDisabled: string;
            countTextColor: string;
            heightTiny: string;
            heightSmall: string;
            heightMedium: string;
            heightLarge: string;
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            lineHeight: string;
            lineHeightTextarea: string;
            borderRadius: string;
            iconSize: string;
            groupLabelColor: string;
            groupLabelTextColor: string;
            textColor: string;
            textColorDisabled: string;
            textDecorationColor: string;
            caretColor: string;
            placeholderColor: string;
            placeholderColorDisabled: string;
            color: string;
            colorDisabled: string;
            colorFocus: string;
            groupLabelBorder: string;
            border: string;
            borderHover: string;
            borderDisabled: string;
            borderFocus: string;
            boxShadowFocus: string;
            loadingColor: string;
            loadingColorWarning: string;
            borderWarning: string;
            borderHoverWarning: string;
            colorFocusWarning: string;
            borderFocusWarning: string;
            boxShadowFocusWarning: string;
            caretColorWarning: string;
            loadingColorError: string;
            borderError: string;
            borderHoverError: string;
            colorFocusError: string;
            borderFocusError: string;
            boxShadowFocusError: string;
            caretColorError: string;
            clearColor: string;
            clearColorHover: string;
            clearColorPressed: string;
            iconColor: string;
            iconColorDisabled: string;
            iconColorHover: string;
            iconColorPressed: string;
            suffixTextColor: string;
            paddingTiny: string;
            paddingSmall: string;
            paddingMedium: string;
            paddingLarge: string;
            clearSize: string;
        }, any>;
        Button: import("../../_mixins").Theme<"Button", {
            heightTiny: string;
            heightSmall: string;
            heightMedium: string;
            heightLarge: string;
            borderRadiusTiny: string;
            borderRadiusSmall: string;
            borderRadiusMedium: string;
            borderRadiusLarge: string;
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            opacityDisabled: string;
            colorOpacitySecondary: string;
            colorOpacitySecondaryHover: string;
            colorOpacitySecondaryPressed: string;
            colorSecondary: string;
            colorSecondaryHover: string;
            colorSecondaryPressed: string;
            colorTertiary: string;
            colorTertiaryHover: string;
            colorTertiaryPressed: string;
            colorQuaternary: string;
            colorQuaternaryHover: string;
            colorQuaternaryPressed: string;
            color: string;
            colorHover: string;
            colorPressed: string;
            colorFocus: string;
            colorDisabled: string;
            textColor: string;
            textColorTertiary: string;
            textColorHover: string;
            textColorPressed: string;
            textColorFocus: string;
            textColorDisabled: string;
            textColorText: string;
            textColorTextHover: string;
            textColorTextPressed: string;
            textColorTextFocus: string;
            textColorTextDisabled: string;
            textColorGhost: string;
            textColorGhostHover: string;
            textColorGhostPressed: string;
            textColorGhostFocus: string;
            textColorGhostDisabled: string;
            border: string;
            borderHover: string;
            borderPressed: string;
            borderFocus: string;
            borderDisabled: string;
            rippleColor: string;
            colorPrimary: string;
            colorHoverPrimary: string;
            colorPressedPrimary: string;
            colorFocusPrimary: string;
            colorDisabledPrimary: string;
            textColorPrimary: string;
            textColorHoverPrimary: string;
            textColorPressedPrimary: string;
            textColorFocusPrimary: string;
            textColorDisabledPrimary: string;
            textColorTextPrimary: string;
            textColorTextHoverPrimary: string;
            textColorTextPressedPrimary: string;
            textColorTextFocusPrimary: string;
            textColorTextDisabledPrimary: string;
            textColorGhostPrimary: string;
            textColorGhostHoverPrimary: string;
            textColorGhostPressedPrimary: string;
            textColorGhostFocusPrimary: string;
            textColorGhostDisabledPrimary: string;
            borderPrimary: string;
            borderHoverPrimary: string;
            borderPressedPrimary: string;
            borderFocusPrimary: string;
            borderDisabledPrimary: string;
            rippleColorPrimary: string;
            colorInfo: string;
            colorHoverInfo: string;
            colorPressedInfo: string;
            colorFocusInfo: string;
            colorDisabledInfo: string;
            textColorInfo: string;
            textColorHoverInfo: string;
            textColorPressedInfo: string;
            textColorFocusInfo: string;
            textColorDisabledInfo: string;
            textColorTextInfo: string;
            textColorTextHoverInfo: string;
            textColorTextPressedInfo: string;
            textColorTextFocusInfo: string;
            textColorTextDisabledInfo: string;
            textColorGhostInfo: string;
            textColorGhostHoverInfo: string;
            textColorGhostPressedInfo: string;
            textColorGhostFocusInfo: string;
            textColorGhostDisabledInfo: string;
            borderInfo: string;
            borderHoverInfo: string;
            borderPressedInfo: string;
            borderFocusInfo: string;
            borderDisabledInfo: string;
            rippleColorInfo: string;
            colorSuccess: string;
            colorHoverSuccess: string;
            colorPressedSuccess: string;
            colorFocusSuccess: string;
            colorDisabledSuccess: string;
            textColorSuccess: string;
            textColorHoverSuccess: string;
            textColorPressedSuccess: string;
            textColorFocusSuccess: string;
            textColorDisabledSuccess: string;
            textColorTextSuccess: string;
            textColorTextHoverSuccess: string;
            textColorTextPressedSuccess: string;
            textColorTextFocusSuccess: string;
            textColorTextDisabledSuccess: string;
            textColorGhostSuccess: string;
            textColorGhostHoverSuccess: string;
            textColorGhostPressedSuccess: string;
            textColorGhostFocusSuccess: string;
            textColorGhostDisabledSuccess: string;
            borderSuccess: string;
            borderHoverSuccess: string;
            borderPressedSuccess: string;
            borderFocusSuccess: string;
            borderDisabledSuccess: string;
            rippleColorSuccess: string;
            colorWarning: string;
            colorHoverWarning: string;
            colorPressedWarning: string;
            colorFocusWarning: string;
            colorDisabledWarning: string;
            textColorWarning: string;
            textColorHoverWarning: string;
            textColorPressedWarning: string;
            textColorFocusWarning: string;
            textColorDisabledWarning: string;
            textColorTextWarning: string;
            textColorTextHoverWarning: string;
            textColorTextPressedWarning: string;
            textColorTextFocusWarning: string;
            textColorTextDisabledWarning: string;
            textColorGhostWarning: string;
            textColorGhostHoverWarning: string;
            textColorGhostPressedWarning: string;
            textColorGhostFocusWarning: string;
            textColorGhostDisabledWarning: string;
            borderWarning: string;
            borderHoverWarning: string;
            borderPressedWarning: string;
            borderFocusWarning: string;
            borderDisabledWarning: string;
            rippleColorWarning: string;
            colorError: string;
            colorHoverError: string;
            colorPressedError: string;
            colorFocusError: string;
            colorDisabledError: string;
            textColorError: string;
            textColorHoverError: string;
            textColorPressedError: string;
            textColorFocusError: string;
            textColorDisabledError: string;
            textColorTextError: string;
            textColorTextHoverError: string;
            textColorTextPressedError: string;
            textColorTextFocusError: string;
            textColorTextDisabledError: string;
            textColorGhostError: string;
            textColorGhostHoverError: string;
            textColorGhostPressedError: string;
            textColorGhostFocusError: string;
            textColorGhostDisabledError: string;
            borderError: string;
            borderHoverError: string;
            borderPressedError: string;
            borderFocusError: string;
            borderDisabledError: string;
            rippleColorError: string;
            waveOpacity: string;
            fontWeight: string;
            fontWeightStrong: string;
            paddingTiny: string;
            paddingSmall: string;
            paddingMedium: string;
            paddingLarge: string;
            paddingRoundTiny: string;
            paddingRoundSmall: string;
            paddingRoundMedium: string;
            paddingRoundLarge: string;
            iconMarginTiny: string;
            iconMarginSmall: string;
            iconMarginMedium: string;
            iconMarginLarge: string;
            iconSizeTiny: string;
            iconSizeSmall: string;
            iconSizeMedium: string;
            iconSizeLarge: string;
            rippleDuration: string;
        }, any>;
    }>>>;
    readonly builtinThemeOverrides: PropType<import("../../_mixins/use-theme").ExtractThemeOverrides<import("../../_mixins").Theme<"ColorPicker", {
        panelFontSize: string;
        boxShadow: string;
        color: string;
        textColor: string;
        borderRadius: string;
        border: string;
        heightSmall: string;
        heightMedium: string;
        heightLarge: string;
        fontSizeSmall: string;
        fontSizeMedium: string;
        fontSizeLarge: string;
        dividerColor: string;
    }, {
        Input: import("../../_mixins").Theme<"Input", {
            countTextColorDisabled: string;
            countTextColor: string;
            heightTiny: string;
            heightSmall: string;
            heightMedium: string;
            heightLarge: string;
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            lineHeight: string;
            lineHeightTextarea: string;
            borderRadius: string;
            iconSize: string;
            groupLabelColor: string;
            groupLabelTextColor: string;
            textColor: string;
            textColorDisabled: string;
            textDecorationColor: string;
            caretColor: string;
            placeholderColor: string;
            placeholderColorDisabled: string;
            color: string;
            colorDisabled: string;
            colorFocus: string;
            groupLabelBorder: string;
            border: string;
            borderHover: string;
            borderDisabled: string;
            borderFocus: string;
            boxShadowFocus: string;
            loadingColor: string;
            loadingColorWarning: string;
            borderWarning: string;
            borderHoverWarning: string;
            colorFocusWarning: string;
            borderFocusWarning: string;
            boxShadowFocusWarning: string;
            caretColorWarning: string;
            loadingColorError: string;
            borderError: string;
            borderHoverError: string;
            colorFocusError: string;
            borderFocusError: string;
            boxShadowFocusError: string;
            caretColorError: string;
            clearColor: string;
            clearColorHover: string;
            clearColorPressed: string;
            iconColor: string;
            iconColorDisabled: string;
            iconColorHover: string;
            iconColorPressed: string;
            suffixTextColor: string;
            paddingTiny: string;
            paddingSmall: string;
            paddingMedium: string;
            paddingLarge: string;
            clearSize: string;
        }, any>;
        Button: import("../../_mixins").Theme<"Button", {
            heightTiny: string;
            heightSmall: string;
            heightMedium: string;
            heightLarge: string;
            borderRadiusTiny: string;
            borderRadiusSmall: string;
            borderRadiusMedium: string;
            borderRadiusLarge: string;
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            opacityDisabled: string;
            colorOpacitySecondary: string;
            colorOpacitySecondaryHover: string;
            colorOpacitySecondaryPressed: string;
            colorSecondary: string;
            colorSecondaryHover: string;
            colorSecondaryPressed: string;
            colorTertiary: string;
            colorTertiaryHover: string;
            colorTertiaryPressed: string;
            colorQuaternary: string;
            colorQuaternaryHover: string;
            colorQuaternaryPressed: string;
            color: string;
            colorHover: string;
            colorPressed: string;
            colorFocus: string;
            colorDisabled: string;
            textColor: string;
            textColorTertiary: string;
            textColorHover: string;
            textColorPressed: string;
            textColorFocus: string;
            textColorDisabled: string;
            textColorText: string;
            textColorTextHover: string;
            textColorTextPressed: string;
            textColorTextFocus: string;
            textColorTextDisabled: string;
            textColorGhost: string;
            textColorGhostHover: string;
            textColorGhostPressed: string;
            textColorGhostFocus: string;
            textColorGhostDisabled: string;
            border: string;
            borderHover: string;
            borderPressed: string;
            borderFocus: string;
            borderDisabled: string;
            rippleColor: string;
            colorPrimary: string;
            colorHoverPrimary: string;
            colorPressedPrimary: string;
            colorFocusPrimary: string;
            colorDisabledPrimary: string;
            textColorPrimary: string;
            textColorHoverPrimary: string;
            textColorPressedPrimary: string;
            textColorFocusPrimary: string;
            textColorDisabledPrimary: string;
            textColorTextPrimary: string;
            textColorTextHoverPrimary: string;
            textColorTextPressedPrimary: string;
            textColorTextFocusPrimary: string;
            textColorTextDisabledPrimary: string;
            textColorGhostPrimary: string;
            textColorGhostHoverPrimary: string;
            textColorGhostPressedPrimary: string;
            textColorGhostFocusPrimary: string;
            textColorGhostDisabledPrimary: string;
            borderPrimary: string;
            borderHoverPrimary: string;
            borderPressedPrimary: string;
            borderFocusPrimary: string;
            borderDisabledPrimary: string;
            rippleColorPrimary: string;
            colorInfo: string;
            colorHoverInfo: string;
            colorPressedInfo: string;
            colorFocusInfo: string;
            colorDisabledInfo: string;
            textColorInfo: string;
            textColorHoverInfo: string;
            textColorPressedInfo: string;
            textColorFocusInfo: string;
            textColorDisabledInfo: string;
            textColorTextInfo: string;
            textColorTextHoverInfo: string;
            textColorTextPressedInfo: string;
            textColorTextFocusInfo: string;
            textColorTextDisabledInfo: string;
            textColorGhostInfo: string;
            textColorGhostHoverInfo: string;
            textColorGhostPressedInfo: string;
            textColorGhostFocusInfo: string;
            textColorGhostDisabledInfo: string;
            borderInfo: string;
            borderHoverInfo: string;
            borderPressedInfo: string;
            borderFocusInfo: string;
            borderDisabledInfo: string;
            rippleColorInfo: string;
            colorSuccess: string;
            colorHoverSuccess: string;
            colorPressedSuccess: string;
            colorFocusSuccess: string;
            colorDisabledSuccess: string;
            textColorSuccess: string;
            textColorHoverSuccess: string;
            textColorPressedSuccess: string;
            textColorFocusSuccess: string;
            textColorDisabledSuccess: string;
            textColorTextSuccess: string;
            textColorTextHoverSuccess: string;
            textColorTextPressedSuccess: string;
            textColorTextFocusSuccess: string;
            textColorTextDisabledSuccess: string;
            textColorGhostSuccess: string;
            textColorGhostHoverSuccess: string;
            textColorGhostPressedSuccess: string;
            textColorGhostFocusSuccess: string;
            textColorGhostDisabledSuccess: string;
            borderSuccess: string;
            borderHoverSuccess: string;
            borderPressedSuccess: string;
            borderFocusSuccess: string;
            borderDisabledSuccess: string;
            rippleColorSuccess: string;
            colorWarning: string;
            colorHoverWarning: string;
            colorPressedWarning: string;
            colorFocusWarning: string;
            colorDisabledWarning: string;
            textColorWarning: string;
            textColorHoverWarning: string;
            textColorPressedWarning: string;
            textColorFocusWarning: string;
            textColorDisabledWarning: string;
            textColorTextWarning: string;
            textColorTextHoverWarning: string;
            textColorTextPressedWarning: string;
            textColorTextFocusWarning: string;
            textColorTextDisabledWarning: string;
            textColorGhostWarning: string;
            textColorGhostHoverWarning: string;
            textColorGhostPressedWarning: string;
            textColorGhostFocusWarning: string;
            textColorGhostDisabledWarning: string;
            borderWarning: string;
            borderHoverWarning: string;
            borderPressedWarning: string;
            borderFocusWarning: string;
            borderDisabledWarning: string;
            rippleColorWarning: string;
            colorError: string;
            colorHoverError: string;
            colorPressedError: string;
            colorFocusError: string;
            colorDisabledError: string;
            textColorError: string;
            textColorHoverError: string;
            textColorPressedError: string;
            textColorFocusError: string;
            textColorDisabledError: string;
            textColorTextError: string;
            textColorTextHoverError: string;
            textColorTextPressedError: string;
            textColorTextFocusError: string;
            textColorTextDisabledError: string;
            textColorGhostError: string;
            textColorGhostHoverError: string;
            textColorGhostPressedError: string;
            textColorGhostFocusError: string;
            textColorGhostDisabledError: string;
            borderError: string;
            borderHoverError: string;
            borderPressedError: string;
            borderFocusError: string;
            borderDisabledError: string;
            rippleColorError: string;
            waveOpacity: string;
            fontWeight: string;
            fontWeightStrong: string;
            paddingTiny: string;
            paddingSmall: string;
            paddingMedium: string;
            paddingLarge: string;
            paddingRoundTiny: string;
            paddingRoundSmall: string;
            paddingRoundMedium: string;
            paddingRoundLarge: string;
            iconMarginTiny: string;
            iconMarginSmall: string;
            iconMarginMedium: string;
            iconMarginLarge: string;
            iconSizeTiny: string;
            iconSizeSmall: string;
            iconSizeMedium: string;
            iconSizeLarge: string;
            rippleDuration: string;
        }, any>;
    }>>>;
};
export type ColorPickerProps = ExtractPublicPropTypes<typeof colorPickerProps>;
declare const _default: import("vue").DefineComponent<{
    readonly value: PropType<string | null>;
    readonly show: {
        readonly type: PropType<boolean | undefined>;
        readonly default: undefined;
    };
    readonly defaultShow: BooleanConstructor;
    readonly defaultValue: PropType<string | null>;
    readonly modes: {
        readonly type: PropType<ColorPickerMode[]>;
        readonly default: () => string[];
    };
    readonly placement: {
        readonly type: PropType<FollowerPlacement>;
        readonly default: "bottom-start";
    };
    readonly to: {
        type: PropType<HTMLElement | string | boolean>;
        default: undefined;
    };
    readonly showAlpha: {
        readonly type: BooleanConstructor;
        readonly default: true;
    };
    readonly showPreview: BooleanConstructor;
    readonly swatches: PropType<string[]>;
    readonly disabled: {
        readonly type: PropType<boolean | undefined>;
        readonly default: undefined;
    };
    readonly actions: {
        readonly type: PropType<ActionType[]>;
        readonly default: null;
    };
    readonly internalActions: PropType<ReadonlyArray<"redo" | "undo">>;
    readonly size: PropType<"small" | "medium" | "large">;
    readonly renderLabel: PropType<RenderLabel>;
    readonly onComplete: PropType<OnUpdateValue>;
    readonly onConfirm: PropType<OnUpdateValue>;
    readonly onClear: PropType<OnClear>;
    readonly 'onUpdate:show': PropType<MaybeArray<(value: boolean) => void>>;
    readonly onUpdateShow: PropType<MaybeArray<(value: boolean) => void>>;
    readonly 'onUpdate:value': PropType<MaybeArray<OnUpdateValue>>;
    readonly onUpdateValue: PropType<MaybeArray<OnUpdateValue>>;
    readonly theme: PropType<import("../../_mixins").Theme<"ColorPicker", {
        panelFontSize: string;
        boxShadow: string;
        color: string;
        textColor: string;
        borderRadius: string;
        border: string;
        heightSmall: string;
        heightMedium: string;
        heightLarge: string;
        fontSizeSmall: string;
        fontSizeMedium: string;
        fontSizeLarge: string;
        dividerColor: string;
    }, {
        Input: import("../../_mixins").Theme<"Input", {
            countTextColorDisabled: string;
            countTextColor: string;
            heightTiny: string;
            heightSmall: string;
            heightMedium: string;
            heightLarge: string;
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            lineHeight: string;
            lineHeightTextarea: string;
            borderRadius: string;
            iconSize: string;
            groupLabelColor: string;
            groupLabelTextColor: string;
            textColor: string;
            textColorDisabled: string;
            textDecorationColor: string;
            caretColor: string;
            placeholderColor: string;
            placeholderColorDisabled: string;
            color: string;
            colorDisabled: string;
            colorFocus: string;
            groupLabelBorder: string;
            border: string;
            borderHover: string;
            borderDisabled: string;
            borderFocus: string;
            boxShadowFocus: string;
            loadingColor: string;
            loadingColorWarning: string;
            borderWarning: string;
            borderHoverWarning: string;
            colorFocusWarning: string;
            borderFocusWarning: string;
            boxShadowFocusWarning: string;
            caretColorWarning: string;
            loadingColorError: string;
            borderError: string;
            borderHoverError: string;
            colorFocusError: string;
            borderFocusError: string;
            boxShadowFocusError: string;
            caretColorError: string;
            clearColor: string;
            clearColorHover: string;
            clearColorPressed: string;
            iconColor: string;
            iconColorDisabled: string;
            iconColorHover: string;
            iconColorPressed: string;
            suffixTextColor: string;
            paddingTiny: string;
            paddingSmall: string;
            paddingMedium: string;
            paddingLarge: string;
            clearSize: string;
        }, any>;
        Button: import("../../_mixins").Theme<"Button", {
            heightTiny: string;
            heightSmall: string;
            heightMedium: string;
            heightLarge: string;
            borderRadiusTiny: string;
            borderRadiusSmall: string;
            borderRadiusMedium: string;
            borderRadiusLarge: string;
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            opacityDisabled: string;
            colorOpacitySecondary: string;
            colorOpacitySecondaryHover: string;
            colorOpacitySecondaryPressed: string;
            colorSecondary: string;
            colorSecondaryHover: string;
            colorSecondaryPressed: string;
            colorTertiary: string;
            colorTertiaryHover: string;
            colorTertiaryPressed: string;
            colorQuaternary: string;
            colorQuaternaryHover: string;
            colorQuaternaryPressed: string;
            color: string;
            colorHover: string;
            colorPressed: string;
            colorFocus: string;
            colorDisabled: string;
            textColor: string;
            textColorTertiary: string;
            textColorHover: string;
            textColorPressed: string;
            textColorFocus: string;
            textColorDisabled: string;
            textColorText: string;
            textColorTextHover: string;
            textColorTextPressed: string;
            textColorTextFocus: string;
            textColorTextDisabled: string;
            textColorGhost: string;
            textColorGhostHover: string;
            textColorGhostPressed: string;
            textColorGhostFocus: string;
            textColorGhostDisabled: string;
            border: string;
            borderHover: string;
            borderPressed: string;
            borderFocus: string;
            borderDisabled: string;
            rippleColor: string;
            colorPrimary: string;
            colorHoverPrimary: string;
            colorPressedPrimary: string;
            colorFocusPrimary: string;
            colorDisabledPrimary: string;
            textColorPrimary: string;
            textColorHoverPrimary: string;
            textColorPressedPrimary: string;
            textColorFocusPrimary: string;
            textColorDisabledPrimary: string;
            textColorTextPrimary: string;
            textColorTextHoverPrimary: string;
            textColorTextPressedPrimary: string;
            textColorTextFocusPrimary: string;
            textColorTextDisabledPrimary: string;
            textColorGhostPrimary: string;
            textColorGhostHoverPrimary: string;
            textColorGhostPressedPrimary: string;
            textColorGhostFocusPrimary: string;
            textColorGhostDisabledPrimary: string;
            borderPrimary: string;
            borderHoverPrimary: string;
            borderPressedPrimary: string;
            borderFocusPrimary: string;
            borderDisabledPrimary: string;
            rippleColorPrimary: string;
            colorInfo: string;
            colorHoverInfo: string;
            colorPressedInfo: string;
            colorFocusInfo: string;
            colorDisabledInfo: string;
            textColorInfo: string;
            textColorHoverInfo: string;
            textColorPressedInfo: string;
            textColorFocusInfo: string;
            textColorDisabledInfo: string;
            textColorTextInfo: string;
            textColorTextHoverInfo: string;
            textColorTextPressedInfo: string;
            textColorTextFocusInfo: string;
            textColorTextDisabledInfo: string;
            textColorGhostInfo: string;
            textColorGhostHoverInfo: string;
            textColorGhostPressedInfo: string;
            textColorGhostFocusInfo: string;
            textColorGhostDisabledInfo: string;
            borderInfo: string;
            borderHoverInfo: string;
            borderPressedInfo: string;
            borderFocusInfo: string;
            borderDisabledInfo: string;
            rippleColorInfo: string;
            colorSuccess: string;
            colorHoverSuccess: string;
            colorPressedSuccess: string;
            colorFocusSuccess: string;
            colorDisabledSuccess: string;
            textColorSuccess: string;
            textColorHoverSuccess: string;
            textColorPressedSuccess: string;
            textColorFocusSuccess: string;
            textColorDisabledSuccess: string;
            textColorTextSuccess: string;
            textColorTextHoverSuccess: string;
            textColorTextPressedSuccess: string;
            textColorTextFocusSuccess: string;
            textColorTextDisabledSuccess: string;
            textColorGhostSuccess: string;
            textColorGhostHoverSuccess: string;
            textColorGhostPressedSuccess: string;
            textColorGhostFocusSuccess: string;
            textColorGhostDisabledSuccess: string;
            borderSuccess: string;
            borderHoverSuccess: string;
            borderPressedSuccess: string;
            borderFocusSuccess: string;
            borderDisabledSuccess: string;
            rippleColorSuccess: string;
            colorWarning: string;
            colorHoverWarning: string;
            colorPressedWarning: string;
            colorFocusWarning: string;
            colorDisabledWarning: string;
            textColorWarning: string;
            textColorHoverWarning: string;
            textColorPressedWarning: string;
            textColorFocusWarning: string;
            textColorDisabledWarning: string;
            textColorTextWarning: string;
            textColorTextHoverWarning: string;
            textColorTextPressedWarning: string;
            textColorTextFocusWarning: string;
            textColorTextDisabledWarning: string;
            textColorGhostWarning: string;
            textColorGhostHoverWarning: string;
            textColorGhostPressedWarning: string;
            textColorGhostFocusWarning: string;
            textColorGhostDisabledWarning: string;
            borderWarning: string;
            borderHoverWarning: string;
            borderPressedWarning: string;
            borderFocusWarning: string;
            borderDisabledWarning: string;
            rippleColorWarning: string;
            colorError: string;
            colorHoverError: string;
            colorPressedError: string;
            colorFocusError: string;
            colorDisabledError: string;
            textColorError: string;
            textColorHoverError: string;
            textColorPressedError: string;
            textColorFocusError: string;
            textColorDisabledError: string;
            textColorTextError: string;
            textColorTextHoverError: string;
            textColorTextPressedError: string;
            textColorTextFocusError: string;
            textColorTextDisabledError: string;
            textColorGhostError: string;
            textColorGhostHoverError: string;
            textColorGhostPressedError: string;
            textColorGhostFocusError: string;
            textColorGhostDisabledError: string;
            borderError: string;
            borderHoverError: string;
            borderPressedError: string;
            borderFocusError: string;
            borderDisabledError: string;
            rippleColorError: string;
            waveOpacity: string;
            fontWeight: string;
            fontWeightStrong: string;
            paddingTiny: string;
            paddingSmall: string;
            paddingMedium: string;
            paddingLarge: string;
            paddingRoundTiny: string;
            paddingRoundSmall: string;
            paddingRoundMedium: string;
            paddingRoundLarge: string;
            iconMarginTiny: string;
            iconMarginSmall: string;
            iconMarginMedium: string;
            iconMarginLarge: string;
            iconSizeTiny: string;
            iconSizeSmall: string;
            iconSizeMedium: string;
            iconSizeLarge: string;
            rippleDuration: string;
        }, any>;
    }>>;
    readonly themeOverrides: PropType<import("../../_mixins/use-theme").ExtractThemeOverrides<import("../../_mixins").Theme<"ColorPicker", {
        panelFontSize: string;
        boxShadow: string;
        color: string;
        textColor: string;
        borderRadius: string;
        border: string;
        heightSmall: string;
        heightMedium: string;
        heightLarge: string;
        fontSizeSmall: string;
        fontSizeMedium: string;
        fontSizeLarge: string;
        dividerColor: string;
    }, {
        Input: import("../../_mixins").Theme<"Input", {
            countTextColorDisabled: string;
            countTextColor: string;
            heightTiny: string;
            heightSmall: string;
            heightMedium: string;
            heightLarge: string;
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            lineHeight: string;
            lineHeightTextarea: string;
            borderRadius: string;
            iconSize: string;
            groupLabelColor: string;
            groupLabelTextColor: string;
            textColor: string;
            textColorDisabled: string;
            textDecorationColor: string;
            caretColor: string;
            placeholderColor: string;
            placeholderColorDisabled: string;
            color: string;
            colorDisabled: string;
            colorFocus: string;
            groupLabelBorder: string;
            border: string;
            borderHover: string;
            borderDisabled: string;
            borderFocus: string;
            boxShadowFocus: string;
            loadingColor: string;
            loadingColorWarning: string;
            borderWarning: string;
            borderHoverWarning: string;
            colorFocusWarning: string;
            borderFocusWarning: string;
            boxShadowFocusWarning: string;
            caretColorWarning: string;
            loadingColorError: string;
            borderError: string;
            borderHoverError: string;
            colorFocusError: string;
            borderFocusError: string;
            boxShadowFocusError: string;
            caretColorError: string;
            clearColor: string;
            clearColorHover: string;
            clearColorPressed: string;
            iconColor: string;
            iconColorDisabled: string;
            iconColorHover: string;
            iconColorPressed: string;
            suffixTextColor: string;
            paddingTiny: string;
            paddingSmall: string;
            paddingMedium: string;
            paddingLarge: string;
            clearSize: string;
        }, any>;
        Button: import("../../_mixins").Theme<"Button", {
            heightTiny: string;
            heightSmall: string;
            heightMedium: string;
            heightLarge: string;
            borderRadiusTiny: string;
            borderRadiusSmall: string;
            borderRadiusMedium: string;
            borderRadiusLarge: string;
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            opacityDisabled: string;
            colorOpacitySecondary: string;
            colorOpacitySecondaryHover: string;
            colorOpacitySecondaryPressed: string;
            colorSecondary: string;
            colorSecondaryHover: string;
            colorSecondaryPressed: string;
            colorTertiary: string;
            colorTertiaryHover: string;
            colorTertiaryPressed: string;
            colorQuaternary: string;
            colorQuaternaryHover: string;
            colorQuaternaryPressed: string;
            color: string;
            colorHover: string;
            colorPressed: string;
            colorFocus: string;
            colorDisabled: string;
            textColor: string;
            textColorTertiary: string;
            textColorHover: string;
            textColorPressed: string;
            textColorFocus: string;
            textColorDisabled: string;
            textColorText: string;
            textColorTextHover: string;
            textColorTextPressed: string;
            textColorTextFocus: string;
            textColorTextDisabled: string;
            textColorGhost: string;
            textColorGhostHover: string;
            textColorGhostPressed: string;
            textColorGhostFocus: string;
            textColorGhostDisabled: string;
            border: string;
            borderHover: string;
            borderPressed: string;
            borderFocus: string;
            borderDisabled: string;
            rippleColor: string;
            colorPrimary: string;
            colorHoverPrimary: string;
            colorPressedPrimary: string;
            colorFocusPrimary: string;
            colorDisabledPrimary: string;
            textColorPrimary: string;
            textColorHoverPrimary: string;
            textColorPressedPrimary: string;
            textColorFocusPrimary: string;
            textColorDisabledPrimary: string;
            textColorTextPrimary: string;
            textColorTextHoverPrimary: string;
            textColorTextPressedPrimary: string;
            textColorTextFocusPrimary: string;
            textColorTextDisabledPrimary: string;
            textColorGhostPrimary: string;
            textColorGhostHoverPrimary: string;
            textColorGhostPressedPrimary: string;
            textColorGhostFocusPrimary: string;
            textColorGhostDisabledPrimary: string;
            borderPrimary: string;
            borderHoverPrimary: string;
            borderPressedPrimary: string;
            borderFocusPrimary: string;
            borderDisabledPrimary: string;
            rippleColorPrimary: string;
            colorInfo: string;
            colorHoverInfo: string;
            colorPressedInfo: string;
            colorFocusInfo: string;
            colorDisabledInfo: string;
            textColorInfo: string;
            textColorHoverInfo: string;
            textColorPressedInfo: string;
            textColorFocusInfo: string;
            textColorDisabledInfo: string;
            textColorTextInfo: string;
            textColorTextHoverInfo: string;
            textColorTextPressedInfo: string;
            textColorTextFocusInfo: string;
            textColorTextDisabledInfo: string;
            textColorGhostInfo: string;
            textColorGhostHoverInfo: string;
            textColorGhostPressedInfo: string;
            textColorGhostFocusInfo: string;
            textColorGhostDisabledInfo: string;
            borderInfo: string;
            borderHoverInfo: string;
            borderPressedInfo: string;
            borderFocusInfo: string;
            borderDisabledInfo: string;
            rippleColorInfo: string;
            colorSuccess: string;
            colorHoverSuccess: string;
            colorPressedSuccess: string;
            colorFocusSuccess: string;
            colorDisabledSuccess: string;
            textColorSuccess: string;
            textColorHoverSuccess: string;
            textColorPressedSuccess: string;
            textColorFocusSuccess: string;
            textColorDisabledSuccess: string;
            textColorTextSuccess: string;
            textColorTextHoverSuccess: string;
            textColorTextPressedSuccess: string;
            textColorTextFocusSuccess: string;
            textColorTextDisabledSuccess: string;
            textColorGhostSuccess: string;
            textColorGhostHoverSuccess: string;
            textColorGhostPressedSuccess: string;
            textColorGhostFocusSuccess: string;
            textColorGhostDisabledSuccess: string;
            borderSuccess: string;
            borderHoverSuccess: string;
            borderPressedSuccess: string;
            borderFocusSuccess: string;
            borderDisabledSuccess: string;
            rippleColorSuccess: string;
            colorWarning: string;
            colorHoverWarning: string;
            colorPressedWarning: string;
            colorFocusWarning: string;
            colorDisabledWarning: string;
            textColorWarning: string;
            textColorHoverWarning: string;
            textColorPressedWarning: string;
            textColorFocusWarning: string;
            textColorDisabledWarning: string;
            textColorTextWarning: string;
            textColorTextHoverWarning: string;
            textColorTextPressedWarning: string;
            textColorTextFocusWarning: string;
            textColorTextDisabledWarning: string;
            textColorGhostWarning: string;
            textColorGhostHoverWarning: string;
            textColorGhostPressedWarning: string;
            textColorGhostFocusWarning: string;
            textColorGhostDisabledWarning: string;
            borderWarning: string;
            borderHoverWarning: string;
            borderPressedWarning: string;
            borderFocusWarning: string;
            borderDisabledWarning: string;
            rippleColorWarning: string;
            colorError: string;
            colorHoverError: string;
            colorPressedError: string;
            colorFocusError: string;
            colorDisabledError: string;
            textColorError: string;
            textColorHoverError: string;
            textColorPressedError: string;
            textColorFocusError: string;
            textColorDisabledError: string;
            textColorTextError: string;
            textColorTextHoverError: string;
            textColorTextPressedError: string;
            textColorTextFocusError: string;
            textColorTextDisabledError: string;
            textColorGhostError: string;
            textColorGhostHoverError: string;
            textColorGhostPressedError: string;
            textColorGhostFocusError: string;
            textColorGhostDisabledError: string;
            borderError: string;
            borderHoverError: string;
            borderPressedError: string;
            borderFocusError: string;
            borderDisabledError: string;
            rippleColorError: string;
            waveOpacity: string;
            fontWeight: string;
            fontWeightStrong: string;
            paddingTiny: string;
            paddingSmall: string;
            paddingMedium: string;
            paddingLarge: string;
            paddingRoundTiny: string;
            paddingRoundSmall: string;
            paddingRoundMedium: string;
            paddingRoundLarge: string;
            iconMarginTiny: string;
            iconMarginSmall: string;
            iconMarginMedium: string;
            iconMarginLarge: string;
            iconSizeTiny: string;
            iconSizeSmall: string;
            iconSizeMedium: string;
            iconSizeLarge: string;
            rippleDuration: string;
        }, any>;
    }>>>;
    readonly builtinThemeOverrides: PropType<import("../../_mixins/use-theme").ExtractThemeOverrides<import("../../_mixins").Theme<"ColorPicker", {
        panelFontSize: string;
        boxShadow: string;
        color: string;
        textColor: string;
        borderRadius: string;
        border: string;
        heightSmall: string;
        heightMedium: string;
        heightLarge: string;
        fontSizeSmall: string;
        fontSizeMedium: string;
        fontSizeLarge: string;
        dividerColor: string;
    }, {
        Input: import("../../_mixins").Theme<"Input", {
            countTextColorDisabled: string;
            countTextColor: string;
            heightTiny: string;
            heightSmall: string;
            heightMedium: string;
            heightLarge: string;
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            lineHeight: string;
            lineHeightTextarea: string;
            borderRadius: string;
            iconSize: string;
            groupLabelColor: string;
            groupLabelTextColor: string;
            textColor: string;
            textColorDisabled: string;
            textDecorationColor: string;
            caretColor: string;
            placeholderColor: string;
            placeholderColorDisabled: string;
            color: string;
            colorDisabled: string;
            colorFocus: string;
            groupLabelBorder: string;
            border: string;
            borderHover: string;
            borderDisabled: string;
            borderFocus: string;
            boxShadowFocus: string;
            loadingColor: string;
            loadingColorWarning: string;
            borderWarning: string;
            borderHoverWarning: string;
            colorFocusWarning: string;
            borderFocusWarning: string;
            boxShadowFocusWarning: string;
            caretColorWarning: string;
            loadingColorError: string;
            borderError: string;
            borderHoverError: string;
            colorFocusError: string;
            borderFocusError: string;
            boxShadowFocusError: string;
            caretColorError: string;
            clearColor: string;
            clearColorHover: string;
            clearColorPressed: string;
            iconColor: string;
            iconColorDisabled: string;
            iconColorHover: string;
            iconColorPressed: string;
            suffixTextColor: string;
            paddingTiny: string;
            paddingSmall: string;
            paddingMedium: string;
            paddingLarge: string;
            clearSize: string;
        }, any>;
        Button: import("../../_mixins").Theme<"Button", {
            heightTiny: string;
            heightSmall: string;
            heightMedium: string;
            heightLarge: string;
            borderRadiusTiny: string;
            borderRadiusSmall: string;
            borderRadiusMedium: string;
            borderRadiusLarge: string;
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            opacityDisabled: string;
            colorOpacitySecondary: string;
            colorOpacitySecondaryHover: string;
            colorOpacitySecondaryPressed: string;
            colorSecondary: string;
            colorSecondaryHover: string;
            colorSecondaryPressed: string;
            colorTertiary: string;
            colorTertiaryHover: string;
            colorTertiaryPressed: string;
            colorQuaternary: string;
            colorQuaternaryHover: string;
            colorQuaternaryPressed: string;
            color: string;
            colorHover: string;
            colorPressed: string;
            colorFocus: string;
            colorDisabled: string;
            textColor: string;
            textColorTertiary: string;
            textColorHover: string;
            textColorPressed: string;
            textColorFocus: string;
            textColorDisabled: string;
            textColorText: string;
            textColorTextHover: string;
            textColorTextPressed: string;
            textColorTextFocus: string;
            textColorTextDisabled: string;
            textColorGhost: string;
            textColorGhostHover: string;
            textColorGhostPressed: string;
            textColorGhostFocus: string;
            textColorGhostDisabled: string;
            border: string;
            borderHover: string;
            borderPressed: string;
            borderFocus: string;
            borderDisabled: string;
            rippleColor: string;
            colorPrimary: string;
            colorHoverPrimary: string;
            colorPressedPrimary: string;
            colorFocusPrimary: string;
            colorDisabledPrimary: string;
            textColorPrimary: string;
            textColorHoverPrimary: string;
            textColorPressedPrimary: string;
            textColorFocusPrimary: string;
            textColorDisabledPrimary: string;
            textColorTextPrimary: string;
            textColorTextHoverPrimary: string;
            textColorTextPressedPrimary: string;
            textColorTextFocusPrimary: string;
            textColorTextDisabledPrimary: string;
            textColorGhostPrimary: string;
            textColorGhostHoverPrimary: string;
            textColorGhostPressedPrimary: string;
            textColorGhostFocusPrimary: string;
            textColorGhostDisabledPrimary: string;
            borderPrimary: string;
            borderHoverPrimary: string;
            borderPressedPrimary: string;
            borderFocusPrimary: string;
            borderDisabledPrimary: string;
            rippleColorPrimary: string;
            colorInfo: string;
            colorHoverInfo: string;
            colorPressedInfo: string;
            colorFocusInfo: string;
            colorDisabledInfo: string;
            textColorInfo: string;
            textColorHoverInfo: string;
            textColorPressedInfo: string;
            textColorFocusInfo: string;
            textColorDisabledInfo: string;
            textColorTextInfo: string;
            textColorTextHoverInfo: string;
            textColorTextPressedInfo: string;
            textColorTextFocusInfo: string;
            textColorTextDisabledInfo: string;
            textColorGhostInfo: string;
            textColorGhostHoverInfo: string;
            textColorGhostPressedInfo: string;
            textColorGhostFocusInfo: string;
            textColorGhostDisabledInfo: string;
            borderInfo: string;
            borderHoverInfo: string;
            borderPressedInfo: string;
            borderFocusInfo: string;
            borderDisabledInfo: string;
            rippleColorInfo: string;
            colorSuccess: string;
            colorHoverSuccess: string;
            colorPressedSuccess: string;
            colorFocusSuccess: string;
            colorDisabledSuccess: string;
            textColorSuccess: string;
            textColorHoverSuccess: string;
            textColorPressedSuccess: string;
            textColorFocusSuccess: string;
            textColorDisabledSuccess: string;
            textColorTextSuccess: string;
            textColorTextHoverSuccess: string;
            textColorTextPressedSuccess: string;
            textColorTextFocusSuccess: string;
            textColorTextDisabledSuccess: string;
            textColorGhostSuccess: string;
            textColorGhostHoverSuccess: string;
            textColorGhostPressedSuccess: string;
            textColorGhostFocusSuccess: string;
            textColorGhostDisabledSuccess: string;
            borderSuccess: string;
            borderHoverSuccess: string;
            borderPressedSuccess: string;
            borderFocusSuccess: string;
            borderDisabledSuccess: string;
            rippleColorSuccess: string;
            colorWarning: string;
            colorHoverWarning: string;
            colorPressedWarning: string;
            colorFocusWarning: string;
            colorDisabledWarning: string;
            textColorWarning: string;
            textColorHoverWarning: string;
            textColorPressedWarning: string;
            textColorFocusWarning: string;
            textColorDisabledWarning: string;
            textColorTextWarning: string;
            textColorTextHoverWarning: string;
            textColorTextPressedWarning: string;
            textColorTextFocusWarning: string;
            textColorTextDisabledWarning: string;
            textColorGhostWarning: string;
            textColorGhostHoverWarning: string;
            textColorGhostPressedWarning: string;
            textColorGhostFocusWarning: string;
            textColorGhostDisabledWarning: string;
            borderWarning: string;
            borderHoverWarning: string;
            borderPressedWarning: string;
            borderFocusWarning: string;
            borderDisabledWarning: string;
            rippleColorWarning: string;
            colorError: string;
            colorHoverError: string;
            colorPressedError: string;
            colorFocusError: string;
            colorDisabledError: string;
            textColorError: string;
            textColorHoverError: string;
            textColorPressedError: string;
            textColorFocusError: string;
            textColorDisabledError: string;
            textColorTextError: string;
            textColorTextHoverError: string;
            textColorTextPressedError: string;
            textColorTextFocusError: string;
            textColorTextDisabledError: string;
            textColorGhostError: string;
            textColorGhostHoverError: string;
            textColorGhostPressedError: string;
            textColorGhostFocusError: string;
            textColorGhostDisabledError: string;
            borderError: string;
            borderHoverError: string;
            borderPressedError: string;
            borderFocusError: string;
            borderDisabledError: string;
            rippleColorError: string;
            waveOpacity: string;
            fontWeight: string;
            fontWeightStrong: string;
            paddingTiny: string;
            paddingSmall: string;
            paddingMedium: string;
            paddingLarge: string;
            paddingRoundTiny: string;
            paddingRoundSmall: string;
            paddingRoundMedium: string;
            paddingRoundLarge: string;
            iconMarginTiny: string;
            iconMarginSmall: string;
            iconMarginMedium: string;
            iconMarginLarge: string;
            iconSizeTiny: string;
            iconSizeSmall: string;
            iconSizeMedium: string;
            iconSizeLarge: string;
            rippleDuration: string;
        }, any>;
    }>>>;
}, {
    mergedClsPrefix: Ref<string>;
    namespace: import("vue").ComputedRef<string | undefined>;
    selfRef: Ref<HTMLElement | null>;
    hsla: import("vue").ComputedRef<HSLA | null>;
    rgba: import("vue").ComputedRef<RGBA | null>;
    mergedShow: import("vue").ComputedRef<boolean>;
    mergedDisabled: import("vue").ComputedRef<boolean>;
    isMounted: Readonly<Ref<boolean>>;
    adjustedTo: import("vue").ComputedRef<string | HTMLElement>;
    mergedValue: import("vue").ComputedRef<string | null>;
    handleTriggerClick(): void;
    handleClickOutside(e: MouseEvent): void;
    renderPanel: () => VNode;
    cssVars: import("vue").ComputedRef<{
        '--n-bezier': string;
        '--n-text-color': string;
        '--n-color': string;
        '--n-panel-font-size': string;
        '--n-font-size': string;
        '--n-box-shadow': string;
        '--n-border': string;
        '--n-border-radius': string;
        '--n-height': string;
        '--n-divider-color': string;
    }> | undefined;
    themeClass: Ref<string> | undefined;
    onRender: (() => void) | undefined;
}, unknown, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {}, string, import("vue").PublicProps, Readonly<import("vue").ExtractPropTypes<{
    readonly value: PropType<string | null>;
    readonly show: {
        readonly type: PropType<boolean | undefined>;
        readonly default: undefined;
    };
    readonly defaultShow: BooleanConstructor;
    readonly defaultValue: PropType<string | null>;
    readonly modes: {
        readonly type: PropType<ColorPickerMode[]>;
        readonly default: () => string[];
    };
    readonly placement: {
        readonly type: PropType<FollowerPlacement>;
        readonly default: "bottom-start";
    };
    readonly to: {
        type: PropType<HTMLElement | string | boolean>;
        default: undefined;
    };
    readonly showAlpha: {
        readonly type: BooleanConstructor;
        readonly default: true;
    };
    readonly showPreview: BooleanConstructor;
    readonly swatches: PropType<string[]>;
    readonly disabled: {
        readonly type: PropType<boolean | undefined>;
        readonly default: undefined;
    };
    readonly actions: {
        readonly type: PropType<ActionType[]>;
        readonly default: null;
    };
    readonly internalActions: PropType<ReadonlyArray<"redo" | "undo">>;
    readonly size: PropType<"small" | "medium" | "large">;
    readonly renderLabel: PropType<RenderLabel>;
    readonly onComplete: PropType<OnUpdateValue>;
    readonly onConfirm: PropType<OnUpdateValue>;
    readonly onClear: PropType<OnClear>;
    readonly 'onUpdate:show': PropType<MaybeArray<(value: boolean) => void>>;
    readonly onUpdateShow: PropType<MaybeArray<(value: boolean) => void>>;
    readonly 'onUpdate:value': PropType<MaybeArray<OnUpdateValue>>;
    readonly onUpdateValue: PropType<MaybeArray<OnUpdateValue>>;
    readonly theme: PropType<import("../../_mixins").Theme<"ColorPicker", {
        panelFontSize: string;
        boxShadow: string;
        color: string;
        textColor: string;
        borderRadius: string;
        border: string;
        heightSmall: string;
        heightMedium: string;
        heightLarge: string;
        fontSizeSmall: string;
        fontSizeMedium: string;
        fontSizeLarge: string;
        dividerColor: string;
    }, {
        Input: import("../../_mixins").Theme<"Input", {
            countTextColorDisabled: string;
            countTextColor: string;
            heightTiny: string;
            heightSmall: string;
            heightMedium: string;
            heightLarge: string;
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            lineHeight: string;
            lineHeightTextarea: string;
            borderRadius: string;
            iconSize: string;
            groupLabelColor: string;
            groupLabelTextColor: string;
            textColor: string;
            textColorDisabled: string;
            textDecorationColor: string;
            caretColor: string;
            placeholderColor: string;
            placeholderColorDisabled: string;
            color: string;
            colorDisabled: string;
            colorFocus: string;
            groupLabelBorder: string;
            border: string;
            borderHover: string;
            borderDisabled: string;
            borderFocus: string;
            boxShadowFocus: string;
            loadingColor: string;
            loadingColorWarning: string;
            borderWarning: string;
            borderHoverWarning: string;
            colorFocusWarning: string;
            borderFocusWarning: string;
            boxShadowFocusWarning: string;
            caretColorWarning: string;
            loadingColorError: string;
            borderError: string;
            borderHoverError: string;
            colorFocusError: string;
            borderFocusError: string;
            boxShadowFocusError: string;
            caretColorError: string;
            clearColor: string;
            clearColorHover: string;
            clearColorPressed: string;
            iconColor: string;
            iconColorDisabled: string;
            iconColorHover: string;
            iconColorPressed: string;
            suffixTextColor: string;
            paddingTiny: string;
            paddingSmall: string;
            paddingMedium: string;
            paddingLarge: string;
            clearSize: string;
        }, any>;
        Button: import("../../_mixins").Theme<"Button", {
            heightTiny: string;
            heightSmall: string;
            heightMedium: string;
            heightLarge: string;
            borderRadiusTiny: string;
            borderRadiusSmall: string;
            borderRadiusMedium: string;
            borderRadiusLarge: string;
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            opacityDisabled: string;
            colorOpacitySecondary: string;
            colorOpacitySecondaryHover: string;
            colorOpacitySecondaryPressed: string;
            colorSecondary: string;
            colorSecondaryHover: string;
            colorSecondaryPressed: string;
            colorTertiary: string;
            colorTertiaryHover: string;
            colorTertiaryPressed: string;
            colorQuaternary: string;
            colorQuaternaryHover: string;
            colorQuaternaryPressed: string;
            color: string;
            colorHover: string;
            colorPressed: string;
            colorFocus: string;
            colorDisabled: string;
            textColor: string;
            textColorTertiary: string;
            textColorHover: string;
            textColorPressed: string;
            textColorFocus: string;
            textColorDisabled: string;
            textColorText: string;
            textColorTextHover: string;
            textColorTextPressed: string;
            textColorTextFocus: string;
            textColorTextDisabled: string;
            textColorGhost: string;
            textColorGhostHover: string;
            textColorGhostPressed: string;
            textColorGhostFocus: string;
            textColorGhostDisabled: string;
            border: string;
            borderHover: string;
            borderPressed: string;
            borderFocus: string;
            borderDisabled: string;
            rippleColor: string;
            colorPrimary: string;
            colorHoverPrimary: string;
            colorPressedPrimary: string;
            colorFocusPrimary: string;
            colorDisabledPrimary: string;
            textColorPrimary: string;
            textColorHoverPrimary: string;
            textColorPressedPrimary: string;
            textColorFocusPrimary: string;
            textColorDisabledPrimary: string;
            textColorTextPrimary: string;
            textColorTextHoverPrimary: string;
            textColorTextPressedPrimary: string;
            textColorTextFocusPrimary: string;
            textColorTextDisabledPrimary: string;
            textColorGhostPrimary: string;
            textColorGhostHoverPrimary: string;
            textColorGhostPressedPrimary: string;
            textColorGhostFocusPrimary: string;
            textColorGhostDisabledPrimary: string;
            borderPrimary: string;
            borderHoverPrimary: string;
            borderPressedPrimary: string;
            borderFocusPrimary: string;
            borderDisabledPrimary: string;
            rippleColorPrimary: string;
            colorInfo: string;
            colorHoverInfo: string;
            colorPressedInfo: string;
            colorFocusInfo: string;
            colorDisabledInfo: string;
            textColorInfo: string;
            textColorHoverInfo: string;
            textColorPressedInfo: string;
            textColorFocusInfo: string;
            textColorDisabledInfo: string;
            textColorTextInfo: string;
            textColorTextHoverInfo: string;
            textColorTextPressedInfo: string;
            textColorTextFocusInfo: string;
            textColorTextDisabledInfo: string;
            textColorGhostInfo: string;
            textColorGhostHoverInfo: string;
            textColorGhostPressedInfo: string;
            textColorGhostFocusInfo: string;
            textColorGhostDisabledInfo: string;
            borderInfo: string;
            borderHoverInfo: string;
            borderPressedInfo: string;
            borderFocusInfo: string;
            borderDisabledInfo: string;
            rippleColorInfo: string;
            colorSuccess: string;
            colorHoverSuccess: string;
            colorPressedSuccess: string;
            colorFocusSuccess: string;
            colorDisabledSuccess: string;
            textColorSuccess: string;
            textColorHoverSuccess: string;
            textColorPressedSuccess: string;
            textColorFocusSuccess: string;
            textColorDisabledSuccess: string;
            textColorTextSuccess: string;
            textColorTextHoverSuccess: string;
            textColorTextPressedSuccess: string;
            textColorTextFocusSuccess: string;
            textColorTextDisabledSuccess: string;
            textColorGhostSuccess: string;
            textColorGhostHoverSuccess: string;
            textColorGhostPressedSuccess: string;
            textColorGhostFocusSuccess: string;
            textColorGhostDisabledSuccess: string;
            borderSuccess: string;
            borderHoverSuccess: string;
            borderPressedSuccess: string;
            borderFocusSuccess: string;
            borderDisabledSuccess: string;
            rippleColorSuccess: string;
            colorWarning: string;
            colorHoverWarning: string;
            colorPressedWarning: string;
            colorFocusWarning: string;
            colorDisabledWarning: string;
            textColorWarning: string;
            textColorHoverWarning: string;
            textColorPressedWarning: string;
            textColorFocusWarning: string;
            textColorDisabledWarning: string;
            textColorTextWarning: string;
            textColorTextHoverWarning: string;
            textColorTextPressedWarning: string;
            textColorTextFocusWarning: string;
            textColorTextDisabledWarning: string;
            textColorGhostWarning: string;
            textColorGhostHoverWarning: string;
            textColorGhostPressedWarning: string;
            textColorGhostFocusWarning: string;
            textColorGhostDisabledWarning: string;
            borderWarning: string;
            borderHoverWarning: string;
            borderPressedWarning: string;
            borderFocusWarning: string;
            borderDisabledWarning: string;
            rippleColorWarning: string;
            colorError: string;
            colorHoverError: string;
            colorPressedError: string;
            colorFocusError: string;
            colorDisabledError: string;
            textColorError: string;
            textColorHoverError: string;
            textColorPressedError: string;
            textColorFocusError: string;
            textColorDisabledError: string;
            textColorTextError: string;
            textColorTextHoverError: string;
            textColorTextPressedError: string;
            textColorTextFocusError: string;
            textColorTextDisabledError: string;
            textColorGhostError: string;
            textColorGhostHoverError: string;
            textColorGhostPressedError: string;
            textColorGhostFocusError: string;
            textColorGhostDisabledError: string;
            borderError: string;
            borderHoverError: string;
            borderPressedError: string;
            borderFocusError: string;
            borderDisabledError: string;
            rippleColorError: string;
            waveOpacity: string;
            fontWeight: string;
            fontWeightStrong: string;
            paddingTiny: string;
            paddingSmall: string;
            paddingMedium: string;
            paddingLarge: string;
            paddingRoundTiny: string;
            paddingRoundSmall: string;
            paddingRoundMedium: string;
            paddingRoundLarge: string;
            iconMarginTiny: string;
            iconMarginSmall: string;
            iconMarginMedium: string;
            iconMarginLarge: string;
            iconSizeTiny: string;
            iconSizeSmall: string;
            iconSizeMedium: string;
            iconSizeLarge: string;
            rippleDuration: string;
        }, any>;
    }>>;
    readonly themeOverrides: PropType<import("../../_mixins/use-theme").ExtractThemeOverrides<import("../../_mixins").Theme<"ColorPicker", {
        panelFontSize: string;
        boxShadow: string;
        color: string;
        textColor: string;
        borderRadius: string;
        border: string;
        heightSmall: string;
        heightMedium: string;
        heightLarge: string;
        fontSizeSmall: string;
        fontSizeMedium: string;
        fontSizeLarge: string;
        dividerColor: string;
    }, {
        Input: import("../../_mixins").Theme<"Input", {
            countTextColorDisabled: string;
            countTextColor: string;
            heightTiny: string;
            heightSmall: string;
            heightMedium: string;
            heightLarge: string;
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            lineHeight: string;
            lineHeightTextarea: string;
            borderRadius: string;
            iconSize: string;
            groupLabelColor: string;
            groupLabelTextColor: string;
            textColor: string;
            textColorDisabled: string;
            textDecorationColor: string;
            caretColor: string;
            placeholderColor: string;
            placeholderColorDisabled: string;
            color: string;
            colorDisabled: string;
            colorFocus: string;
            groupLabelBorder: string;
            border: string;
            borderHover: string;
            borderDisabled: string;
            borderFocus: string;
            boxShadowFocus: string;
            loadingColor: string;
            loadingColorWarning: string;
            borderWarning: string;
            borderHoverWarning: string;
            colorFocusWarning: string;
            borderFocusWarning: string;
            boxShadowFocusWarning: string;
            caretColorWarning: string;
            loadingColorError: string;
            borderError: string;
            borderHoverError: string;
            colorFocusError: string;
            borderFocusError: string;
            boxShadowFocusError: string;
            caretColorError: string;
            clearColor: string;
            clearColorHover: string;
            clearColorPressed: string;
            iconColor: string;
            iconColorDisabled: string;
            iconColorHover: string;
            iconColorPressed: string;
            suffixTextColor: string;
            paddingTiny: string;
            paddingSmall: string;
            paddingMedium: string;
            paddingLarge: string;
            clearSize: string;
        }, any>;
        Button: import("../../_mixins").Theme<"Button", {
            heightTiny: string;
            heightSmall: string;
            heightMedium: string;
            heightLarge: string;
            borderRadiusTiny: string;
            borderRadiusSmall: string;
            borderRadiusMedium: string;
            borderRadiusLarge: string;
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            opacityDisabled: string;
            colorOpacitySecondary: string;
            colorOpacitySecondaryHover: string;
            colorOpacitySecondaryPressed: string;
            colorSecondary: string;
            colorSecondaryHover: string;
            colorSecondaryPressed: string;
            colorTertiary: string;
            colorTertiaryHover: string;
            colorTertiaryPressed: string;
            colorQuaternary: string;
            colorQuaternaryHover: string;
            colorQuaternaryPressed: string;
            color: string;
            colorHover: string;
            colorPressed: string;
            colorFocus: string;
            colorDisabled: string;
            textColor: string;
            textColorTertiary: string;
            textColorHover: string;
            textColorPressed: string;
            textColorFocus: string;
            textColorDisabled: string;
            textColorText: string;
            textColorTextHover: string;
            textColorTextPressed: string;
            textColorTextFocus: string;
            textColorTextDisabled: string;
            textColorGhost: string;
            textColorGhostHover: string;
            textColorGhostPressed: string;
            textColorGhostFocus: string;
            textColorGhostDisabled: string;
            border: string;
            borderHover: string;
            borderPressed: string;
            borderFocus: string;
            borderDisabled: string;
            rippleColor: string;
            colorPrimary: string;
            colorHoverPrimary: string;
            colorPressedPrimary: string;
            colorFocusPrimary: string;
            colorDisabledPrimary: string;
            textColorPrimary: string;
            textColorHoverPrimary: string;
            textColorPressedPrimary: string;
            textColorFocusPrimary: string;
            textColorDisabledPrimary: string;
            textColorTextPrimary: string;
            textColorTextHoverPrimary: string;
            textColorTextPressedPrimary: string;
            textColorTextFocusPrimary: string;
            textColorTextDisabledPrimary: string;
            textColorGhostPrimary: string;
            textColorGhostHoverPrimary: string;
            textColorGhostPressedPrimary: string;
            textColorGhostFocusPrimary: string;
            textColorGhostDisabledPrimary: string;
            borderPrimary: string;
            borderHoverPrimary: string;
            borderPressedPrimary: string;
            borderFocusPrimary: string;
            borderDisabledPrimary: string;
            rippleColorPrimary: string;
            colorInfo: string;
            colorHoverInfo: string;
            colorPressedInfo: string;
            colorFocusInfo: string;
            colorDisabledInfo: string;
            textColorInfo: string;
            textColorHoverInfo: string;
            textColorPressedInfo: string;
            textColorFocusInfo: string;
            textColorDisabledInfo: string;
            textColorTextInfo: string;
            textColorTextHoverInfo: string;
            textColorTextPressedInfo: string;
            textColorTextFocusInfo: string;
            textColorTextDisabledInfo: string;
            textColorGhostInfo: string;
            textColorGhostHoverInfo: string;
            textColorGhostPressedInfo: string;
            textColorGhostFocusInfo: string;
            textColorGhostDisabledInfo: string;
            borderInfo: string;
            borderHoverInfo: string;
            borderPressedInfo: string;
            borderFocusInfo: string;
            borderDisabledInfo: string;
            rippleColorInfo: string;
            colorSuccess: string;
            colorHoverSuccess: string;
            colorPressedSuccess: string;
            colorFocusSuccess: string;
            colorDisabledSuccess: string;
            textColorSuccess: string;
            textColorHoverSuccess: string;
            textColorPressedSuccess: string;
            textColorFocusSuccess: string;
            textColorDisabledSuccess: string;
            textColorTextSuccess: string;
            textColorTextHoverSuccess: string;
            textColorTextPressedSuccess: string;
            textColorTextFocusSuccess: string;
            textColorTextDisabledSuccess: string;
            textColorGhostSuccess: string;
            textColorGhostHoverSuccess: string;
            textColorGhostPressedSuccess: string;
            textColorGhostFocusSuccess: string;
            textColorGhostDisabledSuccess: string;
            borderSuccess: string;
            borderHoverSuccess: string;
            borderPressedSuccess: string;
            borderFocusSuccess: string;
            borderDisabledSuccess: string;
            rippleColorSuccess: string;
            colorWarning: string;
            colorHoverWarning: string;
            colorPressedWarning: string;
            colorFocusWarning: string;
            colorDisabledWarning: string;
            textColorWarning: string;
            textColorHoverWarning: string;
            textColorPressedWarning: string;
            textColorFocusWarning: string;
            textColorDisabledWarning: string;
            textColorTextWarning: string;
            textColorTextHoverWarning: string;
            textColorTextPressedWarning: string;
            textColorTextFocusWarning: string;
            textColorTextDisabledWarning: string;
            textColorGhostWarning: string;
            textColorGhostHoverWarning: string;
            textColorGhostPressedWarning: string;
            textColorGhostFocusWarning: string;
            textColorGhostDisabledWarning: string;
            borderWarning: string;
            borderHoverWarning: string;
            borderPressedWarning: string;
            borderFocusWarning: string;
            borderDisabledWarning: string;
            rippleColorWarning: string;
            colorError: string;
            colorHoverError: string;
            colorPressedError: string;
            colorFocusError: string;
            colorDisabledError: string;
            textColorError: string;
            textColorHoverError: string;
            textColorPressedError: string;
            textColorFocusError: string;
            textColorDisabledError: string;
            textColorTextError: string;
            textColorTextHoverError: string;
            textColorTextPressedError: string;
            textColorTextFocusError: string;
            textColorTextDisabledError: string;
            textColorGhostError: string;
            textColorGhostHoverError: string;
            textColorGhostPressedError: string;
            textColorGhostFocusError: string;
            textColorGhostDisabledError: string;
            borderError: string;
            borderHoverError: string;
            borderPressedError: string;
            borderFocusError: string;
            borderDisabledError: string;
            rippleColorError: string;
            waveOpacity: string;
            fontWeight: string;
            fontWeightStrong: string;
            paddingTiny: string;
            paddingSmall: string;
            paddingMedium: string;
            paddingLarge: string;
            paddingRoundTiny: string;
            paddingRoundSmall: string;
            paddingRoundMedium: string;
            paddingRoundLarge: string;
            iconMarginTiny: string;
            iconMarginSmall: string;
            iconMarginMedium: string;
            iconMarginLarge: string;
            iconSizeTiny: string;
            iconSizeSmall: string;
            iconSizeMedium: string;
            iconSizeLarge: string;
            rippleDuration: string;
        }, any>;
    }>>>;
    readonly builtinThemeOverrides: PropType<import("../../_mixins/use-theme").ExtractThemeOverrides<import("../../_mixins").Theme<"ColorPicker", {
        panelFontSize: string;
        boxShadow: string;
        color: string;
        textColor: string;
        borderRadius: string;
        border: string;
        heightSmall: string;
        heightMedium: string;
        heightLarge: string;
        fontSizeSmall: string;
        fontSizeMedium: string;
        fontSizeLarge: string;
        dividerColor: string;
    }, {
        Input: import("../../_mixins").Theme<"Input", {
            countTextColorDisabled: string;
            countTextColor: string;
            heightTiny: string;
            heightSmall: string;
            heightMedium: string;
            heightLarge: string;
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            lineHeight: string;
            lineHeightTextarea: string;
            borderRadius: string;
            iconSize: string;
            groupLabelColor: string;
            groupLabelTextColor: string;
            textColor: string;
            textColorDisabled: string;
            textDecorationColor: string;
            caretColor: string;
            placeholderColor: string;
            placeholderColorDisabled: string;
            color: string;
            colorDisabled: string;
            colorFocus: string;
            groupLabelBorder: string;
            border: string;
            borderHover: string;
            borderDisabled: string;
            borderFocus: string;
            boxShadowFocus: string;
            loadingColor: string;
            loadingColorWarning: string;
            borderWarning: string;
            borderHoverWarning: string;
            colorFocusWarning: string;
            borderFocusWarning: string;
            boxShadowFocusWarning: string;
            caretColorWarning: string;
            loadingColorError: string;
            borderError: string;
            borderHoverError: string;
            colorFocusError: string;
            borderFocusError: string;
            boxShadowFocusError: string;
            caretColorError: string;
            clearColor: string;
            clearColorHover: string;
            clearColorPressed: string;
            iconColor: string;
            iconColorDisabled: string;
            iconColorHover: string;
            iconColorPressed: string;
            suffixTextColor: string;
            paddingTiny: string;
            paddingSmall: string;
            paddingMedium: string;
            paddingLarge: string;
            clearSize: string;
        }, any>;
        Button: import("../../_mixins").Theme<"Button", {
            heightTiny: string;
            heightSmall: string;
            heightMedium: string;
            heightLarge: string;
            borderRadiusTiny: string;
            borderRadiusSmall: string;
            borderRadiusMedium: string;
            borderRadiusLarge: string;
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            opacityDisabled: string;
            colorOpacitySecondary: string;
            colorOpacitySecondaryHover: string;
            colorOpacitySecondaryPressed: string;
            colorSecondary: string;
            colorSecondaryHover: string;
            colorSecondaryPressed: string;
            colorTertiary: string;
            colorTertiaryHover: string;
            colorTertiaryPressed: string;
            colorQuaternary: string;
            colorQuaternaryHover: string;
            colorQuaternaryPressed: string;
            color: string;
            colorHover: string;
            colorPressed: string;
            colorFocus: string;
            colorDisabled: string;
            textColor: string;
            textColorTertiary: string;
            textColorHover: string;
            textColorPressed: string;
            textColorFocus: string;
            textColorDisabled: string;
            textColorText: string;
            textColorTextHover: string;
            textColorTextPressed: string;
            textColorTextFocus: string;
            textColorTextDisabled: string;
            textColorGhost: string;
            textColorGhostHover: string;
            textColorGhostPressed: string;
            textColorGhostFocus: string;
            textColorGhostDisabled: string;
            border: string;
            borderHover: string;
            borderPressed: string;
            borderFocus: string;
            borderDisabled: string;
            rippleColor: string;
            colorPrimary: string;
            colorHoverPrimary: string;
            colorPressedPrimary: string;
            colorFocusPrimary: string;
            colorDisabledPrimary: string;
            textColorPrimary: string;
            textColorHoverPrimary: string;
            textColorPressedPrimary: string;
            textColorFocusPrimary: string;
            textColorDisabledPrimary: string;
            textColorTextPrimary: string;
            textColorTextHoverPrimary: string;
            textColorTextPressedPrimary: string;
            textColorTextFocusPrimary: string;
            textColorTextDisabledPrimary: string;
            textColorGhostPrimary: string;
            textColorGhostHoverPrimary: string;
            textColorGhostPressedPrimary: string;
            textColorGhostFocusPrimary: string;
            textColorGhostDisabledPrimary: string;
            borderPrimary: string;
            borderHoverPrimary: string;
            borderPressedPrimary: string;
            borderFocusPrimary: string;
            borderDisabledPrimary: string;
            rippleColorPrimary: string;
            colorInfo: string;
            colorHoverInfo: string;
            colorPressedInfo: string;
            colorFocusInfo: string;
            colorDisabledInfo: string;
            textColorInfo: string;
            textColorHoverInfo: string;
            textColorPressedInfo: string;
            textColorFocusInfo: string;
            textColorDisabledInfo: string;
            textColorTextInfo: string;
            textColorTextHoverInfo: string;
            textColorTextPressedInfo: string;
            textColorTextFocusInfo: string;
            textColorTextDisabledInfo: string;
            textColorGhostInfo: string;
            textColorGhostHoverInfo: string;
            textColorGhostPressedInfo: string;
            textColorGhostFocusInfo: string;
            textColorGhostDisabledInfo: string;
            borderInfo: string;
            borderHoverInfo: string;
            borderPressedInfo: string;
            borderFocusInfo: string;
            borderDisabledInfo: string;
            rippleColorInfo: string;
            colorSuccess: string;
            colorHoverSuccess: string;
            colorPressedSuccess: string;
            colorFocusSuccess: string;
            colorDisabledSuccess: string;
            textColorSuccess: string;
            textColorHoverSuccess: string;
            textColorPressedSuccess: string;
            textColorFocusSuccess: string;
            textColorDisabledSuccess: string;
            textColorTextSuccess: string;
            textColorTextHoverSuccess: string;
            textColorTextPressedSuccess: string;
            textColorTextFocusSuccess: string;
            textColorTextDisabledSuccess: string;
            textColorGhostSuccess: string;
            textColorGhostHoverSuccess: string;
            textColorGhostPressedSuccess: string;
            textColorGhostFocusSuccess: string;
            textColorGhostDisabledSuccess: string;
            borderSuccess: string;
            borderHoverSuccess: string;
            borderPressedSuccess: string;
            borderFocusSuccess: string;
            borderDisabledSuccess: string;
            rippleColorSuccess: string;
            colorWarning: string;
            colorHoverWarning: string;
            colorPressedWarning: string;
            colorFocusWarning: string;
            colorDisabledWarning: string;
            textColorWarning: string;
            textColorHoverWarning: string;
            textColorPressedWarning: string;
            textColorFocusWarning: string;
            textColorDisabledWarning: string;
            textColorTextWarning: string;
            textColorTextHoverWarning: string;
            textColorTextPressedWarning: string;
            textColorTextFocusWarning: string;
            textColorTextDisabledWarning: string;
            textColorGhostWarning: string;
            textColorGhostHoverWarning: string;
            textColorGhostPressedWarning: string;
            textColorGhostFocusWarning: string;
            textColorGhostDisabledWarning: string;
            borderWarning: string;
            borderHoverWarning: string;
            borderPressedWarning: string;
            borderFocusWarning: string;
            borderDisabledWarning: string;
            rippleColorWarning: string;
            colorError: string;
            colorHoverError: string;
            colorPressedError: string;
            colorFocusError: string;
            colorDisabledError: string;
            textColorError: string;
            textColorHoverError: string;
            textColorPressedError: string;
            textColorFocusError: string;
            textColorDisabledError: string;
            textColorTextError: string;
            textColorTextHoverError: string;
            textColorTextPressedError: string;
            textColorTextFocusError: string;
            textColorTextDisabledError: string;
            textColorGhostError: string;
            textColorGhostHoverError: string;
            textColorGhostPressedError: string;
            textColorGhostFocusError: string;
            textColorGhostDisabledError: string;
            borderError: string;
            borderHoverError: string;
            borderPressedError: string;
            borderFocusError: string;
            borderDisabledError: string;
            rippleColorError: string;
            waveOpacity: string;
            fontWeight: string;
            fontWeightStrong: string;
            paddingTiny: string;
            paddingSmall: string;
            paddingMedium: string;
            paddingLarge: string;
            paddingRoundTiny: string;
            paddingRoundSmall: string;
            paddingRoundMedium: string;
            paddingRoundLarge: string;
            iconMarginTiny: string;
            iconMarginSmall: string;
            iconMarginMedium: string;
            iconMarginLarge: string;
            iconSizeTiny: string;
            iconSizeSmall: string;
            iconSizeMedium: string;
            iconSizeLarge: string;
            rippleDuration: string;
        }, any>;
    }>>>;
}>>, {
    readonly show: boolean | undefined;
    readonly disabled: boolean | undefined;
    readonly to: string | boolean | HTMLElement;
    readonly placement: FollowerPlacement;
    readonly defaultShow: boolean;
    readonly actions: ActionType[];
    readonly showAlpha: boolean;
    readonly modes: ColorPickerMode[];
    readonly showPreview: boolean;
}, {}>;
export default _default;
