/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientAuthenticationCustomCodec;
import com.hazelcast.client.impl.protocol.task.AuthenticationBaseMessageTask;
import com.hazelcast.cluster.Address;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.security.SimpleTokenCredentials;
import java.util.Collections;
import java.util.HashSet;
import java.util.UUID;

public class AuthenticationCustomCredentialsMessageTask
extends AuthenticationBaseMessageTask<ClientAuthenticationCustomCodec.RequestParameters> {
    public AuthenticationCustomCredentialsMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected String getClientType() {
        return ((ClientAuthenticationCustomCodec.RequestParameters)this.parameters).clientType;
    }

    @Override
    protected ClientAuthenticationCustomCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        ClientAuthenticationCustomCodec.RequestParameters parameters = ClientAuthenticationCustomCodec.decodeRequest(clientMessage);
        UUID uuid = parameters.uuid;
        assert (uuid != null);
        this.clientUuid = uuid;
        this.clusterName = parameters.clusterName;
        this.credentials = new SimpleTokenCredentials(parameters.credentials);
        this.clientSerializationVersion = parameters.serializationVersion;
        this.clientVersion = parameters.clientHazelcastVersion;
        this.clientName = parameters.clientName;
        this.labels = Collections.unmodifiableSet(new HashSet<String>(parameters.labels));
        return parameters;
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return (ClientMessage)response;
    }

    @Override
    protected ClientMessage encodeAuth(byte status, Address thisAddress, UUID uuid, byte version, int partitionCount, UUID clusterId, boolean clientFailoverSupported) {
        return ClientAuthenticationCustomCodec.encodeResponse(status, thisAddress, uuid, version, this.getMemberBuildInfo().getVersion(), partitionCount, clusterId, clientFailoverSupported);
    }

    @Override
    public String getServiceName() {
        return null;
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public String getMethodName() {
        return null;
    }

    @Override
    public Object[] getParameters() {
        return null;
    }
}

