/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.executor.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.executor.impl.operations.CancellationOperation;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.spi.impl.DelegatingCompletableFuture;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.InvocationBuilder;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationService;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;

final class CancellableDelegatingFuture<V>
extends DelegatingCompletableFuture<V> {
    public static final int CANCEL_TRY_COUNT = 50;
    public static final int CANCEL_TRY_PAUSE_MILLIS = 250;
    private final NodeEngine nodeEngine;
    private final UUID uuid;
    private final int partitionId;
    private final Address target;

    CancellableDelegatingFuture(InternalCompletableFuture future, NodeEngine nodeEngine, UUID uuid, int partitionId) {
        super(nodeEngine.getSerializationService(), future);
        this.nodeEngine = nodeEngine;
        this.uuid = uuid;
        this.partitionId = partitionId;
        this.target = null;
    }

    CancellableDelegatingFuture(InternalCompletableFuture future, NodeEngine nodeEngine, UUID uuid, Address target) {
        super(nodeEngine.getSerializationService(), future);
        this.nodeEngine = nodeEngine;
        this.uuid = uuid;
        this.target = target;
        this.partitionId = -1;
    }

    CancellableDelegatingFuture(InternalCompletableFuture future, V defaultValue, NodeEngine nodeEngine, UUID uuid, int partitionId) {
        super(nodeEngine.getSerializationService(), future, defaultValue);
        this.nodeEngine = nodeEngine;
        this.uuid = uuid;
        this.partitionId = partitionId;
        this.target = null;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isDone()) {
            return false;
        }
        Future<Boolean> f = this.invokeCancelOperation(mayInterruptIfRunning);
        boolean cancelSuccessful = false;
        try {
            cancelSuccessful = f.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        this.completeExceptionally(new CancellationException());
        return cancelSuccessful;
    }

    private Future<Boolean> invokeCancelOperation(boolean mayInterruptIfRunning) {
        CancellationOperation op = new CancellationOperation(this.uuid, mayInterruptIfRunning);
        OperationService opService = this.nodeEngine.getOperationService();
        InvocationBuilder builder = this.partitionId > -1 ? opService.createInvocationBuilder("hz:impl:executorService", (Operation)op, this.partitionId) : opService.createInvocationBuilder("hz:impl:executorService", (Operation)op, this.target);
        builder.setTryCount(50).setTryPauseMillis(250L);
        return builder.invoke();
    }
}

