/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.operation.PutFromLoadAllBackupOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.BackupAwareOperation;
import com.hazelcast.spi.impl.operationservice.MutatingOperation;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.PartitionAwareOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PutFromLoadAllOperation
extends MapOperation
implements PartitionAwareOperation,
MutatingOperation,
BackupAwareOperation {
    private List<Data> loadingSequence;
    private List<Data> invalidationKeys;
    private boolean includesExpirationTime;

    public PutFromLoadAllOperation() {
        this.loadingSequence = Collections.emptyList();
        this.includesExpirationTime = false;
    }

    public PutFromLoadAllOperation(String name, List<Data> loadingSequence, boolean includesExpirationTime) {
        super(name);
        Preconditions.checkFalse(CollectionUtil.isEmpty(loadingSequence), "key-value sequence cannot be empty or null");
        this.loadingSequence = loadingSequence;
        this.includesExpirationTime = includesExpirationTime;
    }

    @Override
    protected void runInternal() {
        boolean hasInterceptor = !this.mapContainer.getInterceptorRegistry().getInterceptors().isEmpty();
        List<Data> loadingSequence = this.loadingSequence;
        int i = 0;
        while (i < loadingSequence.size()) {
            Data value;
            Data key = loadingSequence.get(i++);
            Data dataValue = loadingSequence.get(i++);
            Preconditions.checkNotNull(key, "Key loaded by a MapLoader cannot be null.");
            Data data = value = hasInterceptor ? this.mapServiceContext.toObject(dataValue) : dataValue;
            if (this.includesExpirationTime) {
                long expirationTime = (Long)this.mapServiceContext.toObject(loadingSequence.get(i++));
                this.recordStore.putFromLoad(key, value, expirationTime, this.getCallerAddress());
            } else {
                this.recordStore.putFromLoad(key, value, this.getCallerAddress());
            }
            if (value != null && !this.recordStore.existInMemory(key)) continue;
            if (value != null) {
                this.callAfterPutInterceptors(value);
            }
            if (this.isPostProcessing(this.recordStore)) {
                Object record = this.recordStore.getRecord(key);
                Preconditions.checkNotNull(record, "Value loaded by a MapLoader cannot be null.");
                value = record.getValue();
            }
            this.publishLoadAsWanUpdate(key, value);
            this.addInvalidation(key);
        }
    }

    private void addInvalidation(Data key) {
        if (!this.mapContainer.hasInvalidationListener()) {
            return;
        }
        if (this.invalidationKeys == null) {
            this.invalidationKeys = this.includesExpirationTime ? new ArrayList<Data>(this.loadingSequence.size() / 3) : new ArrayList<Data>(this.loadingSequence.size() / 2);
        }
        this.invalidationKeys.add(key);
    }

    private void callAfterPutInterceptors(Object value) {
        this.mapService.getMapServiceContext().interceptAfterPut(this.mapContainer.getInterceptorRegistry(), value);
    }

    @Override
    protected void afterRunInternal() {
        this.invalidateNearCache(this.invalidationKeys);
        this.evict(null);
        super.afterRunInternal();
    }

    @Override
    public Object getResponse() {
        return true;
    }

    @Override
    public boolean shouldBackup() {
        return !this.loadingSequence.isEmpty();
    }

    @Override
    public final int getAsyncBackupCount() {
        return this.mapContainer.getAsyncBackupCount();
    }

    @Override
    public final int getSyncBackupCount() {
        return this.mapContainer.getBackupCount();
    }

    @Override
    public Operation getBackupOperation() {
        return new PutFromLoadAllBackupOperation(this.name, this.loadingSequence, this.includesExpirationTime);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeBoolean(this.includesExpirationTime);
        List<Data> keyValueSequence = this.loadingSequence;
        int size2 = keyValueSequence.size();
        out.writeInt(size2);
        for (Data data : keyValueSequence) {
            IOUtil.writeData(out, data);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.includesExpirationTime = in.readBoolean();
        int size2 = in.readInt();
        if (size2 < 1) {
            this.loadingSequence = Collections.emptyList();
        } else {
            ArrayList<Data> tmpKeyValueSequence = new ArrayList<Data>(size2);
            for (int i = 0; i < size2; ++i) {
                Data data = IOUtil.readData(in);
                tmpKeyValueSequence.add(data);
            }
            this.loadingSequence = tmpKeyValueSequence;
        }
    }

    @Override
    public int getClassId() {
        return 55;
    }
}

