/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.common.config;

import com.hazelcast.internal.util.Preconditions;
import org.apache.seatunnel.engine.common.config.server.CheckpointConfig;
import org.apache.seatunnel.engine.common.config.server.QueueType;
import org.apache.seatunnel.engine.common.config.server.ServerConfigOptions;
import org.apache.seatunnel.engine.common.config.server.SlotServiceConfig;
import org.apache.seatunnel.engine.common.config.server.ThreadShareMode;

public class EngineConfig {
    private int backupCount = ServerConfigOptions.BACKUP_COUNT.defaultValue();
    private int printExecutionInfoInterval = ServerConfigOptions.PRINT_EXECUTION_INFO_INTERVAL.defaultValue();
    private int printJobMetricsInfoInterval = ServerConfigOptions.PRINT_JOB_METRICS_INFO_INTERVAL.defaultValue();
    private int jobMetricsBackupInterval = ServerConfigOptions.JOB_METRICS_BACKUP_INTERVAL.defaultValue();
    private ThreadShareMode taskExecutionThreadShareMode = ServerConfigOptions.TASK_EXECUTION_THREAD_SHARE_MODE.defaultValue();
    private SlotServiceConfig slotServiceConfig = ServerConfigOptions.SLOT_SERVICE.defaultValue();
    private CheckpointConfig checkpointConfig = ServerConfigOptions.CHECKPOINT.defaultValue();
    private QueueType queueType = ServerConfigOptions.QUEUE_TYPE.defaultValue();

    public void setBackupCount(int newBackupCount) {
        Preconditions.checkBackupCount(newBackupCount, 0);
        this.backupCount = newBackupCount;
    }

    public void setPrintExecutionInfoInterval(int printExecutionInfoInterval) {
        Preconditions.checkPositive(printExecutionInfoInterval, ServerConfigOptions.PRINT_EXECUTION_INFO_INTERVAL + " must be > 0");
        this.printExecutionInfoInterval = printExecutionInfoInterval;
    }

    public void setPrintJobMetricsInfoInterval(int printJobMetricsInfoInterval) {
        Preconditions.checkPositive(printJobMetricsInfoInterval, ServerConfigOptions.PRINT_JOB_METRICS_INFO_INTERVAL + " must be > 0");
        this.printJobMetricsInfoInterval = printJobMetricsInfoInterval;
    }

    public void setJobMetricsBackupInterval(int jobMetricsBackupInterval) {
        Preconditions.checkPositive(jobMetricsBackupInterval, ServerConfigOptions.JOB_METRICS_BACKUP_INTERVAL + " must be > 0");
        this.jobMetricsBackupInterval = jobMetricsBackupInterval;
    }

    public void setTaskExecutionThreadShareMode(ThreadShareMode taskExecutionThreadShareMode) {
        Preconditions.checkNotNull(this.queueType);
        this.taskExecutionThreadShareMode = taskExecutionThreadShareMode;
    }

    public EngineConfig setQueueType(QueueType queueType) {
        Preconditions.checkNotNull(queueType);
        this.queueType = queueType;
        return this;
    }

    public int getBackupCount() {
        return this.backupCount;
    }

    public int getPrintExecutionInfoInterval() {
        return this.printExecutionInfoInterval;
    }

    public int getPrintJobMetricsInfoInterval() {
        return this.printJobMetricsInfoInterval;
    }

    public int getJobMetricsBackupInterval() {
        return this.jobMetricsBackupInterval;
    }

    public ThreadShareMode getTaskExecutionThreadShareMode() {
        return this.taskExecutionThreadShareMode;
    }

    public SlotServiceConfig getSlotServiceConfig() {
        return this.slotServiceConfig;
    }

    public CheckpointConfig getCheckpointConfig() {
        return this.checkpointConfig;
    }

    public QueueType getQueueType() {
        return this.queueType;
    }

    public void setSlotServiceConfig(SlotServiceConfig slotServiceConfig) {
        this.slotServiceConfig = slotServiceConfig;
    }

    public void setCheckpointConfig(CheckpointConfig checkpointConfig) {
        this.checkpointConfig = checkpointConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EngineConfig)) {
            return false;
        }
        EngineConfig other = (EngineConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBackupCount() != other.getBackupCount()) {
            return false;
        }
        if (this.getPrintExecutionInfoInterval() != other.getPrintExecutionInfoInterval()) {
            return false;
        }
        if (this.getPrintJobMetricsInfoInterval() != other.getPrintJobMetricsInfoInterval()) {
            return false;
        }
        if (this.getJobMetricsBackupInterval() != other.getJobMetricsBackupInterval()) {
            return false;
        }
        ThreadShareMode this$taskExecutionThreadShareMode = this.getTaskExecutionThreadShareMode();
        ThreadShareMode other$taskExecutionThreadShareMode = other.getTaskExecutionThreadShareMode();
        if (this$taskExecutionThreadShareMode == null ? other$taskExecutionThreadShareMode != null : !((Object)((Object)this$taskExecutionThreadShareMode)).equals((Object)other$taskExecutionThreadShareMode)) {
            return false;
        }
        SlotServiceConfig this$slotServiceConfig = this.getSlotServiceConfig();
        SlotServiceConfig other$slotServiceConfig = other.getSlotServiceConfig();
        if (this$slotServiceConfig == null ? other$slotServiceConfig != null : !((Object)this$slotServiceConfig).equals(other$slotServiceConfig)) {
            return false;
        }
        CheckpointConfig this$checkpointConfig = this.getCheckpointConfig();
        CheckpointConfig other$checkpointConfig = other.getCheckpointConfig();
        if (this$checkpointConfig == null ? other$checkpointConfig != null : !((Object)this$checkpointConfig).equals(other$checkpointConfig)) {
            return false;
        }
        QueueType this$queueType = this.getQueueType();
        QueueType other$queueType = other.getQueueType();
        return !(this$queueType == null ? other$queueType != null : !((Object)((Object)this$queueType)).equals((Object)other$queueType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EngineConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        result2 = result2 * 59 + this.getBackupCount();
        result2 = result2 * 59 + this.getPrintExecutionInfoInterval();
        result2 = result2 * 59 + this.getPrintJobMetricsInfoInterval();
        result2 = result2 * 59 + this.getJobMetricsBackupInterval();
        ThreadShareMode $taskExecutionThreadShareMode = this.getTaskExecutionThreadShareMode();
        result2 = result2 * 59 + ($taskExecutionThreadShareMode == null ? 43 : ((Object)((Object)$taskExecutionThreadShareMode)).hashCode());
        SlotServiceConfig $slotServiceConfig = this.getSlotServiceConfig();
        result2 = result2 * 59 + ($slotServiceConfig == null ? 43 : ((Object)$slotServiceConfig).hashCode());
        CheckpointConfig $checkpointConfig = this.getCheckpointConfig();
        result2 = result2 * 59 + ($checkpointConfig == null ? 43 : ((Object)$checkpointConfig).hashCode());
        QueueType $queueType = this.getQueueType();
        result2 = result2 * 59 + ($queueType == null ? 43 : ((Object)((Object)$queueType)).hashCode());
        return result2;
    }

    public String toString() {
        return "EngineConfig(backupCount=" + this.getBackupCount() + ", printExecutionInfoInterval=" + this.getPrintExecutionInfoInterval() + ", printJobMetricsInfoInterval=" + this.getPrintJobMetricsInfoInterval() + ", jobMetricsBackupInterval=" + this.getJobMetricsBackupInterval() + ", taskExecutionThreadShareMode=" + (Object)((Object)this.getTaskExecutionThreadShareMode()) + ", slotServiceConfig=" + this.getSlotServiceConfig() + ", checkpointConfig=" + this.getCheckpointConfig() + ", queueType=" + (Object)((Object)this.getQueueType()) + ")";
    }
}

