/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.imap.storage.file.wal;

import org.apache.seatunnel.engine.imap.storage.file.config.FileConfiguration;
import org.apache.seatunnel.engine.imap.storage.file.wal.reader.DefaultReader;
import org.apache.seatunnel.engine.imap.storage.file.wal.reader.IFileReader;
import org.apache.seatunnel.engine.imap.storage.file.wal.writer.HdfsWriter;
import org.apache.seatunnel.engine.imap.storage.file.wal.writer.IFileWriter;
import org.apache.seatunnel.engine.imap.storage.file.wal.writer.OssWriter;
import org.apache.seatunnel.engine.imap.storage.file.wal.writer.S3Writer;

public class DiscoveryWalFileFactory {
    public static IFileReader getReader(String type) {
        FileConfiguration configuration = FileConfiguration.valueOf(type.toUpperCase());
        switch (configuration) {
            case HDFS: 
            case S3: 
            case OSS: {
                return new DefaultReader();
            }
        }
        throw new UnsupportedOperationException("Unsupported type " + type);
    }

    public static IFileWriter getWriter(String type) {
        FileConfiguration configuration = FileConfiguration.valueOf(type.toUpperCase());
        switch (configuration) {
            case HDFS: {
                return new HdfsWriter();
            }
            case S3: {
                return new S3Writer();
            }
            case OSS: {
                return new OssWriter();
            }
        }
        throw new UnsupportedOperationException("Unsupported type " + type);
    }
}

