/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task.flow;

import com.hazelcast.cluster.Address;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.common.metrics.MetricsContext;
import org.apache.seatunnel.api.serialization.Serializer;
import org.apache.seatunnel.api.source.SourceEvent;
import org.apache.seatunnel.api.source.SourceReader;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.table.type.Record;
import org.apache.seatunnel.common.utils.SerializationUtils;
import org.apache.seatunnel.engine.common.utils.ExceptionUtil;
import org.apache.seatunnel.engine.core.checkpoint.InternalCheckpointListener;
import org.apache.seatunnel.engine.core.dag.actions.SourceAction;
import org.apache.seatunnel.engine.server.checkpoint.ActionStateKey;
import org.apache.seatunnel.engine.server.checkpoint.ActionSubtaskState;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.task.AbstractTask;
import org.apache.seatunnel.engine.server.task.SeaTunnelSourceCollector;
import org.apache.seatunnel.engine.server.task.SeaTunnelTask;
import org.apache.seatunnel.engine.server.task.context.SourceReaderContext;
import org.apache.seatunnel.engine.server.task.flow.ActionFlowLifeCycle;
import org.apache.seatunnel.engine.server.task.operation.GetTaskGroupAddressOperation;
import org.apache.seatunnel.engine.server.task.operation.source.RequestSplitOperation;
import org.apache.seatunnel.engine.server.task.operation.source.RestoredSplitOperation;
import org.apache.seatunnel.engine.server.task.operation.source.SourceNoMoreElementOperation;
import org.apache.seatunnel.engine.server.task.operation.source.SourceReaderEventOperation;
import org.apache.seatunnel.engine.server.task.operation.source.SourceRegisterOperation;
import org.apache.seatunnel.engine.server.task.record.Barrier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceFlowLifeCycle<T, SplitT extends SourceSplit>
extends ActionFlowLifeCycle
implements InternalCheckpointListener {
    private static final Logger log = LoggerFactory.getLogger(SourceFlowLifeCycle.class);
    private final SourceAction<T, SplitT, ?> sourceAction;
    private final TaskLocation enumeratorTaskLocation;
    private Address enumeratorTaskAddress;
    private SourceReader<T, SplitT> reader;
    private transient Serializer<SplitT> splitSerializer;
    private final int indexID;
    private final TaskLocation currentTaskLocation;
    private SeaTunnelSourceCollector<T> collector;
    private final MetricsContext metricsContext;

    public SourceFlowLifeCycle(SourceAction<T, SplitT, ?> sourceAction, int indexID, TaskLocation enumeratorTaskLocation, SeaTunnelTask runningTask, TaskLocation currentTaskLocation, CompletableFuture<Void> completableFuture, MetricsContext metricsContext) {
        super(sourceAction, runningTask, completableFuture);
        this.sourceAction = sourceAction;
        this.indexID = indexID;
        this.enumeratorTaskLocation = enumeratorTaskLocation;
        this.currentTaskLocation = currentTaskLocation;
        this.metricsContext = metricsContext;
    }

    public void setCollector(SeaTunnelSourceCollector<T> collector) {
        this.collector = collector;
    }

    @Override
    public void init() throws Exception {
        this.splitSerializer = this.sourceAction.getSource().getSplitSerializer();
        this.reader = this.sourceAction.getSource().createReader(new SourceReaderContext(this.indexID, this.sourceAction.getSource().getBoundedness(), this, this.metricsContext));
        this.enumeratorTaskAddress = this.getEnumeratorTaskAddress();
    }

    @Override
    public void open() throws Exception {
        this.reader.open();
        this.register();
    }

    private Address getEnumeratorTaskAddress() throws ExecutionException, InterruptedException {
        return (Address)this.runningTask.getExecutionContext().sendToMaster(new GetTaskGroupAddressOperation(this.enumeratorTaskLocation)).get();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
        super.close();
    }

    public void collect() throws Exception {
        if (!this.prepareClose.booleanValue()) {
            this.reader.pollNext(this.collector);
            if (this.collector.getRowCountThisPollNext() == 0L) {
                Thread.sleep(100L);
            } else {
                this.collector.resetRowCountThisPollNext();
            }
        }
    }

    public void signalNoMoreElement() {
        try {
            this.prepareClose = true;
            this.runningTask.getExecutionContext().sendToMember(new SourceNoMoreElementOperation(this.currentTaskLocation, this.enumeratorTaskLocation), this.enumeratorTaskAddress).get();
        }
        catch (Exception e) {
            log.warn("source close failed {}", e);
            throw new RuntimeException(e);
        }
    }

    private void register() {
        try {
            this.runningTask.getExecutionContext().sendToMember(new SourceRegisterOperation(this.currentTaskLocation, this.enumeratorTaskLocation), this.enumeratorTaskAddress).get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.warn("source register failed.", e);
            throw new RuntimeException(e);
        }
    }

    public void requestSplit() {
        try {
            this.runningTask.getExecutionContext().sendToMember(new RequestSplitOperation(this.currentTaskLocation, this.enumeratorTaskLocation), this.enumeratorTaskAddress).get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.warn("source request split failed.", e);
            throw new RuntimeException(e);
        }
    }

    public void sendSourceEventToEnumerator(SourceEvent sourceEvent) {
        try {
            this.runningTask.getExecutionContext().sendToMember(new SourceReaderEventOperation(this.enumeratorTaskLocation, this.currentTaskLocation, sourceEvent), this.enumeratorTaskAddress).get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.warn("source request split failed.", e);
            throw new RuntimeException(e);
        }
    }

    public void receivedSplits(List<SplitT> splits) {
        if (splits.isEmpty()) {
            this.reader.handleNoMoreSplits();
        } else {
            this.reader.addSplits(splits);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerBarrier(Barrier barrier) throws Exception {
        log.debug("source trigger barrier [{}]", (Object)barrier);
        Object object = this.collector.getCheckpointLock();
        synchronized (object) {
            if (barrier.prepareClose()) {
                this.prepareClose = true;
            }
            if (barrier.snapshot()) {
                List<byte[]> states = AbstractTask.serializeStates(this.splitSerializer, this.reader.snapshotState(barrier.getId()));
                this.runningTask.addState(barrier, ActionStateKey.of(this.sourceAction), states);
            }
            this.runningTask.ack(barrier);
            log.debug("source ack barrier finished, taskId: [{}]", (Object)this.runningTask.getTaskID());
            this.collector.sendRecordToNext(new Record<Barrier>(barrier));
            log.debug("send record to next finished, taskId: [{}]", (Object)this.runningTask.getTaskID());
        }
    }

    @Override
    public void notifyCheckpointComplete(long checkpointId) throws Exception {
        this.reader.notifyCheckpointComplete(checkpointId);
    }

    @Override
    public void notifyCheckpointAborted(long checkpointId) throws Exception {
        this.reader.notifyCheckpointAborted(checkpointId);
    }

    @Override
    public void restoreState(List<ActionSubtaskState> actionStateList) throws Exception {
        if (actionStateList.isEmpty()) {
            return;
        }
        List splits = actionStateList.stream().map(ActionSubtaskState::getState).flatMap(Collection::stream).filter(Objects::nonNull).map(bytes -> ExceptionUtil.sneaky(() -> (SourceSplit)this.splitSerializer.deserialize((byte[])bytes))).collect(Collectors.toList());
        try {
            this.runningTask.getExecutionContext().sendToMember(new RestoredSplitOperation(this.enumeratorTaskLocation, SerializationUtils.serialize(splits.toArray()), this.indexID), this.enumeratorTaskAddress).get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.warn("source request split failed.", e);
            throw new RuntimeException(e);
        }
    }
}

