/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.select;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.WithItem;

public class Select
implements Statement {
    private SelectBody selectBody;
    private List<WithItem> withItemsList;
    private boolean useWithBrackets = false;

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public SelectBody getSelectBody() {
        return this.selectBody;
    }

    public Select withSelectBody(SelectBody body) {
        this.setSelectBody(body);
        return this;
    }

    public void setSelectBody(SelectBody body) {
        this.selectBody = body;
    }

    public void setUsingWithBrackets(boolean useWithBrackets) {
        this.useWithBrackets = useWithBrackets;
    }

    public Select withUsingWithBrackets(boolean useWithBrackets) {
        this.useWithBrackets = useWithBrackets;
        return this;
    }

    public boolean isUsingWithBrackets() {
        return this.useWithBrackets;
    }

    public String toString() {
        StringBuilder retval = new StringBuilder();
        if (this.withItemsList != null && !this.withItemsList.isEmpty()) {
            if (this.useWithBrackets) {
                retval.append("( ");
            }
            retval.append("WITH ");
            Iterator<WithItem> iter = this.withItemsList.iterator();
            while (iter.hasNext()) {
                WithItem withItem = iter.next();
                retval.append(withItem);
                if (iter.hasNext()) {
                    retval.append(",");
                }
                retval.append(" ");
            }
        }
        retval.append(this.selectBody);
        if (this.withItemsList != null && !this.withItemsList.isEmpty() && this.useWithBrackets) {
            retval.append(" )");
        }
        return retval.toString();
    }

    public List<WithItem> getWithItemsList() {
        return this.withItemsList;
    }

    public void setWithItemsList(List<WithItem> withItemsList) {
        this.withItemsList = withItemsList;
    }

    public Select withWithItemsList(List<WithItem> withItemsList) {
        this.setWithItemsList(withItemsList);
        return this;
    }

    public <E extends SelectBody> E getSelectBody(Class<E> type) {
        return (E)((SelectBody)type.cast(this.getSelectBody()));
    }

    public Select addWithItemsList(WithItem ... withItemsList) {
        List collection = Optional.ofNullable(this.getWithItemsList()).orElseGet(ArrayList::new);
        Collections.addAll(collection, withItemsList);
        return this.withWithItemsList(collection);
    }

    public Select addWithItemsList(Collection<? extends WithItem> withItemsList) {
        List collection = Optional.ofNullable(this.getWithItemsList()).orElseGet(ArrayList::new);
        collection.addAll(withItemsList);
        return this.withWithItemsList(collection);
    }
}

