/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.impl.CacheDataSerializerHook;
import com.hazelcast.internal.iteration.IterationPointer;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CacheKeysWithCursor
implements IdentifiedDataSerializable {
    private List<Data> keys;
    private IterationPointer[] pointers;

    public CacheKeysWithCursor() {
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="This is an internal class")
    public CacheKeysWithCursor(List<Data> keys, IterationPointer[] pointers) {
        this.keys = keys;
        this.pointers = pointers;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="This is an internal class")
    public IterationPointer[] getPointers() {
        return this.pointers;
    }

    public List<Data> getKeys() {
        return this.keys;
    }

    @Override
    public int getFactoryId() {
        return CacheDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 23;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.pointers.length);
        for (IterationPointer pointer : this.pointers) {
            out.writeInt(pointer.getIndex());
            out.writeInt(pointer.getSize());
        }
        int size2 = this.keys.size();
        out.writeInt(size2);
        for (Data o : this.keys) {
            IOUtil.writeData(out, o);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int pointersCount = in.readInt();
        this.pointers = new IterationPointer[pointersCount];
        for (int i = 0; i < pointersCount; ++i) {
            this.pointers[i] = new IterationPointer(in.readInt(), in.readInt());
        }
        int size2 = in.readInt();
        this.keys = new ArrayList<Data>(size2);
        for (int i = 0; i < size2; ++i) {
            Data data = IOUtil.readData(in);
            this.keys.add(data);
        }
    }

    public String toString() {
        return "CacheKeyIteratorResult";
    }

    public int getCount() {
        return this.keys != null ? this.keys.size() : 0;
    }

    public Data getKey(int index) {
        return this.keys != null ? this.keys.get(index) : null;
    }
}

