/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.builtin;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.BigDecimalCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListCNBooleanCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListCNByteCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListCNDoubleCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListCNFloatCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListCNIntegerCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListCNLocalDateCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListCNLocalDateTimeCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListCNLocalTimeCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListCNLongCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListCNOffsetDateTimeCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListCNShortCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListIntegerCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.HazelcastJsonValueCodec;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.impl.client.SqlPage;
import java.util.ArrayList;
import java.util.List;

public final class SqlPageCodec {
    private SqlPageCodec() {
    }

    public static void encode(ClientMessage clientMessage, SqlPage sqlPage) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        byte[] content = new byte[]{(byte)(sqlPage.isLast() ? 1 : 0)};
        clientMessage.add(new ClientMessage.Frame(content));
        List<SqlColumnType> columnTypes = sqlPage.getColumnTypes();
        ArrayList<Integer> columnTypeIds = new ArrayList<Integer>(columnTypes.size());
        for (SqlColumnType columnType : columnTypes) {
            columnTypeIds.add(columnType.getId());
        }
        ListIntegerCodec.encode(clientMessage, columnTypeIds);
        block19: for (int i = 0; i < sqlPage.getColumnCount(); ++i) {
            SqlColumnType columnType;
            columnType = columnTypes.get(i);
            Iterable<Boolean> column = sqlPage.getColumnValuesForServer(i);
            switch (columnType) {
                case VARCHAR: {
                    ListMultiFrameCodec.encodeContainsNullable(clientMessage, column, StringCodec::encode);
                    continue block19;
                }
                case BOOLEAN: {
                    ListCNBooleanCodec.encode(clientMessage, column);
                    continue block19;
                }
                case TINYINT: {
                    ListCNByteCodec.encode(clientMessage, column);
                    continue block19;
                }
                case SMALLINT: {
                    ListCNShortCodec.encode(clientMessage, column);
                    continue block19;
                }
                case INTEGER: {
                    ListCNIntegerCodec.encode(clientMessage, column);
                    continue block19;
                }
                case BIGINT: {
                    ListCNLongCodec.encode(clientMessage, column);
                    continue block19;
                }
                case REAL: {
                    ListCNFloatCodec.encode(clientMessage, column);
                    continue block19;
                }
                case DOUBLE: {
                    ListCNDoubleCodec.encode(clientMessage, column);
                    continue block19;
                }
                case DATE: {
                    ListCNLocalDateCodec.encode(clientMessage, column);
                    continue block19;
                }
                case TIME: {
                    ListCNLocalTimeCodec.encode(clientMessage, column);
                    continue block19;
                }
                case TIMESTAMP: {
                    ListCNLocalDateTimeCodec.encode(clientMessage, column);
                    continue block19;
                }
                case TIMESTAMP_WITH_TIME_ZONE: {
                    ListCNOffsetDateTimeCodec.encode(clientMessage, column);
                    continue block19;
                }
                case DECIMAL: {
                    ListMultiFrameCodec.encode(clientMessage, column, BigDecimalCodec::encodeNullable);
                    continue block19;
                }
                case NULL: {
                    int size2 = 0;
                    for (Boolean ignore : column) {
                        ++size2;
                    }
                    byte[] sizeBuffer = new byte[4];
                    FixedSizeTypesCodec.encodeInt(sizeBuffer, 0, size2);
                    clientMessage.add(new ClientMessage.Frame(sizeBuffer));
                    continue block19;
                }
                case OBJECT: {
                    assert (SqlPage.convertToData(columnType));
                    ListMultiFrameCodec.encode(clientMessage, column, DataCodec::encodeNullable);
                    continue block19;
                }
                case JSON: {
                    ListMultiFrameCodec.encodeContainsNullable(clientMessage, column, HazelcastJsonValueCodec::encode);
                    continue block19;
                }
                default: {
                    throw new IllegalStateException("Unknown type " + (Object)((Object)columnType));
                }
            }
        }
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static SqlPage decode(ClientMessage.ForwardFrameIterator iterator2) {
        iterator2.next();
        boolean isLast = iterator2.next().content[0] == 1;
        List<Integer> columnTypeIds = ListIntegerCodec.decode(iterator2);
        ArrayList<SqlColumnType> columnTypes = new ArrayList<SqlColumnType>(columnTypeIds.size());
        ArrayList columns = new ArrayList(columnTypeIds.size());
        block18: for (int columnTypeId : columnTypeIds) {
            SqlColumnType columnType = SqlColumnType.getById(columnTypeId);
            assert (columnType != null);
            columnTypes.add(columnType);
            switch (columnType) {
                case VARCHAR: {
                    columns.add(ListMultiFrameCodec.decodeContainsNullable(iterator2, StringCodec::decode));
                    continue block18;
                }
                case BOOLEAN: {
                    columns.add(ListCNBooleanCodec.decode(iterator2));
                    continue block18;
                }
                case TINYINT: {
                    columns.add(ListCNByteCodec.decode(iterator2));
                    continue block18;
                }
                case SMALLINT: {
                    columns.add(ListCNShortCodec.decode(iterator2));
                    continue block18;
                }
                case INTEGER: {
                    columns.add(ListCNIntegerCodec.decode(iterator2));
                    continue block18;
                }
                case BIGINT: {
                    columns.add(ListCNLongCodec.decode(iterator2));
                    continue block18;
                }
                case REAL: {
                    columns.add(ListCNFloatCodec.decode(iterator2));
                    continue block18;
                }
                case DOUBLE: {
                    columns.add(ListCNDoubleCodec.decode(iterator2));
                    continue block18;
                }
                case DATE: {
                    columns.add(ListCNLocalDateCodec.decode(iterator2));
                    continue block18;
                }
                case TIME: {
                    columns.add(ListCNLocalTimeCodec.decode(iterator2));
                    continue block18;
                }
                case TIMESTAMP: {
                    columns.add(ListCNLocalDateTimeCodec.decode(iterator2));
                    continue block18;
                }
                case TIMESTAMP_WITH_TIME_ZONE: {
                    columns.add(ListCNOffsetDateTimeCodec.decode(iterator2));
                    continue block18;
                }
                case DECIMAL: {
                    columns.add(ListMultiFrameCodec.decode(iterator2, BigDecimalCodec::decodeNullable));
                    continue block18;
                }
                case NULL: {
                    ClientMessage.Frame frame = iterator2.next();
                    int size2 = FixedSizeTypesCodec.decodeInt(frame.content, 0);
                    ArrayList<Object> column = new ArrayList<Object>(size2);
                    for (int i = 0; i < size2; ++i) {
                        column.add(null);
                    }
                    columns.add(column);
                    continue block18;
                }
                case OBJECT: {
                    assert (SqlPage.convertToData(columnType));
                    columns.add(ListMultiFrameCodec.decode(iterator2, DataCodec::decodeNullable));
                    continue block18;
                }
                case JSON: {
                    columns.add(ListMultiFrameCodec.decodeContainsNullable(iterator2, HazelcastJsonValueCodec::decode));
                    continue block18;
                }
            }
            throw new IllegalStateException("Unknown type " + (Object)((Object)columnType));
        }
        CodecUtil.fastForwardToEndFrame(iterator2);
        return SqlPage.fromColumns(columnTypes, columns, isLast);
    }
}

