/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.builders.appender;

import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.bridge.AppenderWrapper;
import org.apache.log4j.bridge.LayoutAdapter;
import org.apache.log4j.bridge.LayoutWrapper;
import org.apache.log4j.builders.AbstractBuilder;
import org.apache.log4j.builders.appender.AppenderBuilder;
import org.apache.log4j.config.Log4j1Configuration;
import org.apache.log4j.config.PropertiesConfiguration;
import org.apache.log4j.xml.XmlConfiguration;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.status.StatusLogger;
import org.w3c.dom.Element;

@Plugin(name="org.apache.log4j.FileAppender", category="Log4j Builder")
public class FileAppenderBuilder
extends AbstractBuilder
implements AppenderBuilder {
    private static final Logger LOGGER = StatusLogger.getLogger();

    public FileAppenderBuilder() {
    }

    public FileAppenderBuilder(String prefix, Properties props) {
        super(prefix, props);
    }

    @Override
    public Appender parseAppender(Element appenderElement, XmlConfiguration config) {
        String name = appenderElement.getAttribute("name");
        AtomicReference layout = new AtomicReference();
        AtomicReference filter2 = new AtomicReference();
        AtomicReference fileName = new AtomicReference();
        AtomicReference level = new AtomicReference();
        AtomicBoolean immediateFlush = new AtomicBoolean();
        AtomicBoolean append2 = new AtomicBoolean();
        AtomicBoolean bufferedIo = new AtomicBoolean();
        AtomicInteger bufferSize = new AtomicInteger(8192);
        XmlConfiguration.forEachElement(appenderElement.getChildNodes(), currentElement -> {
            block5 : switch (currentElement.getTagName()) {
                case "layout": {
                    layout.set(config.parseLayout((Element)currentElement));
                    break;
                }
                case "filter": {
                    filter2.set(config.parseFilters((Element)currentElement));
                    break;
                }
                case "param": {
                    switch (currentElement.getAttribute("name")) {
                        case "File": {
                            fileName.set(currentElement.getAttribute("value"));
                            break block5;
                        }
                        case "Append": {
                            String bool = currentElement.getAttribute("value");
                            if (bool != null) {
                                append2.set(Boolean.parseBoolean(bool));
                                break block5;
                            }
                            LOGGER.warn("No value provided for append parameter");
                            break block5;
                        }
                        case "BufferedIO": {
                            String bool = currentElement.getAttribute("value");
                            if (bool != null) {
                                bufferedIo.set(Boolean.parseBoolean(bool));
                                break block5;
                            }
                            LOGGER.warn("No value provided for bufferedIo parameter");
                            break block5;
                        }
                        case "BufferSize": {
                            String size2 = currentElement.getAttribute("value");
                            if (size2 != null) {
                                bufferSize.set(Integer.parseInt(size2));
                                break block5;
                            }
                            LOGGER.warn("No value provide for bufferSize parameter");
                            break block5;
                        }
                        case "Threshold": {
                            String value = currentElement.getAttribute("value");
                            if (value == null) {
                                LOGGER.warn("No value supplied for Threshold parameter, ignoring.");
                                break block5;
                            }
                            level.set(value);
                            break block5;
                        }
                    }
                }
            }
        });
        return this.createAppender(name, config, (Layout)layout.get(), (org.apache.log4j.spi.Filter)filter2.get(), (String)fileName.get(), (String)level.get(), immediateFlush.get(), append2.get(), bufferedIo.get(), bufferSize.get());
    }

    @Override
    public Appender parseAppender(String name, String appenderPrefix, String layoutPrefix, String filterPrefix, Properties props, PropertiesConfiguration configuration) {
        Layout layout = configuration.parseLayout(layoutPrefix, name, props);
        org.apache.log4j.spi.Filter filter2 = configuration.parseAppenderFilters(props, filterPrefix, name);
        String level = this.getProperty("Threshold");
        String fileName = this.getProperty("File");
        boolean append2 = this.getBooleanProperty("Append");
        boolean immediateFlush = false;
        boolean bufferedIo = this.getBooleanProperty("BufferedIO");
        int bufferSize = Integer.parseInt(this.getProperty("BufferSize", "8192"));
        return this.createAppender(name, configuration, layout, filter2, fileName, level, immediateFlush, append2, bufferedIo, bufferSize);
    }

    private Appender createAppender(String name, Log4j1Configuration configuration, Layout layout, org.apache.log4j.spi.Filter filter2, String fileName, String level, boolean immediateFlush, boolean append2, boolean bufferedIo, int bufferSize) {
        LayoutAdapter fileLayout = null;
        if (bufferedIo) {
            immediateFlush = true;
        }
        if (layout instanceof LayoutWrapper) {
            fileLayout = ((LayoutWrapper)layout).getLayout();
        } else if (layout != null) {
            fileLayout = new LayoutAdapter(layout);
        }
        Filter fileFilter = this.buildFilters(level, filter2);
        if (fileName == null) {
            LOGGER.warn("Unable to create File Appender, no file name provided");
            return null;
        }
        return new AppenderWrapper(((FileAppender.Builder)((FileAppender.Builder)((AbstractOutputStreamAppender.Builder)((FileAppender.Builder)((AbstractOutputStreamAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((AbstractAppender.Builder)FileAppender.newBuilder()).setName(name)).setConfiguration(configuration)).setLayout(fileLayout)).setFilter(fileFilter)).withFileName(fileName)).withImmediateFlush(immediateFlush)).withAppend(append2)).withBufferedIo(bufferedIo)).withBufferSize(bufferSize)).build());
    }
}

