/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.common.loader;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.function.Consumer;

public abstract class SeaTunnelBaseClassLoader
extends URLClassLoader {
    protected static final Consumer<Throwable> NOOP_EXCEPTION_HANDLER = classLoadingException -> {};
    private final Consumer<Throwable> classLoadingExceptionHandler;

    protected SeaTunnelBaseClassLoader(List<URL> urls) {
        this(urls.toArray(new URL[0]), SeaTunnelBaseClassLoader.class.getClassLoader());
    }

    protected SeaTunnelBaseClassLoader(URL[] urls, ClassLoader parent) {
        this(urls, parent, NOOP_EXCEPTION_HANDLER);
    }

    protected SeaTunnelBaseClassLoader(URL[] urls, ClassLoader parent, Consumer<Throwable> classLoadingExceptionHandler) {
        super(urls, parent);
        this.classLoadingExceptionHandler = classLoadingExceptionHandler;
    }

    @Override
    protected final Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            return this.loadClassWithoutExceptionHandling(name, resolve);
        }
        catch (Throwable classLoadingException) {
            this.classLoadingExceptionHandler.accept(classLoadingException);
            throw classLoadingException;
        }
    }

    protected Class<?> loadClassWithoutExceptionHandling(String name, boolean resolve) throws ClassNotFoundException {
        return super.loadClass(name, resolve);
    }
}

