/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.checkpoint;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.seatunnel.engine.server.checkpoint.SubtaskStatistics;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;

public class TaskStatistics
implements Serializable {
    private final Long jobVertexId;
    private final List<SubtaskStatistics> subtaskStats;
    private final boolean[] subtaskCompleted;
    private int numAcknowledgedSubtasks = 0;
    private SubtaskStatistics latestAckedSubtaskStatistics;

    TaskStatistics(Long jobVertexId, int parallelism) {
        this.jobVertexId = Preconditions.checkNotNull(jobVertexId, "JobVertexID");
        Preconditions.checkArgument(parallelism > 0, "the parallelism of task <= 0");
        this.subtaskStats = Arrays.asList(new SubtaskStatistics[parallelism]);
        this.subtaskCompleted = new boolean[parallelism];
    }

    boolean reportSubtaskStatistics(SubtaskStatistics subtask) {
        Preconditions.checkNotNull(subtask, "Subtask stats");
        int subtaskIndex = subtask.getSubtaskIndex();
        if (subtaskIndex < 0 || subtaskIndex >= this.subtaskStats.size()) {
            return false;
        }
        if (this.subtaskStats.get(subtaskIndex) == null) {
            this.subtaskStats.set(subtaskIndex, subtask);
            ++this.numAcknowledgedSubtasks;
            return true;
        }
        return false;
    }

    public SubtaskStatistics getLatestAcknowledgedSubtaskStatistics() {
        return this.latestAckedSubtaskStatistics;
    }

    public long getLatestAckTimestamp() {
        return this.latestAckedSubtaskStatistics != null ? this.latestAckedSubtaskStatistics.getAckTimestamp() : -1L;
    }

    public Long getJobVertexId() {
        return this.jobVertexId;
    }

    public List<SubtaskStatistics> getSubtaskStats() {
        return this.subtaskStats;
    }

    public void completed(int subtaskIndex) {
        this.subtaskCompleted[subtaskIndex] = true;
    }

    public boolean isCompleted() {
        for (boolean completed : this.subtaskCompleted) {
            if (completed) continue;
            return false;
        }
        return true;
    }
}

