/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.jmx;

import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.TriTuple;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;

public class MetricsMBean
implements DynamicMBean {
    private final ConcurrentMap<String, TriTuple<String, AtomicReference<Number>, Type>> metrics = new ConcurrentHashMap<String, TriTuple<String, AtomicReference<Number>, Type>>();

    void setMetricValue(String name, String unit, Number value, Type type) {
        TriTuple metricTuple = (TriTuple)this.metrics.get(name);
        if (metricTuple == null) {
            metricTuple = TriTuple.of(unit, new AtomicReference(), type);
            this.metrics.put(name, metricTuple);
        }
        ((AtomicReference)metricTuple.element2).lazySet(value);
    }

    void removeMetric(String name) {
        this.metrics.remove(name);
    }

    @Override
    public Object getAttribute(String attributeName) throws AttributeNotFoundException {
        TriTuple attribute = (TriTuple)this.metrics.get(attributeName);
        if (attribute == null) {
            throw new AttributeNotFoundException(attributeName);
        }
        return ((AtomicReference)attribute.element2).get();
    }

    @Override
    public void setAttribute(Attribute attribute) {
        throw new UnsupportedOperationException("setting attributes is not supported");
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        return Arrays.stream(attributes).filter(this.metrics::containsKey).map(a -> MetricsMBean.uncheckCall(() -> new Attribute((String)a, this.getAttribute((String)a)))).collect(Collectors.toCollection(AttributeList::new));
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        throw new UnsupportedOperationException("setting attributes is not supported");
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) {
        throw new UnsupportedOperationException("invoking is not supported");
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanAttributeInfo[] array = new MBeanAttributeInfo[this.metrics.size()];
        int i = 0;
        for (Map.Entry entry : this.metrics.entrySet()) {
            array[i++] = new MBeanAttributeInfo((String)entry.getKey(), ((Type)((Object)((TriTuple)entry.getValue()).element3)).type, "Unit: " + (String)((TriTuple)entry.getValue()).element1, true, false, false);
        }
        return new MBeanInfo("Metric", "", array, null, null, null, null);
    }

    int numAttributes() {
        return this.metrics.size();
    }

    private static <T> T uncheckCall(@Nonnull Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    public static enum Type {
        LONG("long"),
        DOUBLE("double");

        private static final Type[] VALUES;
        private final String type;

        private Type(String type) {
            this.type = type;
        }

        static Type of(String strType) {
            for (Type value : VALUES) {
                if (!strType.equals(value.type)) continue;
                return value;
            }
            return null;
        }

        static {
            VALUES = Type.values();
        }
    }
}

