/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.dag.physical;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;
import org.apache.seatunnel.engine.server.dag.physical.PhysicalVertex;
import org.apache.seatunnel.engine.server.dag.physical.SubPlan;
import org.apache.seatunnel.engine.server.execution.TaskGroupLocation;
import org.apache.seatunnel.engine.server.resourcemanager.ResourceManager;
import org.apache.seatunnel.engine.server.resourcemanager.resource.ResourceProfile;
import org.apache.seatunnel.engine.server.resourcemanager.resource.SlotProfile;

public class ResourceUtils {
    public static Map<TaskGroupLocation, SlotProfile> applyResourceForPipeline(@NonNull ResourceManager resourceManager, @NonNull SubPlan subPlan) {
        if (resourceManager == null) {
            throw new NullPointerException("resourceManager is marked non-null but is null");
        }
        if (subPlan == null) {
            throw new NullPointerException("subPlan is marked non-null but is null");
        }
        HashMap futures = new HashMap();
        HashMap<TaskGroupLocation, SlotProfile> slotProfiles = new HashMap<TaskGroupLocation, SlotProfile>();
        subPlan.getCoordinatorVertexList().forEach(coordinator -> futures.put(coordinator.getTaskGroupLocation(), ResourceUtils.applyResourceForTask(resourceManager, coordinator)));
        subPlan.getPhysicalVertexList().forEach(task -> futures.put(task.getTaskGroupLocation(), ResourceUtils.applyResourceForTask(resourceManager, task)));
        for (Map.Entry future : futures.entrySet()) {
            slotProfiles.put((TaskGroupLocation)future.getKey(), future.getValue() == null ? null : (SlotProfile)((CompletableFuture)future.getValue()).join());
        }
        return slotProfiles;
    }

    public static CompletableFuture<SlotProfile> applyResourceForTask(ResourceManager resourceManager, PhysicalVertex task) {
        return resourceManager.applyResource(task.getTaskGroupLocation().getJobId(), new ResourceProfile());
    }
}

