/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.common.exception;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.map.SingletonMap;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelRuntimeException;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.ObjectMapper;

public class CommonError {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static SeaTunnelRuntimeException fileOperationFailed(String identifier, String operation, String fileName, Throwable cause) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("identifier", identifier);
        params.put("operation", operation);
        params.put("fileName", fileName);
        return new SeaTunnelRuntimeException((SeaTunnelErrorCode)CommonErrorCode.FILE_OPERATION_FAILED, params, cause);
    }

    public static SeaTunnelRuntimeException fileOperationFailed(String identifier, String operation, String fileName) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("identifier", identifier);
        params.put("operation", operation);
        params.put("fileName", fileName);
        return new SeaTunnelRuntimeException((SeaTunnelErrorCode)CommonErrorCode.FILE_OPERATION_FAILED, params);
    }

    public static SeaTunnelRuntimeException fileNotExistFailed(String identifier, String operation, String fileName) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("identifier", identifier);
        params.put("operation", operation);
        params.put("fileName", fileName);
        return new SeaTunnelRuntimeException((SeaTunnelErrorCode)CommonErrorCode.FILE_NOT_EXISTED, params);
    }

    public static SeaTunnelRuntimeException writeSeaTunnelRowFailed(String connector, String row, Throwable cause) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("connector", connector);
        params.put("seaTunnelRow", row);
        return new SeaTunnelRuntimeException((SeaTunnelErrorCode)CommonErrorCode.WRITE_SEATUNNEL_ROW_ERROR, params, cause);
    }

    public static SeaTunnelRuntimeException unsupportedDataType(String identifier, String dataType, String field2) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("identifier", identifier);
        params.put("dataType", dataType);
        params.put("field", field2);
        return new SeaTunnelRuntimeException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_DATA_TYPE, params);
    }

    public static SeaTunnelRuntimeException unsupportedEncoding(String encoding) {
        SingletonMap<String, String> params = new SingletonMap<String, String>("encoding", encoding);
        return new SeaTunnelRuntimeException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_ENCODING, params);
    }

    public static SeaTunnelRuntimeException convertToSeaTunnelTypeError(String connector, PluginType pluginType, String dataType, String field2) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("connector", connector);
        params.put("type", pluginType.getType());
        params.put("dataType", dataType);
        params.put("field", field2);
        return new SeaTunnelRuntimeException((SeaTunnelErrorCode)CommonErrorCode.CONVERT_TO_SEATUNNEL_TYPE_ERROR, params);
    }

    public static SeaTunnelRuntimeException convertToSeaTunnelTypeError(String identifier, String dataType, String field2) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("identifier", identifier);
        params.put("dataType", dataType);
        params.put("field", field2);
        return new SeaTunnelRuntimeException((SeaTunnelErrorCode)CommonErrorCode.CONVERT_TO_SEATUNNEL_TYPE_ERROR_SIMPLE, params);
    }

    public static SeaTunnelRuntimeException convertToConnectorTypeError(String connector, PluginType pluginType, String dataType, String field2) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("connector", connector);
        params.put("type", pluginType.getType());
        params.put("dataType", dataType);
        params.put("field", field2);
        return new SeaTunnelRuntimeException((SeaTunnelErrorCode)CommonErrorCode.CONVERT_TO_CONNECTOR_TYPE_ERROR, params);
    }

    public static SeaTunnelRuntimeException convertToConnectorTypeError(String identifier, String dataType, String field2) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("identifier", identifier);
        params.put("dataType", dataType);
        params.put("field", field2);
        return new SeaTunnelRuntimeException((SeaTunnelErrorCode)CommonErrorCode.CONVERT_TO_CONNECTOR_TYPE_ERROR_SIMPLE, params);
    }

    public static SeaTunnelRuntimeException getCatalogTableWithUnsupportedType(String catalogName, String tableName, Map<String, String> fieldWithDataTypes) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("catalogName", catalogName);
        params.put("tableName", tableName);
        try {
            params.put("fieldWithDataTypes", OBJECT_MAPPER.writeValueAsString(fieldWithDataTypes));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return new SeaTunnelRuntimeException((SeaTunnelErrorCode)CommonErrorCode.GET_CATALOG_TABLE_WITH_UNSUPPORTED_TYPE_ERROR, params);
    }

    public static SeaTunnelRuntimeException getCatalogTablesWithUnsupportedType(String catalogName, Map<String, Map<String, String>> tableUnsupportedTypes) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("catalogName", catalogName);
        try {
            params.put("tableUnsupportedTypes", OBJECT_MAPPER.writeValueAsString(tableUnsupportedTypes));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return new SeaTunnelRuntimeException((SeaTunnelErrorCode)CommonErrorCode.GET_CATALOG_TABLES_WITH_UNSUPPORTED_TYPE_ERROR, params);
    }

    public static SeaTunnelRuntimeException jsonOperationError(String identifier, String payload) {
        return CommonError.jsonOperationError(identifier, payload, null);
    }

    public static SeaTunnelRuntimeException jsonOperationError(String identifier, String payload, Throwable cause) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("identifier", identifier);
        params.put("payload", payload);
        CommonErrorCode code = CommonErrorCode.JSON_OPERATION_FAILED;
        if (cause != null) {
            return new SeaTunnelRuntimeException((SeaTunnelErrorCode)code, params, cause);
        }
        return new SeaTunnelRuntimeException((SeaTunnelErrorCode)code, params);
    }
}

