/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.core.starter.flowcontrol;

import java.util.Map;
import java.util.Optional;
import org.apache.seatunnel.api.env.EnvCommonOptions;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public final class FlowControlStrategy {
    private final int bytesPerSecond;
    private final int countPerSecond;

    FlowControlStrategy(int bytesPerSecond, int countPerSecond) {
        if (bytesPerSecond <= 0 || countPerSecond <= 0) {
            throw new IllegalArgumentException("bytesPerSecond and countPerSecond must be positive");
        }
        this.bytesPerSecond = bytesPerSecond;
        this.countPerSecond = countPerSecond;
    }

    public int getBytesPerSecond() {
        return this.bytesPerSecond;
    }

    public int getCountPerSecond() {
        return this.countPerSecond;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static FlowControlStrategy of(int bytesPerSecond, int countPerSecond) {
        return FlowControlStrategy.builder().bytesPerSecond(bytesPerSecond).countPerSecond(countPerSecond).build();
    }

    public static FlowControlStrategy ofBytes(int bytesPerSecond) {
        return FlowControlStrategy.builder().bytesPerSecond(bytesPerSecond).build();
    }

    public static FlowControlStrategy ofCount(int countPerSecond) {
        return FlowControlStrategy.builder().countPerSecond(countPerSecond).build();
    }

    public static FlowControlStrategy fromMap(Map<String, Object> envOption) {
        Builder builder = FlowControlStrategy.builder();
        if (envOption == null || envOption.isEmpty()) {
            return builder.build();
        }
        Object bytePerSecond = envOption.get(EnvCommonOptions.READ_LIMIT_BYTES_PER_SECOND.key());
        Object countPerSecond = envOption.get(EnvCommonOptions.READ_LIMIT_ROW_PER_SECOND.key());
        Optional.ofNullable(bytePerSecond).ifPresent(bps -> builder.bytesPerSecond(Integer.parseInt(bps.toString())));
        Optional.ofNullable(countPerSecond).ifPresent(cps -> builder.countPerSecond(Integer.parseInt(cps.toString())));
        return builder.build();
    }

    public static FlowControlStrategy fromConfig(Config envConfig) {
        Builder builder = FlowControlStrategy.builder();
        if (envConfig.hasPath(EnvCommonOptions.READ_LIMIT_BYTES_PER_SECOND.key())) {
            builder.bytesPerSecond(envConfig.getInt(EnvCommonOptions.READ_LIMIT_BYTES_PER_SECOND.key()));
        }
        if (envConfig.hasPath(EnvCommonOptions.READ_LIMIT_ROW_PER_SECOND.key())) {
            builder.countPerSecond(envConfig.getInt(EnvCommonOptions.READ_LIMIT_ROW_PER_SECOND.key()));
        }
        return builder.build();
    }

    public static class Builder {
        private int bytesPerSecond = Integer.MAX_VALUE;
        private int countPerSecond = Integer.MAX_VALUE;

        private Builder() {
        }

        public Builder bytesPerSecond(int bytesPerSecond) {
            this.bytesPerSecond = bytesPerSecond;
            return this;
        }

        public Builder countPerSecond(int countPerSecond) {
            this.countPerSecond = countPerSecond;
            return this;
        }

        public FlowControlStrategy build() {
            return new FlowControlStrategy(this.bytesPerSecond, this.countPerSecond);
        }
    }
}

