/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.copy;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.MapType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.transform.common.MultipleFieldOutputTransform;
import org.apache.seatunnel.transform.common.SeaTunnelRowAccessor;
import org.apache.seatunnel.transform.copy.CopyTransformConfig;
import org.apache.seatunnel.transform.exception.TransformCommonError;

public class CopyFieldTransform
extends MultipleFieldOutputTransform {
    public static final String PLUGIN_NAME = "Copy";
    private final CopyTransformConfig config;
    private List<String> fieldNames;
    private List<Integer> fieldOriginalIndexes;
    private List<SeaTunnelDataType<?>> fieldTypes;

    public CopyFieldTransform(CopyTransformConfig copyTransformConfig, CatalogTable catalogTable) {
        super(catalogTable);
        this.config = copyTransformConfig;
        SeaTunnelRowType seaTunnelRowType = catalogTable.getTableSchema().toPhysicalRowDataType();
        this.initOutputFields(seaTunnelRowType, this.config.getFields());
    }

    public String getPluginName() {
        return PLUGIN_NAME;
    }

    private void initOutputFields(SeaTunnelRowType inputRowType, LinkedHashMap<String, String> fields) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        ArrayList<Integer> fieldOriginalIndexes = new ArrayList<Integer>();
        ArrayList fieldsType = new ArrayList();
        for (Map.Entry<String, String> field : fields.entrySet()) {
            int srcFieldIndex;
            String srcField = field.getValue();
            try {
                srcFieldIndex = inputRowType.indexOf(srcField);
            }
            catch (IllegalArgumentException e) {
                throw TransformCommonError.cannotFindInputFieldError(this.getPluginName(), srcField);
            }
            fieldNames.add(field.getKey());
            fieldOriginalIndexes.add(srcFieldIndex);
            fieldsType.add(inputRowType.getFieldType(srcFieldIndex));
        }
        this.fieldNames = fieldNames;
        this.fieldOriginalIndexes = fieldOriginalIndexes;
        this.fieldTypes = fieldsType;
    }

    @Override
    protected Column[] getOutputColumns() {
        if (this.inputCatalogTable == null) {
            Column[] columns = new Column[this.fieldNames.size()];
            for (int i = 0; i < this.fieldNames.size(); ++i) {
                columns[i] = PhysicalColumn.of((String)this.fieldNames.get(i), this.fieldTypes.get(i), (Integer)200, (boolean)true, (Object)"", (String)"");
            }
            return columns;
        }
        Map<String, Column> catalogTableColumns = this.inputCatalogTable.getTableSchema().getColumns().stream().collect(Collectors.toMap(column -> column.getName(), column -> column));
        ArrayList<PhysicalColumn> columns = new ArrayList<PhysicalColumn>();
        for (Map.Entry<String, String> copyField : this.config.getFields().entrySet()) {
            Column srcColumn = catalogTableColumns.get(copyField.getValue());
            PhysicalColumn destColumn = PhysicalColumn.of((String)copyField.getKey(), (SeaTunnelDataType)srcColumn.getDataType(), (Long)srcColumn.getColumnLength(), (boolean)srcColumn.isNullable(), (Object)srcColumn.getDefaultValue(), (String)srcColumn.getComment());
            columns.add(destColumn);
        }
        return columns.toArray(new Column[0]);
    }

    @Override
    protected Object[] getOutputFieldValues(SeaTunnelRowAccessor inputRow) {
        Object[] fieldValues = new Object[this.fieldNames.size()];
        for (int i = 0; i < this.fieldOriginalIndexes.size(); ++i) {
            fieldValues[i] = this.clone(this.fieldNames.get(i), this.fieldTypes.get(i), inputRow.getField(this.fieldOriginalIndexes.get(i)));
        }
        return fieldValues;
    }

    private Object clone(String field, SeaTunnelDataType<?> dataType, Object value) {
        if (value == null) {
            return null;
        }
        switch (dataType.getSqlType()) {
            case BOOLEAN: 
            case STRING: 
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                return value;
            }
            case BYTES: {
                byte[] bytes = (byte[])value;
                byte[] newBytes = new byte[bytes.length];
                System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
                return newBytes;
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)dataType;
                Object[] array = (Object[])value;
                Object newArray = Array.newInstance(arrayType.getElementType().getTypeClass(), array.length);
                for (int i = 0; i < array.length; ++i) {
                    Array.set(newArray, i, this.clone(field, (SeaTunnelDataType<?>)arrayType.getElementType(), array[i]));
                }
                return newArray;
            }
            case MAP: {
                MapType mapType = (MapType)dataType;
                Map map = (Map)value;
                HashMap<Object, Object> newMap = new HashMap<Object, Object>();
                for (Object key : map.keySet()) {
                    newMap.put(this.clone(field, mapType.getKeyType(), key), this.clone(field, mapType.getValueType(), map.get(key)));
                }
                return newMap;
            }
            case ROW: {
                SeaTunnelRowType rowType = (SeaTunnelRowType)dataType;
                SeaTunnelRow row = (SeaTunnelRow)value;
                Object[] newFields = new Object[rowType.getTotalFields()];
                for (int i = 0; i < rowType.getTotalFields(); ++i) {
                    newFields[i] = this.clone(rowType.getFieldName(i), rowType.getFieldType(i), row.getField(i));
                }
                SeaTunnelRow newRow = new SeaTunnelRow(newFields);
                newRow.setRowKind(row.getRowKind());
                newRow.setTableId(row.getTableId());
                return newRow;
            }
            case NULL: {
                return null;
            }
        }
        throw CommonError.unsupportedDataType((String)this.getPluginName(), (String)dataType.getSqlType().toString(), (String)field);
    }
}

