/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.dynamiccompile;

import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.utils.ReflectionUtils;
import org.apache.seatunnel.transform.common.MultipleFieldOutputTransform;
import org.apache.seatunnel.transform.common.SeaTunnelRowAccessor;
import org.apache.seatunnel.transform.dynamiccompile.CompileLanguage;
import org.apache.seatunnel.transform.dynamiccompile.CompileTransformErrorCode;
import org.apache.seatunnel.transform.dynamiccompile.DynamicCompileTransformConfig;
import org.apache.seatunnel.transform.dynamiccompile.parse.AbstractParse;
import org.apache.seatunnel.transform.dynamiccompile.parse.GroovyClassParse;
import org.apache.seatunnel.transform.dynamiccompile.parse.JavaClassParse;
import org.apache.seatunnel.transform.exception.TransformException;

public class DynamicCompileTransform
extends MultipleFieldOutputTransform {
    public static final String PLUGIN_NAME = "DynamicCompile";
    public static final String getInlineOutputColumns = "getInlineOutputColumns";
    public static final String getInlineOutputFieldValues = "getInlineOutputFieldValues";
    private final String sourceCode;
    private AbstractParse DynamicCompileParse;

    public DynamicCompileTransform(ReadonlyConfig readonlyConfig, CatalogTable catalogTable) {
        super(catalogTable);
        CompileLanguage compileLanguage = (CompileLanguage)((Object)readonlyConfig.get(DynamicCompileTransformConfig.COMPILE_LANGUAGE));
        if (CompileLanguage.GROOVY.equals((Object)compileLanguage)) {
            this.DynamicCompileParse = new GroovyClassParse();
        } else if (CompileLanguage.JAVA.equals((Object)compileLanguage)) {
            this.DynamicCompileParse = new JavaClassParse();
        }
        this.sourceCode = (String)readonlyConfig.get(DynamicCompileTransformConfig.SOURCE_CODE);
    }

    public String getPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    protected Column[] getOutputColumns() {
        Object result;
        try {
            result = ReflectionUtils.invoke(this.DynamicCompileParse.parseClass(this.sourceCode).newInstance(), (String)getInlineOutputColumns, (Object[])new Object[]{this.inputCatalogTable});
        }
        catch (Exception e) {
            throw new TransformException((SeaTunnelErrorCode)CompileTransformErrorCode.COMPILE_TRANSFORM_ERROR_CODE, e.getMessage());
        }
        return (Column[])result;
    }

    @Override
    protected Object[] getOutputFieldValues(SeaTunnelRowAccessor inputRow) {
        Object result;
        try {
            result = ReflectionUtils.invoke(this.DynamicCompileParse.parseClass(this.sourceCode).newInstance(), (String)getInlineOutputFieldValues, (Object[])new Object[]{inputRow});
        }
        catch (Exception e) {
            throw new TransformException((SeaTunnelErrorCode)CompileTransformErrorCode.COMPILE_TRANSFORM_ERROR_CODE, e.getMessage());
        }
        return (Object[])result;
    }
}

