/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aws;

import com.hazelcast.aws.AwsConfig;
import com.hazelcast.aws.AwsCredentials;
import com.hazelcast.aws.AwsMetadataApi;
import com.hazelcast.aws.Environment;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.spi.exception.NoCredentialsException;
import com.hazelcast.spi.exception.RestClientException;

class AwsCredentialsProvider {
    private static final ILogger LOGGER = Logger.getLogger(AwsCredentialsProvider.class);
    private static final int HTTP_NOT_FOUND = 404;
    private final AwsConfig awsConfig;
    private final AwsMetadataApi awsMetadataApi;
    private final Environment environment;
    private final String ec2IamRole;

    AwsCredentialsProvider(AwsConfig awsConfig, AwsMetadataApi awsMetadataApi, Environment environment) {
        this.awsConfig = awsConfig;
        this.awsMetadataApi = awsMetadataApi;
        this.environment = environment;
        this.ec2IamRole = this.resolveEc2IamRole();
    }

    private String resolveEc2IamRole() {
        if (!StringUtil.isNullOrEmptyAfterTrim(this.awsConfig.getAccessKey())) {
            return null;
        }
        if (!StringUtil.isNullOrEmptyAfterTrim(this.awsConfig.getIamRole()) && !"DEFAULT".equals(this.awsConfig.getIamRole())) {
            return this.awsConfig.getIamRole();
        }
        if (this.environment.isRunningOnEcs()) {
            LOGGER.info("Using IAM Task Role attached to ECS Task");
            return null;
        }
        try {
            String ec2IamRole = this.awsMetadataApi.defaultIamRoleEc2();
            LOGGER.info(String.format("Using IAM Role attached to EC2 Instance: '%s'", ec2IamRole));
            return ec2IamRole;
        }
        catch (RestClientException e) {
            if (e.getHttpErrorCode() == 404) {
                LOGGER.finest("IAM Role not found", e);
            } else {
                LOGGER.warning("Couldn't retrieve IAM Role from EC2 instance", e);
            }
        }
        catch (Exception e) {
            LOGGER.warning("Couldn't retrieve IAM Role from EC2 instance", e);
        }
        return null;
    }

    AwsCredentials credentials() {
        if (!StringUtil.isNullOrEmptyAfterTrim(this.awsConfig.getAccessKey())) {
            return AwsCredentials.builder().setAccessKey(this.awsConfig.getAccessKey()).setSecretKey(this.awsConfig.getSecretKey()).build();
        }
        if (!StringUtil.isNullOrEmptyAfterTrim(this.ec2IamRole)) {
            return this.fetchCredentialsFromEc2();
        }
        if (this.environment.isRunningOnEcs()) {
            return this.fetchCredentialsFromEcs();
        }
        throw new NoCredentialsException();
    }

    private AwsCredentials fetchCredentialsFromEc2() {
        LOGGER.fine(String.format("Fetching AWS Credentials using EC2 IAM Role: %s", this.ec2IamRole));
        try {
            return this.awsMetadataApi.credentialsEc2(this.ec2IamRole);
        }
        catch (Exception e) {
            throw new InvalidConfigurationException(String.format("Unable to retrieve credentials from IAM Role: '%s', please make sure it's attached to your EC2 Instance", this.awsConfig.getIamRole()), e);
        }
    }

    private AwsCredentials fetchCredentialsFromEcs() {
        LOGGER.fine("Fetching AWS Credentials from ECS IAM Task Role");
        try {
            return this.awsMetadataApi.credentialsEcs();
        }
        catch (Exception e) {
            throw new InvalidConfigurationException("Unable to retrieve credentials from IAM Role attached to ECS Task, please check your configuration");
        }
    }
}

