/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.querycache.subscriber;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.ContextMutexFactory;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.map.EventLostEvent;
import com.hazelcast.map.IMapEvent;
import com.hazelcast.map.impl.EntryEventFilter;
import com.hazelcast.map.impl.ListenerAdapter;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.event.EventData;
import com.hazelcast.map.impl.querycache.QueryCacheEventService;
import com.hazelcast.map.impl.querycache.QueryCacheListenerAdapter;
import com.hazelcast.map.impl.querycache.event.LocalCacheWideEventData;
import com.hazelcast.map.impl.querycache.event.LocalEntryEventData;
import com.hazelcast.map.impl.querycache.subscriber.QueryCacheEventListenerAdapters;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.query.impl.QueryEntry;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.eventservice.EventFilter;
import com.hazelcast.spi.impl.eventservice.EventRegistration;
import com.hazelcast.spi.impl.eventservice.EventService;
import com.hazelcast.spi.impl.eventservice.impl.Registration;
import com.hazelcast.spi.impl.eventservice.impl.TrueEventFilter;
import java.util.Collection;
import java.util.UUID;

public class NodeQueryCacheEventService
implements QueryCacheEventService<EventData> {
    private final EventService eventService;
    private final ContextMutexFactory lifecycleMutexFactory;
    private final MapServiceContext mapServiceContext;

    public NodeQueryCacheEventService(MapServiceContext mapServiceContext, ContextMutexFactory lifecycleMutexFactory) {
        this.mapServiceContext = mapServiceContext;
        NodeEngine nodeEngine = mapServiceContext.getNodeEngine();
        this.eventService = nodeEngine.getEventService();
        this.lifecycleMutexFactory = lifecycleMutexFactory;
    }

    @Override
    public void publish(String mapName, String cacheId, EventData eventData, int orderKey, Extractors extractors) {
        Preconditions.checkHasText(mapName, "mapName");
        Preconditions.checkHasText(cacheId, "cacheId");
        Preconditions.checkNotNull(eventData, "eventData cannot be null");
        this.publishLocalEvent(cacheId, eventData, extractors);
    }

    @Override
    public UUID addListener(String mapName, String cacheId, MapListener listener) {
        return this.addListener(mapName, cacheId, listener, null);
    }

    @Override
    public UUID addPublisherListener(String mapName, String cacheId, ListenerAdapter listenerAdapter) {
        return this.mapServiceContext.addListenerAdapter(listenerAdapter, TrueEventFilter.INSTANCE, cacheId);
    }

    @Override
    public boolean removePublisherListener(String mapName, String cacheId, UUID listenerId) {
        return this.mapServiceContext.removeEventListener(cacheId, listenerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UUID addListener(String mapName, String cacheId, MapListener listener, EventFilter filter) {
        Preconditions.checkHasText(mapName, "mapName");
        Preconditions.checkHasText(cacheId, "cacheId");
        Preconditions.checkNotNull(listener, "listener cannot be null");
        ListenerAdapter queryCacheListenerAdaptor = QueryCacheEventListenerAdapters.createQueryCacheListenerAdaptor(listener);
        SimpleQueryCacheListenerAdapter listenerAdaptor = new SimpleQueryCacheListenerAdapter(queryCacheListenerAdaptor);
        ContextMutexFactory.Mutex mutex = this.lifecycleMutexFactory.mutexFor(mapName);
        try {
            ContextMutexFactory.Mutex mutex2 = mutex;
            synchronized (mutex2) {
                EventRegistration registration = this.eventService.registerLocalListener("hz:impl:mapService", cacheId, filter == null ? TrueEventFilter.INSTANCE : filter, listenerAdaptor);
                UUID uUID = registration.getId();
                return uUID;
            }
        }
        finally {
            IOUtil.closeResource(mutex);
        }
    }

    @Override
    public boolean removeListener(String mapName, String cacheId, UUID listenerId) {
        return this.eventService.deregisterListener("hz:impl:mapService", cacheId, listenerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllListeners(String mapName, String cacheId) {
        ContextMutexFactory.Mutex mutex = this.lifecycleMutexFactory.mutexFor(mapName);
        try {
            ContextMutexFactory.Mutex mutex2 = mutex;
            synchronized (mutex2) {
                this.eventService.deregisterAllListeners("hz:impl:mapService", cacheId);
            }
        }
        finally {
            IOUtil.closeResource(mutex);
        }
    }

    @Override
    public boolean hasListener(String mapName, String cacheId) {
        Collection<EventRegistration> eventRegistrations = this.getRegistrations(cacheId);
        if (eventRegistrations.isEmpty()) {
            return false;
        }
        for (EventRegistration eventRegistration : eventRegistrations) {
            Registration registration = (Registration)eventRegistration;
            Object listener = registration.getListener();
            if (!(listener instanceof QueryCacheListenerAdapter)) continue;
            return true;
        }
        return false;
    }

    private void publishLocalEvent(String cacheId, Object eventData, Extractors extractors) {
        Collection<EventRegistration> eventRegistrations = this.getRegistrations(cacheId);
        if (eventRegistrations.isEmpty()) {
            return;
        }
        for (EventRegistration eventRegistration : eventRegistrations) {
            LocalEntryEventData localEntryEventData;
            Registration registration = (Registration)eventRegistration;
            Object listener = registration.getListener();
            if (!(listener instanceof QueryCacheListenerAdapter)) continue;
            LocalEntryEventData eventDataToPublish = eventData;
            int orderKey = -1;
            if (eventDataToPublish instanceof LocalCacheWideEventData) {
                orderKey = cacheId.hashCode();
            } else if (eventDataToPublish instanceof LocalEntryEventData && (localEntryEventData = (LocalEntryEventData)eventDataToPublish).getEventType() != EventLostEvent.EVENT_TYPE) {
                EventFilter filter = registration.getFilter();
                if (!this.canPassFilter(localEntryEventData, filter, extractors)) continue;
                boolean includeValue = this.isIncludeValue(filter);
                eventDataToPublish = includeValue ? localEntryEventData : localEntryEventData.cloneWithoutValue();
                Data keyData = localEntryEventData.getKeyData();
                orderKey = keyData == null ? -1 : keyData.hashCode();
            }
            this.publishEventInternal(registration, eventDataToPublish, orderKey);
        }
    }

    private boolean canPassFilter(LocalEntryEventData localEntryEventData, EventFilter filter, Extractors extractors) {
        if (filter == null || filter instanceof TrueEventFilter) {
            return true;
        }
        NodeEngine nodeEngine = this.mapServiceContext.getNodeEngine();
        SerializationService serializationService = nodeEngine.getSerializationService();
        Data keyData = localEntryEventData.getKeyData();
        Object value = this.getValueOrOldValue(localEntryEventData);
        QueryEntry entry = new QueryEntry(serializationService, keyData, value, extractors);
        return filter.eval(entry);
    }

    private boolean isIncludeValue(EventFilter filter) {
        if (filter instanceof EntryEventFilter) {
            return ((EntryEventFilter)filter).isIncludeValue();
        }
        return true;
    }

    private Object getValueOrOldValue(LocalEntryEventData localEntryEventData) {
        Object value = localEntryEventData.getValue();
        return value != null ? value : localEntryEventData.getOldValue();
    }

    private Collection<EventRegistration> getRegistrations(String mapName) {
        return this.eventService.getRegistrations("hz:impl:mapService", mapName);
    }

    private void publishEventInternal(EventRegistration registration, Object eventData, int orderKey) {
        this.eventService.publishEvent("hz:impl:mapService", registration, eventData, orderKey);
    }

    @Override
    public void sendEventToSubscriber(String name, Object eventData, int orderKey) {
        Collection<EventRegistration> eventRegistrations = this.getRegistrations(name);
        if (eventRegistrations.isEmpty()) {
            return;
        }
        for (EventRegistration eventRegistration : eventRegistrations) {
            Registration registration = (Registration)eventRegistration;
            Object listener = registration.getListener();
            if (listener instanceof QueryCacheListenerAdapter) continue;
            this.publishEventInternal(registration, eventData, orderKey);
        }
    }

    private static class SimpleQueryCacheListenerAdapter
    implements QueryCacheListenerAdapter<IMapEvent> {
        private final ListenerAdapter listenerAdapter;

        SimpleQueryCacheListenerAdapter(ListenerAdapter listenerAdapter) {
            this.listenerAdapter = listenerAdapter;
        }

        @Override
        public void onEvent(IMapEvent event) {
            this.listenerAdapter.onEvent(event);
        }
    }
}

