/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.common.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import lombok.NonNull;

public class ExceptionUtils {
    private ExceptionUtils() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String getMessage(Throwable e) {
        if (e == null) {
            return "";
        }
        try (StringWriter sw = new StringWriter();){
            PrintWriter pw = new PrintWriter(sw);
            try {
                e.printStackTrace(pw);
                pw.flush();
                sw.flush();
                String string = sw.toString();
                pw.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    pw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e1) {
            throw new RuntimeException("Failed to print exception logs", e1);
        }
    }

    public static Throwable getRootException(@NonNull Throwable e) {
        if (e == null) {
            throw new NullPointerException("e is marked non-null but is null");
        }
        Throwable cause = e.getCause();
        if (cause != null) {
            return ExceptionUtils.getRootException(cause);
        }
        return e;
    }
}

