/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Random;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.AesCtrCryptoCodec;
import org.apache.hadoop.crypto.Decryptor;
import org.apache.hadoop.crypto.Encryptor;
import org.apache.hadoop.crypto.OpensslCipher;
import org.apache.hadoop.crypto.random.OsSecureRandom;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.seatunnel.shade.hadoop.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class OpensslAesCtrCryptoCodec
extends AesCtrCryptoCodec {
    private static final Logger LOG = LoggerFactory.getLogger((String)OpensslAesCtrCryptoCodec.class.getName());
    private Configuration conf;
    private Random random;

    public OpensslAesCtrCryptoCodec() {
        String loadingFailureReason = OpensslCipher.getLoadingFailureReason();
        if (loadingFailureReason != null) {
            throw new RuntimeException(loadingFailureReason);
        }
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
        Class<Random> klass = conf.getClass("hadoop.security.secure.random.impl", OsSecureRandom.class, Random.class);
        try {
            this.random = ReflectionUtils.newInstance(klass, conf);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using " + klass.getName() + " as random number generator.");
            }
        }
        catch (Exception e) {
            LOG.info("Unable to use " + klass.getName() + ".  Falling back to Java SecureRandom.", (Throwable)e);
            this.random = new SecureRandom();
        }
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public Encryptor createEncryptor() throws GeneralSecurityException {
        return new OpensslAesCtrCipher(1);
    }

    @Override
    public Decryptor createDecryptor() throws GeneralSecurityException {
        return new OpensslAesCtrCipher(0);
    }

    @Override
    public void generateSecureRandom(byte[] bytes) {
        this.random.nextBytes(bytes);
    }

    @Override
    public void close() throws IOException {
        try {
            Closeable r = (Closeable)((Object)this.random);
            r.close();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        super.close();
    }

    private static class OpensslAesCtrCipher
    implements Encryptor,
    Decryptor {
        private final OpensslCipher cipher;
        private final int mode;
        private boolean contextReset = false;

        public OpensslAesCtrCipher(int mode) throws GeneralSecurityException {
            this.mode = mode;
            this.cipher = OpensslCipher.getInstance(AesCtrCryptoCodec.SUITE.getName());
        }

        @Override
        public void init(byte[] key, byte[] iv) throws IOException {
            Preconditions.checkNotNull(key);
            Preconditions.checkNotNull(iv);
            this.contextReset = false;
            this.cipher.init(this.mode, key, iv);
        }

        @Override
        public void encrypt(ByteBuffer inBuffer, ByteBuffer outBuffer) throws IOException {
            this.process(inBuffer, outBuffer);
        }

        @Override
        public void decrypt(ByteBuffer inBuffer, ByteBuffer outBuffer) throws IOException {
            this.process(inBuffer, outBuffer);
        }

        private void process(ByteBuffer inBuffer, ByteBuffer outBuffer) throws IOException {
            try {
                int inputSize = inBuffer.remaining();
                int n = this.cipher.update(inBuffer, outBuffer);
                if (n < inputSize) {
                    this.contextReset = true;
                    this.cipher.doFinal(outBuffer);
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        @Override
        public boolean isContextReset() {
            return this.contextReset;
        }
    }
}

