/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact;

import com.hazelcast.internal.nio.BufferObjectDataInput;
import java.io.IOException;

public interface OffsetReader {
    public static final int NULL_OFFSET = -1;
    public static final int BYTE_OFFSET_READER_RANGE = 255;
    public static final int SHORT_OFFSET_READER_RANGE = 65535;
    public static final OffsetReader BYTE_OFFSET_READER = (in, variableOffsetsPos, index) -> {
        byte offset = in.readByte(variableOffsetsPos + index);
        if (offset == -1) {
            return offset;
        }
        return Byte.toUnsignedInt(offset);
    };
    public static final OffsetReader SHORT_OFFSET_READER = (in, variableOffsetsPos, index) -> {
        short offset = in.readShort(variableOffsetsPos + index * 2);
        if (offset == -1) {
            return offset;
        }
        return Short.toUnsignedInt(offset);
    };
    public static final OffsetReader INT_OFFSET_READER = (in, variableOffsetsPos, index) -> in.readInt(variableOffsetsPos + index * 4);

    public int getOffset(BufferObjectDataInput var1, int var2, int var3) throws IOException;
}

