/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.common.metrics;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.common.metrics.Measurement;
import org.apache.seatunnel.api.common.metrics.MeasurementPredicates;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.SerializationFeature;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.node.ObjectNode;

public final class JobMetrics
implements Serializable {
    private static final JobMetrics EMPTY = new JobMetrics(Collections.emptyMap());
    private static final Collector<Measurement, ?, Map<String, List<Measurement>>> COLLECTOR = Collectors.groupingBy(Measurement::metric);
    private Map<String, List<Measurement>> metrics;

    JobMetrics() {
    }

    private JobMetrics(Map<String, List<Measurement>> metrics) {
        this.metrics = new HashMap<String, List<Measurement>>(metrics);
    }

    public static JobMetrics empty() {
        return EMPTY;
    }

    public static JobMetrics of(Map<String, List<Measurement>> metrics) {
        return new JobMetrics(metrics);
    }

    public JobMetrics merge(JobMetrics jobMetrics) {
        if (jobMetrics == null) {
            return this;
        }
        HashMap<String, List<Measurement>> metricsMap = new HashMap<String, List<Measurement>>();
        this.metrics.forEach((key, value) -> metricsMap.put((String)key, new ArrayList(value)));
        HashSet<String> keysToExclude = new HashSet<String>(Arrays.asList("member", "address"));
        jobMetrics.metrics.forEach((key, value) -> metricsMap.merge((String)key, (List<Measurement>)value, (v1, v2) -> {
            ArrayList<Measurement> ms = new ArrayList<Measurement>((Collection<Measurement>)v2);
            for (Measurement m1 : v1) {
                if (!v2.stream().noneMatch(m22 -> JobMetrics.areMapsEqualExcludingKeys(m22.getTags(), m1.getTags(), keysToExclude))) continue;
                ms.add(m1);
            }
            return ms;
        }));
        return new JobMetrics(metricsMap);
    }

    public static boolean areMapsEqualExcludingKeys(Map<String, String> map1, Map<String, String> map2, Set<String> keysToExclude) {
        if (map1 == null || map2 == null) {
            return false;
        }
        if (map1.size() != map2.size()) {
            return false;
        }
        HashMap<String, String> map1Copy = new HashMap<String, String>(map1);
        HashMap<String, String> map2Copy = new HashMap<String, String>(map2);
        for (String key : keysToExclude) {
            map1Copy.remove(key);
            map2Copy.remove(key);
        }
        return map1Copy.equals(map2Copy);
    }

    public Set<String> metrics() {
        return Collections.unmodifiableSet(this.metrics.keySet());
    }

    public List<Measurement> get(String metricName) {
        Objects.requireNonNull(metricName);
        List<Measurement> measurements = this.metrics.get(metricName);
        return measurements == null ? Collections.emptyList() : measurements;
    }

    public JobMetrics filter(String tagName, String tagValue) {
        return this.filter(MeasurementPredicates.tagValueEquals(tagName, tagValue));
    }

    public JobMetrics filter(Predicate<Measurement> predicate) {
        Objects.requireNonNull(predicate, "predicate");
        Map<String, List<Measurement>> filteredMetrics = this.metrics.values().stream().flatMap(Collection::stream).filter(predicate).collect(COLLECTOR);
        return new JobMetrics(filteredMetrics);
    }

    public int hashCode() {
        return this.metrics.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return Objects.equals(this.metrics, ((JobMetrics)obj).metrics);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.metrics.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).forEach(mainEntry -> {
            sb.append((String)mainEntry.getKey()).append(":\n");
            ((List)mainEntry.getValue()).stream().collect(Collectors.groupingBy(m3 -> {
                String vertex = m3.tag("taskName");
                return vertex == null ? "" : vertex;
            })).entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).forEach(e -> {
                String vertexName = (String)e.getKey();
                sb.append("  ").append(vertexName).append(":\n");
                ((List)e.getValue()).forEach(m3 -> sb.append("    ").append(m3).append("\n"));
            });
        });
        return sb.toString();
    }

    public String toJsonString() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        try {
            return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(this.metrics);
        }
        catch (JsonProcessingException e) {
            ObjectNode objectNode = objectMapper.createObjectNode();
            objectNode.put("err", "serialize JobMetrics err");
            return objectNode.toString();
        }
    }

    public Map<String, List<Measurement>> getMetrics() {
        return this.metrics;
    }
}

