/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.checkpoint.operation;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import org.apache.seatunnel.common.utils.ExceptionUtils;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.serializable.CheckpointDataSerializerHook;
import org.apache.seatunnel.engine.server.task.operation.TaskOperation;

public class CheckpointErrorReportOperation
extends TaskOperation {
    private String errorMsg;

    public CheckpointErrorReportOperation(TaskLocation taskLocation, Throwable e) {
        super(taskLocation);
        this.errorMsg = ExceptionUtils.getMessage(e);
    }

    @Override
    public void runInternal() throws Exception {
        SeaTunnelServer server = (SeaTunnelServer)this.getService();
        server.getCoordinatorService().getJobMaster(this.taskLocation.getJobId()).getCheckpointManager().reportCheckpointErrorFromTask(this.taskLocation, this.errorMsg);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeString(this.errorMsg);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.errorMsg = in.readString();
    }

    @Override
    public int getFactoryId() {
        return CheckpointDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 7;
    }

    public CheckpointErrorReportOperation() {
    }
}

