/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression;

import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import net.sf.jsqlparser.statement.select.PlainSelect;

public class ArrayConstructor
extends ASTNodeAccessImpl
implements Expression {
    private List<Expression> expressions;
    private boolean arrayKeyword;

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public void setExpressions(List<Expression> expressions) {
        this.expressions = expressions;
    }

    public boolean isArrayKeyword() {
        return this.arrayKeyword;
    }

    public void setArrayKeyword(boolean arrayKeyword) {
        this.arrayKeyword = arrayKeyword;
    }

    public ArrayConstructor(List<Expression> expressions, boolean arrayKeyword) {
        this.expressions = expressions;
        this.arrayKeyword = arrayKeyword;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.arrayKeyword) {
            sb.append("ARRAY");
        }
        sb.append("[");
        sb.append(PlainSelect.getStringList(this.expressions, true, false));
        sb.append("]");
        return sb.toString();
    }
}

