/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import org.apache.spark.sql.catalyst.util.RebaseDateTime$;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.package$;
import org.apache.spark.util.Utils$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class GeoDataSourceUtils$ {
    public static GeoDataSourceUtils$ MODULE$;

    static {
        new GeoDataSourceUtils$();
    }

    public Enumeration.Value datetimeRebaseMode(Function1<String, String> lookupFileMeta, String modeByConfig) {
        if (Utils$.MODULE$.isTesting()) {
            String string = SQLConf$.MODULE$.get().getConfString("spark.test.forceNoRebase", "");
            String string2 = "true";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED();
            }
        }
        return (Enumeration.Value)Option$.MODULE$.apply(lookupFileMeta.apply((Object)package$.MODULE$.SPARK_VERSION_METADATA_KEY())).map((Function1 & java.io.Serializable & Serializable)version -> new StringOps(Predef$.MODULE$.augmentString(version)).$less((Object)"3.0.0") || lookupFileMeta.apply((Object)"org.apache.spark.legacyDateTime") != null ? SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY() : SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED()).getOrElse((Function0 & java.io.Serializable & Serializable)() -> SQLConf.LegacyBehaviorPolicy$.MODULE$.withName(modeByConfig));
    }

    public Enumeration.Value int96RebaseMode(Function1<String, String> lookupFileMeta, String modeByConfig) {
        if (Utils$.MODULE$.isTesting()) {
            String string = SQLConf$.MODULE$.get().getConfString("spark.test.forceNoRebase", "");
            String string2 = "true";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED();
            }
        }
        return (Enumeration.Value)Option$.MODULE$.apply(lookupFileMeta.apply((Object)package$.MODULE$.SPARK_VERSION_METADATA_KEY())).map((Function1 & java.io.Serializable & Serializable)version -> new StringOps(Predef$.MODULE$.augmentString(version)).$less((Object)"3.1.0") || lookupFileMeta.apply((Object)"org.apache.spark.legacyINT96") != null ? SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY() : SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED()).getOrElse((Function0 & java.io.Serializable & Serializable)() -> SQLConf.LegacyBehaviorPolicy$.MODULE$.withName(modeByConfig));
    }

    public Function1<Object, Object> creteDateRebaseFuncInRead(Enumeration.Value rebaseMode, String format) {
        JFunction1.mcII.sp & java.io.Serializable & Serializable intersect;
        Enumeration.Value value = rebaseMode;
        Enumeration.Value value2 = SQLConf.LegacyBehaviorPolicy$.MODULE$.EXCEPTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            intersect = (JFunction1.mcII.sp & java.io.Serializable & Serializable)days -> {
                if (days < RebaseDateTime$.MODULE$.lastSwitchJulianDay()) {
                    throw DataSourceUtils$.MODULE$.newRebaseExceptionInRead(format);
                }
                return days;
            };
        } else {
            Enumeration.Value value4 = SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                intersect = (JFunction1.mcII.sp & java.io.Serializable & Serializable)days -> RebaseDateTime$.MODULE$.rebaseJulianToGregorianDays(days);
            } else {
                Enumeration.Value value6 = SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    intersect = (JFunction1.mcII.sp & java.io.Serializable & Serializable)x -> BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToInteger((int)x)));
                } else {
                    throw new MatchError((Object)value);
                }
            }
        }
        return intersect;
    }

    public Function1<Object, Object> creteTimestampRebaseFuncInRead(Enumeration.Value rebaseMode, String format) {
        JFunction1.mcJJ.sp & java.io.Serializable & Serializable intersect;
        Enumeration.Value value = rebaseMode;
        Enumeration.Value value2 = SQLConf.LegacyBehaviorPolicy$.MODULE$.EXCEPTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            intersect = (JFunction1.mcJJ.sp & java.io.Serializable & Serializable)micros -> {
                if (micros < RebaseDateTime$.MODULE$.lastSwitchJulianTs()) {
                    throw DataSourceUtils$.MODULE$.newRebaseExceptionInRead(format);
                }
                return micros;
            };
        } else {
            Enumeration.Value value4 = SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                intersect = (JFunction1.mcJJ.sp & java.io.Serializable & Serializable)micros -> RebaseDateTime$.MODULE$.rebaseJulianToGregorianMicros(micros);
            } else {
                Enumeration.Value value6 = SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    intersect = (JFunction1.mcJJ.sp & java.io.Serializable & Serializable)x -> BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToLong((long)x)));
                } else {
                    throw new MatchError((Object)value);
                }
            }
        }
        return intersect;
    }

    private GeoDataSourceUtils$() {
        MODULE$ = this;
    }
}

