/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetFileFormat$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetUtils;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOptions;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class GeoParquetUtils$ {
    public static GeoParquetUtils$ MODULE$;

    static {
        new GeoParquetUtils$();
    }

    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> parameters, Seq<FileStatus> files) {
        Seq seq;
        ParquetOptions parquetOptions = new ParquetOptions(parameters, sparkSession.sessionState().conf());
        boolean shouldMergeSchemas = parquetOptions.mergeSchema();
        boolean mergeRespectSummaries = sparkSession.sessionState().conf().isParquetSchemaRespectSummaries();
        GeoParquetUtils.FileTypes filesByType = this.splitFiles(files);
        if (shouldMergeSchemas) {
            Seq<FileStatus> needMerged = mergeRespectSummaries ? (Seq<FileStatus>)Nil$.MODULE$ : filesByType.data();
            seq = (Seq)((TraversableLike)needMerged.$plus$plus(filesByType.metadata(), Seq$.MODULE$.canBuildFrom())).$plus$plus(filesByType.commonMetadata(), Seq$.MODULE$.canBuildFrom());
        } else {
            seq = Option$.MODULE$.option2Iterable(filesByType.commonMetadata().headOption().orElse((Function0 & Serializable & scala.Serializable)() -> filesByType.metadata().headOption()).orElse((Function0 & Serializable & scala.Serializable)() -> filesByType.data().headOption())).toSeq();
        }
        Seq filesToTouch = seq;
        return GeoParquetFileFormat$.MODULE$.mergeSchemasInParallel(parameters, (Seq<FileStatus>)filesToTouch, sparkSession);
    }

    private GeoParquetUtils.FileTypes splitFiles(Seq<FileStatus> allFiles) {
        FileStatus[] leaves = (FileStatus[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allFiles.toArray(ClassTag$.MODULE$.apply(FileStatus.class)))).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getPath().toString(), (Ordering)Ordering.String$.MODULE$);
        return new GeoParquetUtils.FileTypes((Seq<FileStatus>)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])leaves)).filterNot((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)GeoParquetUtils$.MODULE$.isSummaryFile(f.getPath())))), (Seq<FileStatus>)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])leaves)).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)GeoParquetUtils$.$anonfun$splitFiles$3(x$2)))), (Seq<FileStatus>)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])leaves)).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)GeoParquetUtils$.$anonfun$splitFiles$4(x$3)))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isSummaryFile(Path file) {
        String string = file.getName();
        String string2 = "_common_metadata";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = file.getName();
        String string4 = "_metadata";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$splitFiles$3(FileStatus x$2) {
        String string = x$2.getPath().getName();
        String string2 = "_metadata";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$splitFiles$4(FileStatus x$3) {
        String string = x$3.getPath().getName();
        String string2 = "_common_metadata";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private GeoParquetUtils$() {
        MODULE$ = this;
    }
}

