/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.formatMapper.netcdfParser;

import java.io.IOException;
import java.io.Serializable;
import org.apache.sedona.core.formatMapper.netcdfParser.HDFSRandomAccessFile;
import ucar.ma2.Array;
import ucar.ma2.Index;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasets;
import ucar.unidata.io.RandomAccessFile;

public class SerNetCDFUtils
implements Serializable {
    public static Array getNetCDF2DArray(NetcdfDataset netcdfFile, String variable) {
        Variable netcdfVal = netcdfFile.findVariable(variable);
        Array searchVariable = null;
        try {
            searchVariable = netcdfVal.read();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return searchVariable;
    }

    public static Double getDataAsym(Array array, int i, int j, int offset, int increment) {
        Index dataIndex = Index.factory((int[])array.getShape());
        int[] location = new int[]{offset + i * increment, offset + j * increment};
        dataIndex.set(location);
        switch (array.getDataType()) {
            case INT: {
                return new Double(((Integer)array.getObject(dataIndex)).intValue());
            }
            case SHORT: {
                return new Double(((Short)array.getObject(dataIndex)).shortValue());
            }
            case FLOAT: {
                return new Double(((Float)array.getObject(dataIndex)).floatValue());
            }
            case DOUBLE: {
                return new Double((Double)array.getObject(dataIndex));
            }
            case LONG: {
                return new Double(((Long)array.getObject(dataIndex)).longValue());
            }
        }
        return (Double)array.getObject(dataIndex);
    }

    public static Double getDataSym(Array array, int i, int j) {
        Index dataIndex = Index.factory((int[])array.getShape());
        int[] location = new int[]{i, j};
        dataIndex.set(location);
        switch (array.getDataType()) {
            case INT: {
                return new Double(((Integer)array.getObject(dataIndex)).intValue());
            }
            case SHORT: {
                return new Double(((Short)array.getObject(dataIndex)).shortValue());
            }
            case FLOAT: {
                return new Double(((Float)array.getObject(dataIndex)).floatValue());
            }
            case DOUBLE: {
                return new Double((Double)array.getObject(dataIndex));
            }
            case LONG: {
                return new Double(((Long)array.getObject(dataIndex)).longValue());
            }
        }
        return (Double)array.getObject(dataIndex);
    }

    public static NetcdfDataset loadNetCDFDataSet(String url) {
        NetcdfDataset dataset = null;
        try {
            dataset = NetcdfDatasets.openDataset((String)url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataset;
    }

    public static NetcdfDataset loadDFSNetCDFDataSet(String dfsUri, String location, Integer bufferSize) {
        NetcdfDataset dataset = null;
        try {
            HDFSRandomAccessFile raf = new HDFSRandomAccessFile(dfsUri, location, bufferSize);
            dataset = new NetcdfDataset(NetcdfFile.open((RandomAccessFile)raf, (String)location, null, null));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataset;
    }

    public static Integer getDimensionSize(NetcdfDataset netcdfFile, String rowDim) {
        int dimSize = -1;
        for (Dimension d : netcdfFile.getDimensions()) {
            if (!d.getShortName().equals(rowDim)) continue;
            dimSize = d.getLength();
        }
        if (dimSize < 0) {
            throw new IllegalStateException("Dimension does not exist!!!");
        }
        return dimSize;
    }
}

