/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.jiffle.parser;

import it.geosolutions.jaiext.jiffle.parser.BaseWorker;
import it.geosolutions.jaiext.jiffle.parser.TreeNodeProperties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;

public abstract class PropertyWorker<T>
extends BaseWorker {
    final Logger LOGGER = Logger.getLogger(this.getClass().getName());
    protected final TreeNodeProperties<T> properties = new TreeNodeProperties();

    public PropertyWorker(ParseTree tree) {
        super(tree);
    }

    public TreeNodeProperties<T> getProperties() {
        return new TreeNodeProperties<T>(this.properties);
    }

    protected T get(ParseTree ctx) {
        return (T)this.properties.get(ctx);
    }

    protected T getOrElse(ParseTree ctx, T fallback) {
        if (ctx == null) {
            return fallback;
        }
        Object prop = this.properties.get(ctx);
        return (T)(prop == null ? fallback : prop);
    }

    protected void set(ParseTree ctx, T node) {
        if (ctx instanceof ParserRuleContext && this.LOGGER.isLoggable(Level.FINE)) {
            ParserRuleContext prc = (ParserRuleContext)ctx;
            Token start = prc.getStart();
            String lineColumn = "(" + start.getLine() + ":" + start.getCharPositionInLine() + ")";
            this.LOGGER.fine("Token " + start.getText() + ", type " + ctx.getClass().getSimpleName() + " at " + lineColumn + " set to " + node);
        }
        this.properties.put(ctx, node);
    }
}

