/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.snowflake.snowsql.udtfs;

import java.util.stream.Stream;
import org.apache.sedona.snowflake.snowsql.GeometrySerde;
import org.apache.sedona.snowflake.snowsql.annotations.UDTFAnnotations;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;

@UDTFAnnotations.TabularFunc(name="ST_InterSection_Aggr", argNames={"geom"})
public class ST_Intersection_Aggr {
    Geometry buffer = null;

    public static Class getOutputClass() {
        return OutputRow.class;
    }

    public Stream<OutputRow> process(byte[] geom) throws ParseException {
        Geometry geometry = GeometrySerde.deserialize(geom);
        if (this.buffer == null) {
            this.buffer = geometry;
        } else if (!this.buffer.equalsExact(geometry)) {
            this.buffer = this.buffer.intersection(geometry);
        }
        return Stream.empty();
    }

    public Stream<OutputRow> endPartition() {
        return Stream.of(new OutputRow(GeometrySerde.serialize(this.buffer)));
    }

    public static class OutputRow {
        public byte[] intersected;

        public OutputRow(byte[] intersected) {
            this.intersected = intersected;
        }
    }
}

