Sedona has received numerous help from the community. This page lists the contributors and committers of Apache Sedona. People on this page are ordered by their last name.

## Committers

A contributor who contributes enough code to Sedona will be promoted to a committer. A committer has the write access to Sedona main repository

## Project Management Committee (PMC)

A committer will be promoted to a PMC member when the community thinks he/she is able to be in charge at least a major component of this project.

Current Sedona PMC members are as follows:

|        Name       |  GitHub ID  |        Apache ID       |
|:-----------------:|:-----------:|:----------------------:|
|    Adam Binford   | Kimahriman  |  kimahriman@apache.org |
| Kanchan Chowdhury | kanchanchy  | kanchanchy@apache.org  |
| Paweł Kociński    |  Imbruced   |   imbruced@apache.org  |
|      Yitao Li     |  yitao-li   |   yitaoli@apache.org   |
|   Netanel Malka   | netanel246  |    malka@apache.org    |
| Kristin Cowalcijk | Kontinuation| kontinuation@apache.org|
|   Mohamed Sarwat  |   Sarwat    |   mosarwat@apache.org  |
| Kengo Seki        |   sekikn    | sekikn@apache.org      |
|    Sachio Wakai   |  SW186000   |    swakai@apache.org   |
|     Jinxuan Wu    | jinxuan     |   jinxuanw@apache.org  |
|       Jia Yu      |  jiayuasu   |    jiayu@apache.org    |
|    Zongsi Zhang   | zongsizhang | zongsizhang@apache.org |
|     Felix Cheung     ||	felixcheung@apache.org |
|     Von Gosling      || vongosling@apache.org |
| Jean-Baptiste Onofré || jbonofre@apache.org |
|   George Percivall   || percivall@apache.org |
|     Sunil Govindan   ||sunilg@apache.org|

## Become a committer

To get started contributing to Sedona, learn [how to contribute](rule.md) – anyone can submit patches, documentation and examples to the project.

The PMC regularly adds new committers from the active contributors, based on their contributions to Sedona. The qualifications for new committers include:

* Sustained contributions to Sedona: Committers should have a history of major contributions to Sedona.
* Quality of contributions: Committers more than any other community member should submit simple, well-tested, and well-designed patches. In addition, they should show sufficient expertise to be able to review patches.
* Community involvement: Committers should have a constructive and friendly attitude in all community interactions. They should also be active on the dev mailing list & Gitter, and help mentor newer contributors and users.

The PMC also adds new PMC members. PMC members are expected to carry out PMC responsibilities as described in Apache Guidance, including helping vote on releases, enforce Apache project trademarks, take responsibility for legal and license issues, and ensure the project follows Apache project mechanics. The PMC periodically adds committers to the PMC who have shown they understand and can help with these activities.

Current Sedona Committers are as follows:

|        Name       |  GitHub ID  |        Apache ID       |
|:-----------------:|:-----------:|:----------------------:|
|  Nilesh Gajwani   | 	iGN5117  	 |  nilesh@apache.org     |
|  Furqaan Khan   | 	furqaankhan  	 |  furqaan@apache.org     |

## Nominate a committer or PMC member

Steps are as follows:
1. Call a vote (templates/committerVote.txt)
2. Close the vote. If the result is positive, invite the new committer.

### Call for a vote

We do the vote and discussion on the private@sedona.apache.org to enable a frank discussion.

Let the Vote thread run for one week. A positive result is achieved by Consensus Approval: at least 3 +1 votes and no vetoes.

#### PMC vote template

This is the email to commence a vote for a new PMC candidate. New PMC members need to be voted for by the existing PMC members and subsequently approved by the Board.

```
To: private@sedona.apache.org
Subject: [VOTE] New PMC candidate: [New PMC NAME]

[ add the reasons behind your nomination here ]

Voting ends one week from today, or until at least 3 +1 votes are cast.

```

### Close a vote

This email ends the vote and reports the result to the project.

```
To: private@sedona.apache.org
Subject: [VOTE][RESULT] New PMC candidate: [New PMC NAME]

The vote has now closed: [paste the vote thread on https://lists.apache.org/list.html?private@sedona.apache.org]. The results are:

Binding Votes:

+1 [TOTAL BINDING +1 VOTES]
 0 [TOTAL BINDING +0/-0 VOTES]
-1 [TOTAL BINDING -1 VOTES]

The vote is ***successful/not successful***
```

### Send a notice to ASF Board

The nominating PMC member should send a message to the ASF Board (board@apache.org) with a reference to the vote result in the following form:

```
To: board at apache.org
CC: private at sedona.apache.org
Subject: [NOTICE] New PMC NAME for Apache Sedona PMC
Body:

New PMC NAME has been voted as a new member of the Apache Sedona PMC. the vote thread is at: *link to the vote result thread*
```

### Send the invitation

```
To: New PMC Email address
CC: private@sedona.apache.org

Hello [New PMC NAME],

The Sedona Project Management Committee (PMC)
hereby offers you committer privileges to the project
[as well as membership in the PMC]. These privileges are
offered on the understanding that you'll use them
reasonably and with common sense. We like to work on trust
rather than unnecessary constraints.

Being a committer enables you to more easily make
changes without needing to go through the patch
submission process. Being a PMC member enables you
to guide the direction of the project.

Being a committer does not require you to
participate any more than you already do. It does
tend to make one even more committed.  You will
probably find that you spend more time here.

Of course, you can decline and instead remain as a
contributor, participating as you do now.

A. This personal invitation is a chance for you to
accept or decline in private.  Either way, please
let us know in reply to the private@sedona.apache.org
address only.

B. If you accept, the next step is to register an iCLA:
    1. Details of the iCLA and the forms are found
    through this link: https://www.apache.org/licenses/#clas

    2. Instructions for its completion and return to
    the Secretary of the ASF are found at
    https://www.apache.org/licenses/#submitting

    3. When you transmit the completed iCLA, request
    to notify the Apache Sedona project and choose a
    unique Apache ID. Look to see if your preferred
    ID is already taken at
    https://people.apache.org/committer-index.html
    This will allow the Secretary to notify the PMC
    when your iCLA has been recorded.

When recording of your iCLA is noted, you will
receive a follow-up message with the next steps for
establishing you as a committer.

```

### PMC Accept and ICLA instruction

```
To: New PMC Email address
Cc: private@sedona.apache.org
Subject: Re: invitation to become Apache Sedona PMC

Welcome. Here are the next steps in becoming a project committer. After that we will make an announcement to the dev@sedona.apache.org

1. You need to send a Contributor License Agreement to the ASF.
Normally you would send an Individual CLA. If you also make
contributions done in work time or using work resources,
see the Corporate CLA. Ask us if you have any issues.
https://www.apache.org/licenses/#clas.

You need to choose a preferred ASF user name and alternatives.
In order to ensure it is available you can view a list of taken IDs at
https://people.apache.org/committer-index.html

Please notify us when you have submitted the CLA and by what means
you did so. This will enable us to monitor its progress.

We will arrange for your Apache user account when the CLA has
been recorded.

2. After that is done, please use your ASF email to subscribe to the dev@sedona.apache.org
and private@sedona.apache.org by sending an email to dev-subscribe@sedona.apache.org and
private-subscribe@sedona.apache.org. We generally discuss everything on the dev list and
keep the private@sedona.apache.org list for occasional matters which must be private.

The developer section of the website describes roles within the ASF and provides other
resources:
  https://www.apache.org/foundation/how-it-works.html
  https://www.apache.org/dev/

Just as before you became a committer, participation in any ASF community
requires adherence to the ASF Code of Conduct:
  https://www.apache.org/foundation/policies/conduct.html

Yours,
The Apache Sedona PMC
```

### Create ASF account

Once the ICLA has been filed, use the [ASF New Account Request form](https://whimsy.apache.org/officers/acreq) to generate the request. Sedona mentors will request the account.

Once Sedona graduates, the PMC chair will make the request.

### Add to the system

Once the new PMC subscribes to the Sedona mailing lists using his/her ASF account, one of the PMC needs to add the new PMC to the Whimsy system (https://whimsy.apache.org/roster/pmc/sedona).

### PMC announcement

This is the email to announce the new committer to sedona-dev once the account has been created.

```
To: dev@sedona.apache.org
Subject: new committer: ###New PMC NAME

The Project Management Committee (PMC) for Apache Sedona
has invited New PMC NAME to become a committer and we are pleased
to announce that they have accepted.

### add specific details here ###

Being a committer enables easier contribution to the
project since there is no need to go via the patch
submission process. This should enable better productivity.
A PMC member helps manage and guide the direction of the project.
```

### Committer Done Template

After the committer account is established.

```
To: New PMC Email
CC: private@sedona.apache.org
Subject: account request: New PMC NAME

New PMC NAME, as you know, the ASF Infrastructure has set up your
committer account with the username '####'.

You have commit access to specific sections of the
ASF repository, as follows:
https://github.com/apache/sedona

You need to link your ASF Account with your GitHub account.

Here are the steps

1. Verify you have a GitHub ID enabled with 2FA
	* https://help.github.com/articles/securing-your-account-with-two-factor-authentication-2fa/
2. Enter your GitHub ID into your Apache ID profile https://id.apache.org/
3. Merge your Apache and GitHub accounts using
	* GitBox (Apache Account Linking utility) https://gitbox.apache.org/setup/
	* You should see 3 green checks in GitBox.
	* Wait at least 30  minutes for an email inviting you to Apache GitHub Organization and accept invitation
4. After accepting the GitHub Invitation verify that you are a
member of the team https://github.com/orgs/apache/teams/sedona-committers

Optionally, if you want, please follow the instructions to set up your GitHub, SSH, svn password, svn configuration, email forwarding, etc.
https://www.apache.org/dev/#committers

Additionally, if you have been elected to the Sedona
 Project Mgmt. Committee (PMC): Verify you are part of the LDAP sedona
  pmc https://whimsy.apache.org/roster/pmc/sedona
```
