/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.annotations.GwtCompatible;
import com.google.common.geometry.EncodedInts;
import com.google.common.geometry.PrimitiveArrays;
import com.google.common.geometry.S2CellId;
import com.google.common.geometry.S2CellIdVector;
import com.google.common.geometry.S2Coder;
import com.google.common.geometry.UintVectorCoder;
import com.google.common.primitives.UnsignedLongs;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

@GwtCompatible
class S2CellIdVectorCoder
implements S2Coder<List<S2CellId>> {
    static final S2CellIdVectorCoder INSTANCE = new S2CellIdVectorCoder();

    S2CellIdVectorCoder() {
    }

    @Override
    public void encode(final List<S2CellId> values, OutputStream output) throws IOException {
        long valuesOr = 0L;
        long valuesAnd = -1L;
        long valuesMin = -1L;
        long valuesMax = 0L;
        for (S2CellId cellId : values) {
            valuesOr |= cellId.id();
            valuesAnd &= cellId.id();
            valuesMin = UnsignedLongs.min(valuesMin, cellId.id());
            valuesMax = UnsignedLongs.max(valuesMax, cellId.id());
        }
        long base = 0L;
        int baseBytes = 0;
        int shift = 0;
        int maxDeltaMsb = 0;
        if (UnsignedLongs.compare(valuesOr, 0L) > 0) {
            shift = Math.min(56, Long.numberOfTrailingZeros(valuesOr) & 0xFFFFFFFE);
            if ((valuesAnd & 1L << shift) != 0L) {
                ++shift;
            }
            int minBytes = -1;
            for (int tmpBaseBytes = 0; tmpBaseBytes < 8; ++tmpBaseBytes) {
                long tmpBase = valuesMin & (-1L >>> 8 * tmpBaseBytes ^ 0xFFFFFFFFFFFFFFFFL);
                int tmpMaxDeltaMsb = Math.max(0, 63 - Long.numberOfLeadingZeros(valuesMax - tmpBase >>> shift));
                int candidateBytes = tmpBaseBytes + values.size() * ((tmpMaxDeltaMsb >> 3) + 1);
                if (UnsignedLongs.compare(candidateBytes, minBytes) >= 0) continue;
                base = tmpBase;
                baseBytes = tmpBaseBytes;
                maxDeltaMsb = tmpMaxDeltaMsb;
                minBytes = candidateBytes;
            }
            if ((shift & 1) != 0 && (maxDeltaMsb & 7) != 7) {
                --shift;
            }
        }
        assert (shift <= 56);
        int shiftCode = shift >> 1;
        if ((shift & 1) != 0) {
            shiftCode = Math.min(31, shiftCode + 29);
        }
        output.write((byte)(shiftCode << 3 | baseBytes));
        if (shiftCode == 31) {
            output.write((byte)(shift >> 1));
        }
        long baseCode = base >>> 64 - 8 * Math.max(1, baseBytes);
        EncodedInts.encodeUintWithLength(output, baseCode, baseBytes);
        final long tmpBase = base;
        final long tmpShift = shift;
        UintVectorCoder.UINT64.encode(new PrimitiveArrays.Longs(){

            @Override
            public long get(int position) {
                return ((S2CellId)values.get(position)).id() - tmpBase >>> (int)tmpShift;
            }

            @Override
            public int length() {
                return values.size();
            }
        }, output);
    }

    @Override
    public S2CellIdVector decode(PrimitiveArrays.Bytes data, PrimitiveArrays.Cursor cursor) {
        long shift;
        int shiftCodeBaseBytes;
        int shiftCode;
        if ((shiftCode = (shiftCodeBaseBytes = data.get(cursor.position++) & 0xFF) >> 3) == 31) {
            shiftCode = 29 + (data.get(cursor.position++) & 0xFF);
        }
        int baseBytes = shiftCodeBaseBytes & 7;
        long base = data.readUintWithLength(cursor, baseBytes);
        base <<= 64 - 8 * Math.max(1, baseBytes);
        if (shiftCode >= 29) {
            shift = 2L * (long)(shiftCode - 29) + 1L;
            base |= 1L << (int)(shift - 1L);
        } else {
            shift = 2L * (long)shiftCode;
        }
        final long tmpBase = base;
        final PrimitiveArrays.Longs deltas = UintVectorCoder.UINT64.decode(data, cursor);
        return new S2CellIdVector(){

            @Override
            public int size() {
                return deltas.length();
            }

            @Override
            public S2CellId get(int index) {
                return new S2CellId((deltas.get(index) << (int)shift) + tmpBase);
            }

            @Override
            int lowerBound(S2CellId target) {
                if (UnsignedLongs.compare(target.id(), tmpBase) <= 0) {
                    return 0;
                }
                if (target.greaterOrEquals(S2CellId.end(30))) {
                    return this.size();
                }
                int low = 0;
                int high = deltas.length();
                long needle = target.id() - tmpBase + (1L << (int)shift) - 1L >>> (int)shift;
                while (low < high) {
                    int mid = low + high >> 1;
                    long value = deltas.get(mid);
                    if (UnsignedLongs.compare(value, needle) < 0) {
                        low = mid + 1;
                        continue;
                    }
                    high = mid;
                }
                return low;
            }
        };
    }
}

