/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.time.ZoneId;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetOutputCommitter;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.ParquetRecordReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.codec.CodecConfig;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.util.ContextUtil;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.RebaseDateTime;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetFileFormat$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetFileFormatBase;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetMetaData;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetMetaData$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetSpatialFilter;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetUtils$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetWriteSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFilters;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFooterReader;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOptions;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOutputWriter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetRowIndexUtil$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u0015b\u0001B\u000b\u0017\u0001\u0015B\u0001b\u0011\u0001\u0003\u0006\u0004%\t\u0001\u0012\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u000b\")A\n\u0001C\u0001\u001b\")A\n\u0001C\u0001!\")\u0011\u000b\u0001C!%\")1\f\u0001C!9\")\u0001\r\u0001C\u0001C\")1\r\u0001C!I\"9\u00111\u0006\u0001\u0005B\u00055\u0002bBA(\u0001\u0011\u0005\u0013\u0011\u000b\u0005\b\u00037\u0003A\u0011IAO\u0011\u001d\tI\u000b\u0001C!\u0003W;q!a-\u0017\u0011\u0003\t)L\u0002\u0004\u0016-!\u0005\u0011q\u0017\u0005\u0007\u0019:!\t!a0\t\u000f\u0005\u0005g\u0002\"\u0001\u0002D\"9\u0011Q\u001a\b\u0005\n\u0005=\u0007bBA\u0000\u001d\u0011%!\u0011\u0001\u0005\b\u0005\u0017qA\u0011\u0002B\u0007\u0011%\u0011)BDA\u0001\n\u0013\u00119B\u0001\u000bHK>\u0004\u0016M]9vKR4\u0015\u000e\\3G_Jl\u0017\r\u001e\u0006\u0003/a\tq\u0001]1scV,GO\u0003\u0002\u001a5\u0005YA-\u0019;bg>,(oY3t\u0015\tYB$A\u0005fq\u0016\u001cW\u000f^5p]*\u0011QDH\u0001\u0004gFd'BA\u0010!\u0003\u0015\u0019\b/\u0019:l\u0015\t\t#%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002G\u0005\u0019qN]4\u0004\u0001M9\u0001A\n\u0016.c]j\u0004CA\u0014)\u001b\u00051\u0012BA\u0015\u0017\u0005E\u0001\u0016M]9vKR4\u0015\u000e\\3G_Jl\u0017\r\u001e\t\u0003O-J!\u0001\f\f\u00031\u001d+w\u000eU1scV,GOR5mK\u001a{'/\\1u\u0005\u0006\u001cX\r\u0005\u0002/_5\t\u0001$\u0003\u000211\tQa)\u001b7f\r>\u0014X.\u0019;\u0011\u0005I*T\"A\u001a\u000b\u0005Qb\u0012aB:pkJ\u001cWm]\u0005\u0003mM\u0012!\u0003R1uCN{WO]2f%\u0016<\u0017n\u001d;feB\u0011\u0001hO\u0007\u0002s)\u0011!HH\u0001\tS:$XM\u001d8bY&\u0011A(\u000f\u0002\b\u0019><w-\u001b8h!\tq\u0014)D\u0001@\u0015\u0005\u0001\u0015!B:dC2\f\u0017B\u0001\"@\u00051\u0019VM]5bY&T\u0018M\u00197f\u00035\u0019\b/\u0019;jC24\u0015\u000e\u001c;feV\tQ\tE\u0002?\r\"K!aR \u0003\r=\u0003H/[8o!\t9\u0013*\u0003\u0002K-\t9r)Z8QCJ\fX/\u001a;Ta\u0006$\u0018.\u00197GS2$XM]\u0001\u000fgB\fG/[1m\r&dG/\u001a:!\u0003\u0019a\u0014N\\5u}Q\u0011aj\u0014\t\u0003O\u0001AQaQ\u0002A\u0002\u0015#\u0012AT\u0001\u0007KF,\u0018\r\\:\u0015\u0005M3\u0006C\u0001 U\u0013\t)vHA\u0004C_>dW-\u00198\t\u000b]+\u0001\u0019\u0001-\u0002\u000b=$\b.\u001a:\u0011\u0005yJ\u0016B\u0001.@\u0005\r\te._\u0001\tQ\u0006\u001c\bnQ8eKR\tQ\f\u0005\u0002?=&\u0011ql\u0010\u0002\u0004\u0013:$\u0018!F<ji\"\u001c\u0006/\u0019;jC2\u0004&/\u001a3jG\u0006$Xm\u001d\u000b\u0003\u001d\nDQaQ\u0004A\u0002!\u000b1\"\u001b8gKJ\u001c6\r[3nCR)Q\r\u001c:\u0002\u0006A\u0019aH\u00124\u0011\u0005\u001dTW\"\u00015\u000b\u0005%d\u0012!\u0002;za\u0016\u001c\u0018BA6i\u0005)\u0019FO];diRK\b/\u001a\u0005\u0006[\"\u0001\rA\\\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003_Bl\u0011\u0001H\u0005\u0003cr\u0011Ab\u00159be.\u001cVm]:j_:DQa\u001d\u0005A\u0002Q\f!\u0002]1sC6,G/\u001a:t!\u0011)Hp`@\u000f\u0005YT\bCA<@\u001b\u0005A(BA=%\u0003\u0019a$o\\8u}%\u00111pP\u0001\u0007!J,G-\u001a4\n\u0005ut(aA'ba*\u00111p\u0010\t\u0004k\u0006\u0005\u0011bAA\u0002}\n11\u000b\u001e:j]\u001eDq!a\u0002\t\u0001\u0004\tI!A\u0003gS2,7\u000f\u0005\u0004\u0002\f\u0005U\u00111\u0004\b\u0005\u0003\u001b\t\tBD\u0002x\u0003\u001fI\u0011\u0001Q\u0005\u0004\u0003'y\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003/\tIBA\u0002TKFT1!a\u0005@!\u0011\ti\"a\n\u000e\u0005\u0005}!\u0002BA\u0011\u0003G\t!AZ:\u000b\u0007\u0005\u0015\u0002%\u0001\u0004iC\u0012|w\u000e]\u0005\u0005\u0003S\tyB\u0001\u0006GS2,7\u000b^1ukN\fA\u0002\u001d:fa\u0006\u0014Xm\u0016:ji\u0016$\"\"a\f\u00026\u0005]\u0012qIA&!\rq\u0013\u0011G\u0005\u0004\u0003gA\"aE(viB,Ho\u0016:ji\u0016\u0014h)Y2u_JL\b\"B7\n\u0001\u0004q\u0007bBA\u001d\u0013\u0001\u0007\u00111H\u0001\u0004U>\u0014\u0007\u0003BA\u001f\u0003\u0007j!!a\u0010\u000b\t\u0005\u0005\u00131E\u0001\n[\u0006\u0004(/\u001a3vG\u0016LA!!\u0012\u0002@\t\u0019!j\u001c2\t\r\u0005%\u0013\u00021\u0001u\u0003\u001dy\u0007\u000f^5p]NDa!!\u0014\n\u0001\u00041\u0017A\u00033bi\u0006\u001c6\r[3nC\u0006q\"-^5mIJ+\u0017\rZ3s/&$\b\u000eU1si&$\u0018n\u001c8WC2,Xm\u001d\u000b\u0011\u0003'\n\t(a\u001d\u0002v\u0005e\u0014QPAE\u0003\u0017\u0003rAPA+\u00033\ny&C\u0002\u0002X}\u0012\u0011BR;oGRLwN\\\u0019\u0011\u00079\nY&C\u0002\u0002^a\u0011q\u0002U1si&$\u0018n\u001c8fI\u001aKG.\u001a\t\u0007\u0003\u0017\t\t'!\u001a\n\t\u0005\r\u0014\u0011\u0004\u0002\t\u0013R,'/\u0019;peB!\u0011qMA7\u001b\t\tIGC\u0002\u0002lq\t\u0001bY1uC2L8\u000f^\u0005\u0005\u0003_\nIGA\u0006J]R,'O\\1m%><\b\"B7\u000b\u0001\u0004q\u0007BBA'\u0015\u0001\u0007a\r\u0003\u0004\u0002x)\u0001\rAZ\u0001\u0010a\u0006\u0014H/\u001b;j_:\u001c6\r[3nC\"1\u00111\u0010\u0006A\u0002\u0019\faB]3rk&\u0014X\rZ*dQ\u0016l\u0017\rC\u0004\u0002\u0000)\u0001\r!!!\u0002\u000f\u0019LG\u000e^3sgB1\u00111BA\u000b\u0003\u0007\u00032AMAC\u0013\r\t9i\r\u0002\u0007\r&dG/\u001a:\t\r\u0005%#\u00021\u0001u\u0011\u001d\tiI\u0003a\u0001\u0003\u001f\u000b!\u0002[1e_>\u00048i\u001c8g!\u0011\t\t*a&\u000e\u0005\u0005M%\u0002BAK\u0003G\tAaY8oM&!\u0011\u0011TAJ\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u0006y1/\u001e9q_J$H)\u0019;b)f\u0004X\rF\u0002T\u0003?Cq!!)\f\u0001\u0004\t\u0019+\u0001\u0005eCR\fG+\u001f9f!\r9\u0017QU\u0005\u0004\u0003OC'\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0019M,\b\u000f]8si\n\u000bGo\u00195\u0015\u000bM\u000bi+a,\t\u000b5d\u0001\u0019\u00018\t\r\u0005EF\u00021\u0001g\u0003\u0019\u00198\r[3nC\u0006!r)Z8QCJ\fX/\u001a;GS2,gi\u001c:nCR\u0004\"a\n\b\u0014\u000b9\tIlN\u001f\u0011\u0007y\nY,C\u0002\u0002>~\u0012a!\u00118z%\u00164GCAA[\u0003YiWM]4f'\u000eDW-\\1t\u0013:\u0004\u0016M]1mY\u0016dGcB3\u0002F\u0006\u001d\u00171\u001a\u0005\u0006gB\u0001\r\u0001\u001e\u0005\b\u0003\u0013\u0004\u0002\u0019AA\u0005\u000311\u0017\u000e\\3t)>$v.^2i\u0011\u0015i\u0007\u00031\u0001o\u0003Q\u0011X-\u00193TG\",W.\u0019$s_64un\u001c;feRIa-!5\u0002b\u0006M\u0018Q \u0005\b\u0003'\f\u0002\u0019AAk\u0003\u00191wn\u001c;feB!\u0011q[Ao\u001b\t\tIN\u0003\u0003\u0002&\u0005m'BA\f!\u0013\u0011\ty.!7\u0003\r\u0019{w\u000e^3s\u0011\u001d\t\u0019/\u0005a\u0001\u0003K\f\u0001c[3z-\u0006dW/Z'fi\u0006$\u0015\r^1\u0011\r\u0005\u001d\u0018\u0011_@\u0000\u001b\t\tIO\u0003\u0003\u0002l\u00065\u0018\u0001B;uS2T!!a<\u0002\t)\fg/Y\u0005\u0004{\u0006%\bbBA{#\u0001\u0007\u0011q_\u0001\nG>tg/\u001a:uKJ\u00042aJA}\u0013\r\tYP\u0006\u0002!\u000f\u0016|\u0007+\u0019:rk\u0016$Hk\\*qCJ\\7k\u00195f[\u0006\u001cuN\u001c<feR,'\u000fC\u0003t#\u0001\u0007A/A\feKN,'/[1mSj,7k\u00195f[\u0006\u001cFO]5oOR9QMa\u0001\u0003\b\t%\u0001B\u0002B\u0003%\u0001\u0007q0\u0001\u0007tG\",W.Y*ue&tw\rC\u0004\u0002dJ\u0001\r!!:\t\u000bM\u0014\u0002\u0019\u0001;\u0002II,\u0007\u000f\\1dK\u001e+w.\\3uef\u001cu\u000e\\;n]^KG\u000f[$f_6,GO]=V\tR#rA\u001aB\b\u0005#\u0011\u0019\u0002\u0003\u0004\u00022N\u0001\rA\u001a\u0005\b\u0003G\u001c\u0002\u0019AAs\u0011\u0015\u00198\u00031\u0001u\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\te\u0001\u0003\u0002B\u000e\u0005Ci!A!\b\u000b\t\t}\u0011Q^\u0001\u0005Y\u0006tw-\u0003\u0003\u0003$\tu!AB(cU\u0016\u001cG\u000f")
public class GeoParquetFileFormat
extends ParquetFileFormat
implements GeoParquetFileFormatBase {
    private final Option<GeoParquetSpatialFilter> spatialFilter;

    public static Option<StructType> mergeSchemasInParallel(scala.collection.immutable.Map<String, String> map, Seq<FileStatus> seq, SparkSession sparkSession) {
        return GeoParquetFileFormat$.MODULE$.mergeSchemasInParallel(map, seq, sparkSession);
    }

    @Override
    public String shortName() {
        return GeoParquetFileFormatBase.shortName$(this);
    }

    public Option<GeoParquetSpatialFilter> spatialFilter() {
        return this.spatialFilter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof GeoParquetFileFormat)) return false;
        Option<GeoParquetSpatialFilter> option = ((GeoParquetFileFormat)other).spatialFilter();
        Option<GeoParquetSpatialFilter> option2 = this.spatialFilter();
        if (option != null) {
            if (!option.equals(option2)) return false;
            return true;
        }
        if (option2 == null) return true;
        return false;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    @Override
    public GeoParquetFileFormat withSpatialPredicates(GeoParquetSpatialFilter spatialFilter) {
        return new GeoParquetFileFormat((Option<GeoParquetSpatialFilter>)new Some((Object)spatialFilter));
    }

    public Option<StructType> inferSchema(SparkSession sparkSession, scala.collection.immutable.Map<String, String> parameters, Seq<FileStatus> files) {
        return GeoParquetUtils$.MODULE$.inferSchema(sparkSession, parameters, files);
    }

    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, scala.collection.immutable.Map<String, String> options, StructType dataSchema) {
        SQLConf sqlConf = sparkSession.sessionState().conf();
        ParquetOptions parquetOptions = new ParquetOptions(options, sqlConf);
        Configuration conf = ContextUtil.getConfiguration((JobContext)job);
        Class committerClass = conf.getClass(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key(), ParquetOutputCommitter.class, OutputCommitter.class);
        if (conf.get(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key()) == null) {
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Using default output committer for Parquet: ").append(ParquetOutputCommitter.class.getCanonicalName()).toString());
        } else {
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Using user defined output committer for Parquet: ").append(committerClass.getCanonicalName()).toString());
        }
        conf.setClass(SQLConf$.MODULE$.OUTPUT_COMMITTER_CLASS().key(), committerClass, OutputCommitter.class);
        job.setOutputFormatClass(ParquetOutputFormat.class);
        ParquetOutputFormat.setWriteSupportClass((Job)job, ParquetWriteSupport.class);
        ParquetWriteSupport$.MODULE$.setSchema(dataSchema, conf);
        conf.set(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key(), Boolean.toString(sqlConf.writeLegacyParquetFormat()));
        conf.set(SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key(), sqlConf.parquetOutputTimestampType().toString());
        conf.set(SQLConf$.MODULE$.PARQUET_FIELD_ID_WRITE_ENABLED().key(), Boolean.toString(sqlConf.parquetFieldIdWriteEnabled()));
        conf.set(SQLConf$.MODULE$.LEGACY_PARQUET_NANOS_AS_LONG().key(), Boolean.toString(sqlConf.legacyParquetNanosAsLong()));
        conf.set("parquet.compression", parquetOptions.compressionCodecClassName());
        if (conf.get("parquet.summary.metadata.level") == null && conf.get("parquet.enable.summary-metadata") == null) {
            conf.setEnum("parquet.summary.metadata.level", (Enum)ParquetOutputFormat.JobSummaryLevel.NONE);
        }
        ParquetOutputFormat.JobSummaryLevel jobSummaryLevel = ParquetOutputFormat.getJobSummaryLevel((Configuration)conf);
        ParquetOutputFormat.JobSummaryLevel jobSummaryLevel2 = ParquetOutputFormat.JobSummaryLevel.NONE;
        if ((jobSummaryLevel == null ? jobSummaryLevel2 != null : !jobSummaryLevel.equals(jobSummaryLevel2)) && !ParquetOutputCommitter.class.isAssignableFrom(committerClass)) {
            this.logWarning((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(134).append("Committer ").append(committerClass).append(" is not a ParquetOutputCommitter and cannot").append(" create job summaries. ").append("Set Parquet option ").append("parquet.summary.metadata.level").append(" to NONE.").toString());
        }
        conf.set("parquet.write.support.class", GeoParquetWriteSupport.class.getName());
        return new OutputWriterFactory(null){

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new ParquetOutputWriter(path, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return new StringBuilder(8).append(CodecConfig.from((TaskAttemptContext)context).getCodec().getExtension()).append(".parquet").toString();
            }
        };
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, scala.collection.immutable.Map<String, String> options, Configuration hadoopConf) {
        hadoopConf.set("parquet.read.support.class", ParquetReadSupport.class.getName());
        hadoopConf.set(ParquetReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA(), requiredSchema.json());
        hadoopConf.set(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA(), requiredSchema.json());
        hadoopConf.set(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key(), sparkSession.sessionState().conf().sessionLocalTimeZone());
        hadoopConf.setBoolean(SQLConf$.MODULE$.NESTED_SCHEMA_PRUNING_ENABLED().key(), sparkSession.sessionState().conf().nestedSchemaPruningEnabled());
        hadoopConf.setBoolean(SQLConf$.MODULE$.CASE_SENSITIVE().key(), sparkSession.sessionState().conf().caseSensitiveAnalysis());
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key(), sparkSession.sessionState().conf().isParquetBinaryAsString());
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key(), sparkSession.sessionState().conf().isParquetINT96AsTimestamp());
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_INFER_TIMESTAMP_NTZ_ENABLED().key(), sparkSession.sessionState().conf().parquetInferTimestampNTZEnabled());
        hadoopConf.setBoolean(SQLConf$.MODULE$.LEGACY_PARQUET_NANOS_AS_LONG().key(), sparkSession.sessionState().conf().legacyParquetNanosAsLong());
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        StructType resultSchema = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fields())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        SQLConf sqlConf = sparkSession.sessionState().conf();
        boolean enableVectorizedReader = sqlConf.parquetVectorizedReaderEnabled() && resultSchema.forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)GeoParquetFileFormat.$anonfun$buildReaderWithPartitionValues$1(x$1)));
        boolean enableRecordFilter = sqlConf.parquetRecordFilterEnabled();
        boolean timestampConversion = sqlConf.isParquetINT96TimestampConversion();
        boolean enableParquetFilterPushDown = sqlConf.parquetFilterPushDown();
        boolean pushDownDate = sqlConf.parquetFilterPushDownDate();
        boolean pushDownTimestamp = sqlConf.parquetFilterPushDownTimestamp();
        boolean pushDownDecimal = sqlConf.parquetFilterPushDownDecimal();
        boolean parquetFilterPushDownStringPredicate = sqlConf.parquetFilterPushDownStringPredicate();
        int pushDownInFilterThreshold = sqlConf.parquetFilterPushDownInFilterThreshold();
        boolean isCaseSensitive = sqlConf.caseSensitiveAnalysis();
        ParquetOptions parquetOptions = new ParquetOptions(options, sparkSession.sessionState().conf());
        String datetimeRebaseModeInRead = parquetOptions.datetimeRebaseModeInRead();
        String int96RebaseModeInRead = parquetOptions.int96RebaseModeInRead();
        return (Function1 & Serializable & scala.Serializable)file -> {
            Iterator iterator;
            None$ none$;
            Predef$.MODULE$.assert(file.partitionValues().numFields() == partitionSchema.size());
            Path filePath = file.toPath();
            FileSplit split = new FileSplit(filePath, file.start(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
            Configuration sharedConf = ((SerializableConfiguration)broadcastedHadoopConf.value()).value();
            FileMetaData footerFileMetaData = ParquetFooterReader.readFooter((Configuration)sharedConf, (PartitionedFile)file, (boolean)true).getFileMetaData();
            Map map = footerFileMetaData.getKeyValueMetaData();
            RebaseDateTime.RebaseSpec datetimeRebaseSpec = DataSourceUtils$.MODULE$.datetimeRebaseSpec((Function1 & Serializable & scala.Serializable)x$1 -> (String)map.get(x$1), datetimeRebaseModeInRead);
            Map map2 = footerFileMetaData.getKeyValueMetaData();
            RebaseDateTime.RebaseSpec int96RebaseSpec = DataSourceUtils$.MODULE$.int96RebaseSpec((Function1 & Serializable & scala.Serializable)x$1 -> (String)map2.get(x$1), int96RebaseModeInRead);
            if (enableParquetFilterPushDown) {
                MessageType parquetSchema = footerFileMetaData.getSchema();
                ParquetFilters parquetFilters = new ParquetFilters(parquetSchema, pushDownDate, pushDownTimestamp, pushDownDecimal, parquetFilterPushDownStringPredicate, pushDownInFilterThreshold, isCaseSensitive, datetimeRebaseSpec);
                none$ = ((TraversableOnce)filters.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> Option$.MODULE$.option2Iterable(parquetFilters.createFilter(x$2)), Seq$.MODULE$.canBuildFrom())).reduceOption((Function2 & Serializable & scala.Serializable)(x$1, x$2) -> FilterApi.and((FilterPredicate)x$1, (FilterPredicate)x$2));
            } else {
                none$ = None$.MODULE$;
            }
            None$ pushed = none$;
            boolean shouldScanFile = GeoParquetMetaData$.MODULE$.parseKeyValueMetaData(footerFileMetaData.getKeyValueMetaData()).forall((Function1 & Serializable & scala.Serializable)metadata -> BoxesRunTime.boxToBoolean((boolean)GeoParquetFileFormat.$anonfun$buildReaderWithPartitionValues$7(this, metadata)));
            if (!shouldScanFile) {
                iterator = ((IterableLike)Nil$.MODULE$).iterator();
            } else {
                ParquetRecordReader parquetRecordReader;
                None$ convertTz = timestampConversion && !GeoParquetFileFormat.isCreatedByParquetMr$1(footerFileMetaData) ? new Some((Object)DateTimeUtils$.MODULE$.getZoneId(sharedConf.get(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key()))) : None$.MODULE$;
                TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
                TaskAttemptContextImpl hadoopAttemptContext = new TaskAttemptContextImpl(((SerializableConfiguration)broadcastedHadoopConf.value()).value(), attemptId);
                if (pushed.isDefined()) {
                    ParquetInputFormat.setFilterPredicate((Configuration)hadoopAttemptContext.getConfiguration(), (FilterPredicate)((FilterPredicate)pushed.get()));
                }
                if (enableVectorizedReader) {
                    this.logWarning((Function0 & Serializable & scala.Serializable)() -> "GeoParquet currently does not support vectorized reader. Falling back to parquet-mr");
                }
                this.logDebug((Function0 & Serializable & scala.Serializable)() -> "Falling back to parquet-mr");
                GeoParquetReadSupport readSupport = new GeoParquetReadSupport((Option<ZoneId>)convertTz, false, datetimeRebaseSpec, int96RebaseSpec, options);
                if (pushed.isDefined() && enableRecordFilter) {
                    FilterCompat.Filter parquetFilter = FilterCompat.get((FilterPredicate)((FilterPredicate)pushed.get()), null);
                    parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport, parquetFilter);
                } else {
                    parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport);
                }
                ParquetRecordReader reader = parquetRecordReader;
                RecordReader readerWithRowIndexes = ParquetRowIndexUtil$.MODULE$.addRowIndexToRecordReaderIfNeeded(reader, requiredSchema);
                RecordReaderIterator iter = new RecordReaderIterator(readerWithRowIndexes);
                try {
                    readerWithRowIndexes.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
                    Seq fullSchema = (Seq)DataTypeUtils$.MODULE$.toAttributes(requiredSchema).$plus$plus((GenTraversableOnce)DataTypeUtils$.MODULE$.toAttributes(partitionSchema), Seq$.MODULE$.canBuildFrom());
                    UnsafeProjection unsafeProjection = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)fullSchema, fullSchema);
                    if (partitionSchema.length() == 0) {
                        iterator = iter.map((Function1)unsafeProjection);
                    } else {
                        JoinedRow joinedRow = new JoinedRow();
                        iterator = iter.map((Function1 & Serializable & scala.Serializable)d -> unsafeProjection.apply((InternalRow)joinedRow.apply(d, file.partitionValues())));
                    }
                }
                catch (Throwable e) {
                    iter.close();
                    throw e;
                }
            }
            return iterator;
        };
    }

    public boolean supportDataType(DataType dataType) {
        return super.supportDataType(dataType);
    }

    public boolean supportBatch(SparkSession sparkSession, StructType schema) {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$buildReaderWithPartitionValues$1(StructField x$1) {
        return x$1.dataType() instanceof AtomicType;
    }

    public static final /* synthetic */ boolean $anonfun$buildReaderWithPartitionValues$7(GeoParquetFileFormat $this, GeoParquetMetaData metadata) {
        return $this.spatialFilter().forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.evaluate(metadata.columns())));
    }

    private static final boolean isCreatedByParquetMr$1(FileMetaData footerFileMetaData$1) {
        return footerFileMetaData$1.getCreatedBy().startsWith("parquet-mr");
    }

    public GeoParquetFileFormat(Option<GeoParquetSpatialFilter> spatialFilter) {
        this.spatialFilter = spatialFilter;
        GeoParquetFileFormatBase.$init$(this);
    }

    public GeoParquetFileFormat() {
        this((Option<GeoParquetSpatialFilter>)None$.MODULE$);
    }
}

