/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.simplify;

import java.util.Arrays;
import java.util.Objects;
import org.apache.sedona.common.geometryObjects.Circle;
import org.apache.sedona.common.simplify.BaseSimplifier;
import org.apache.sedona.common.simplify.CircleSimplifier;
import org.apache.sedona.common.simplify.LineStringSimplifier;
import org.apache.sedona.common.simplify.PolygonSimplifier;
import org.apache.sedona.common.utils.GeomUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class GeometryCollectionSimplifier
extends BaseSimplifier {
    public static Geometry simplify(GeometryCollection geom, boolean preserveCollapsed, double epsilon) {
        Geometry[] simplifiedSubGeoms = (Geometry[])Arrays.stream(GeomUtils.getSubGeometries(geom)).map(subGeom -> {
            if (subGeom instanceof Circle) {
                return CircleSimplifier.simplify((Circle)subGeom, preserveCollapsed, epsilon);
            }
            if (subGeom instanceof LineString) {
                return LineStringSimplifier.simplify((LineString)subGeom, preserveCollapsed, epsilon);
            }
            if (subGeom instanceof Point) {
                return subGeom;
            }
            if (subGeom instanceof Polygon) {
                return PolygonSimplifier.simplify((Polygon)subGeom, preserveCollapsed, epsilon);
            }
            if (subGeom instanceof GeometryCollection) {
                return GeometryCollectionSimplifier.simplify((GeometryCollection)subGeom, preserveCollapsed, epsilon);
            }
            return null;
        }).filter(Objects::nonNull).toArray(Geometry[]::new);
        String[] distinctGeometries = (String[])Arrays.stream(simplifiedSubGeoms).map(Geometry::getGeometryType).distinct().toArray(String[]::new);
        if (distinctGeometries.length == 1) {
            switch (distinctGeometries[0]) {
                case "LineString": {
                    return geometryFactory.createMultiLineString((LineString[])Arrays.stream(simplifiedSubGeoms).map(x -> (LineString)x).toArray(LineString[]::new));
                }
                case "Polygon": {
                    return geometryFactory.createMultiPolygon((Polygon[])Arrays.stream(simplifiedSubGeoms).map(x -> (Polygon)x).toArray(Polygon[]::new));
                }
                case "Point": {
                    return geometryFactory.createMultiPoint((Point[])Arrays.stream(simplifiedSubGeoms).map(x -> (Point)x).toArray(Point[]::new));
                }
            }
        }
        return geometryFactory.createGeometryCollection(simplifiedSubGeoms);
    }
}

