/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.subDivide;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.sedona.common.simplify.GeometrySimplifier;
import org.apache.sedona.common.subDivide.PivotFinder;
import org.apache.sedona.common.subDivide.SubBoxes;
import org.apache.sedona.common.subDivide.SubDivideExtent;
import org.geotools.geometry.jts.JTS;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;

public class GeometrySubDivider {
    private static GeometryFactory geometryFactory = new GeometryFactory();
    private static final double FP_TOLERANCE = 1.0E-12;
    private static final int maxDepth = 50;
    public static final int minMaxVertices = 5;

    public static boolean equalValue(double value, double pivot) {
        return Math.abs(value - pivot) > 1.0E-12;
    }

    public static Geometry[] subDivideRecursive(Geometry geom, int dimension, int maxVertices, int depth, Geometry[] geometries) {
        if (geom == null) {
            return geometries;
        }
        int numberOfVertices = geom.getNumPoints();
        Envelope geometryBbox = geom.getEnvelope().getEnvelopeInternal();
        double width = geometryBbox.getWidth();
        double height = geometryBbox.getHeight();
        Envelope geometryBboxAligned = null;
        geometryBboxAligned = width == 0.0 ? new Envelope(geometryBbox.getMinX() - 1.0E-12, geometryBbox.getMaxX() + 1.0E-12, geometryBbox.getMinY(), geometryBbox.getMaxY()) : (height == 0.0 ? new Envelope(geometryBbox.getMinX(), geometryBbox.getMaxX(), geometryBbox.getMinY() - 1.0E-12, geometryBbox.getMaxY() + 1.0E-12) : geometryBbox);
        if (geom.getDimension() < dimension || numberOfVertices == 0) {
            return geometries;
        }
        if (width == 0.0 && height == 0.0) {
            if (geom instanceof Point) {
                if (dimension == 0) {
                    return (Geometry[])ArrayUtils.addAll((Object[])new Geometry[]{geom}, (Object[])geometries);
                }
                return geometries;
            }
            return geometries;
        }
        if (geom instanceof GeometryCollection && !geom.getGeometryType().contains("Point")) {
            GeometryCollection geometryCollection = (GeometryCollection)geom;
            ArrayList<Geometry> dividedGeoms = new ArrayList<Geometry>();
            for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
                dividedGeoms.addAll(Arrays.asList(GeometrySubDivider.subDivideRecursive(geometryCollection.getGeometryN(i), dimension, maxVertices, depth, geometries)));
            }
            return dividedGeoms.toArray(new Geometry[0]);
        }
        if (numberOfVertices <= maxVertices || depth > 50) {
            return (Geometry[])ArrayUtils.addAll((Object[])new Geometry[]{geom}, (Object[])geometries);
        }
        boolean splitOrdinate = width <= height;
        double center = splitOrdinate ? (geometryBboxAligned.getMinY() + geometryBboxAligned.getMaxY()) / 2.0 : (geometryBboxAligned.getMinX() + geometryBboxAligned.getMaxX()) / 2.0;
        double pivot = PivotFinder.findPivot(geom, splitOrdinate, center, numberOfVertices);
        SubBoxes subBoxes = GeometrySubDivider.getSubBoxes(splitOrdinate, new SubDivideExtent(geometryBboxAligned), pivot, center);
        Geometry intersectedSimplified = GeometrySubDivider.getIntersectionGeometries(subBoxes.getSubBox(), geom);
        Geometry intersectedIter2Simplified = GeometrySubDivider.getIntersectionGeometries(subBoxes.getSubBox2(), geom);
        if (intersectedSimplified != null && !intersectedSimplified.isEmpty() && intersectedIter2Simplified != null && !intersectedIter2Simplified.isEmpty()) {
            return (Geometry[])ArrayUtils.addAll((Object[])GeometrySubDivider.subDivideRecursive(intersectedSimplified, dimension, maxVertices, depth + 1, geometries), (Object[])GeometrySubDivider.subDivideRecursive(intersectedIter2Simplified, dimension, maxVertices, depth + 1, geometries));
        }
        if (intersectedSimplified != null && !intersectedSimplified.isEmpty()) {
            return GeometrySubDivider.subDivideRecursive(intersectedSimplified, dimension, maxVertices, depth + 1, geometries);
        }
        if (intersectedIter2Simplified != null && !intersectedIter2Simplified.isEmpty()) {
            return GeometrySubDivider.subDivideRecursive(intersectedIter2Simplified, dimension, maxVertices, depth + 1, geometries);
        }
        return geometries;
    }

    private static SubBoxes getSubBoxes(boolean splitOrdinate, SubDivideExtent subbox, double pivot, double center) {
        if (splitOrdinate) {
            if (GeometrySubDivider.equalValue(subbox.getyMax(), pivot) && GeometrySubDivider.equalValue(subbox.getyMin(), pivot)) {
                return new SubBoxes(subbox.copy().setyMax(pivot), subbox.copy().setyMin(pivot));
            }
            return new SubBoxes(subbox.copy().setyMax(center), subbox.copy().setyMin(center));
        }
        if (GeometrySubDivider.equalValue(subbox.getxMax(), pivot) && GeometrySubDivider.equalValue(subbox.getxMin(), pivot)) {
            return new SubBoxes(subbox.copy().setxMax(pivot), subbox.copy().setxMin(pivot));
        }
        return new SubBoxes(subbox.copy().setxMax(center), subbox.copy().setxMin(center));
    }

    private static Geometry getIntersectionGeometries(SubDivideExtent extent, Geometry geom) {
        Envelope subBox = new Envelope(extent.getxMin(), extent.getxMax(), extent.getyMin(), extent.getyMax());
        Geometry intersected = geom.intersection(JTS.toGeometry((Envelope)subBox));
        Geometry res = GeometrySimplifier.simplify(intersected, true, 0.0);
        return res;
    }

    public static Geometry[] subDivide(Geometry geom, int maxVertices) {
        if (geom == null || maxVertices < 5) {
            return new Geometry[0];
        }
        return GeometrySubDivider.subDivideRecursive(geom, geom.getDimension(), maxVertices, 0, new Geometry[0]);
    }
}

