/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.dbf;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.EndianUtils;
import org.apache.hadoop.io.Text;
import org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.dbf.FieldDescriptor;
import org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.shp.ShapeFileConst;

public class DbfParseUtil
implements ShapeFileConst {
    public int numRecord = 0;
    public int numBytesRecord = 0;
    public int numRecordRead;
    private List<FieldDescriptor> fieldDescriptors = null;

    private static String fastParse(byte[] bytes, int fieldOffset, int fieldLen) {
        char[] chars = new char[fieldLen];
        for (int i = 0; i < fieldLen; ++i) {
            chars[i] = (char)(0xFF & bytes[fieldOffset + i]);
        }
        return new String(chars);
    }

    public boolean isDone() {
        return this.numRecordRead >= this.numRecord;
    }

    public float getProgress() {
        return (float)this.numRecordRead / (float)this.numRecord;
    }

    public List<FieldDescriptor> getFieldDescriptors() {
        return this.fieldDescriptors;
    }

    public void parseFileHead(DataInputStream inputStream) throws IOException {
        inputStream.readByte();
        byte[] date = new byte[3];
        inputStream.readFully(date);
        this.numRecord = EndianUtils.swapInteger((int)inputStream.readInt());
        short numBytes = EndianUtils.swapShort((short)inputStream.readShort());
        this.numBytesRecord = EndianUtils.swapShort((short)inputStream.readShort());
        inputStream.skipBytes(2);
        inputStream.skipBytes(1);
        inputStream.skipBytes(1);
        inputStream.skipBytes(12);
        inputStream.skipBytes(1);
        inputStream.skipBytes(1);
        inputStream.skipBytes(2);
        this.fieldDescriptors = new ArrayList<FieldDescriptor>();
        byte terminator = inputStream.readByte();
        while (terminator != 13) {
            FieldDescriptor descriptor = new FieldDescriptor();
            byte[] nameBytes = new byte[11];
            nameBytes[0] = terminator;
            inputStream.readFully(nameBytes, 1, 10);
            int zeroId = 0;
            while (nameBytes[zeroId] != 0) {
                ++zeroId;
            }
            Text fieldName = new Text();
            fieldName.append(nameBytes, 0, zeroId);
            descriptor.setFieldName(fieldName.toString());
            descriptor.setFieldType(inputStream.readByte());
            inputStream.readInt();
            descriptor.setFieldLength(inputStream.readUnsignedByte());
            descriptor.setFieldDecimalCount(inputStream.readByte());
            inputStream.skipBytes(14);
            this.fieldDescriptors.add(descriptor);
            terminator = inputStream.readByte();
        }
    }

    public List<byte[]> parse(DataInputStream inputStream) throws IOException {
        if (this.isDone()) {
            return null;
        }
        byte flag = inputStream.readByte();
        int recordLength = this.numBytesRecord - 1;
        while (flag == 42) {
            inputStream.skipBytes(recordLength);
            ++this.numRecordRead;
            flag = inputStream.readByte();
        }
        if (flag == 26) {
            return null;
        }
        byte[] primitiveBytes = new byte[recordLength];
        inputStream.readFully(primitiveBytes);
        ++this.numRecordRead;
        return this.extractFieldBytes(ByteBuffer.wrap(primitiveBytes));
    }

    private List<byte[]> extractFieldBytes(ByteBuffer buffer) {
        int numFields = this.fieldDescriptors.size();
        ArrayList<byte[]> fieldBytesList = new ArrayList<byte[]>(numFields);
        for (FieldDescriptor descriptor : this.fieldDescriptors) {
            byte[] fldBytes = new byte[descriptor.getFieldLength()];
            buffer.get(fldBytes, 0, fldBytes.length);
            fieldBytesList.add(fldBytes);
        }
        return fieldBytesList;
    }

    public static String fieldBytesToString(List<byte[]> fieldBytesList) {
        byte[] delimiter = new byte[]{9};
        Text attributes = new Text();
        for (int i = 0; i < fieldBytesList.size(); ++i) {
            byte[] attr;
            byte[] fldBytes = fieldBytesList.get(i);
            String charset = System.getProperty("sedona.global.charset", "default");
            boolean utf8flag = charset.equalsIgnoreCase("utf8");
            byte[] byArray = attr = utf8flag ? fldBytes : DbfParseUtil.fastParse(fldBytes, 0, fldBytes.length).trim().getBytes();
            if (i > 0) {
                attributes.append(delimiter, 0, 1);
            }
            attributes.append(attr, 0, attr.length);
        }
        return attributes.toString();
    }
}

