/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.raster.serde;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.List;
import org.apache.sedona.common.raster.serde.KryoUtil;
import org.apache.sedona.common.utils.RasterUtils;
import org.geotools.coverage.Category;
import org.geotools.coverage.GridSampleDimension;

public class GridSampleDimensionSerializer
extends Serializer<GridSampleDimension> {
    public void write(Kryo kryo, Output output, GridSampleDimension sampleDimension) {
        String description = sampleDimension.getDescription().toString();
        List categories = sampleDimension.getCategories();
        double offset = sampleDimension.getOffset();
        double scale = sampleDimension.getScale();
        double noDataValue = RasterUtils.getNoDataValue(sampleDimension);
        KryoUtil.writeUTF8String(output, description);
        output.writeDouble(offset);
        output.writeDouble(scale);
        output.writeDouble(noDataValue);
        KryoUtil.writeObjectWithLength(kryo, output, categories.toArray());
    }

    public GridSampleDimension read(Kryo kryo, Input input, Class aClass) {
        String description = KryoUtil.readUTF8String(input);
        double offset = input.readDouble();
        double scale = input.readDouble();
        input.readDouble();
        input.readInt();
        Category[] categories = (Category[])kryo.readObject(input, Category[].class);
        return new GridSampleDimension(description, categories, offset, scale);
    }
}

