/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.invocation.validator;

import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.ParameterNameProvider;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import javax.validation.executable.ExecutableValidator;
import javax.validation.groups.Default;
import org.apache.servicecomb.swagger.engine.SwaggerProducerOperation;
import org.apache.servicecomb.swagger.invocation.SwaggerInvocation;
import org.apache.servicecomb.swagger.invocation.extension.ProducerInvokeExtension;
import org.apache.servicecomb.swagger.invocation.validator.DefaultParameterNameProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterValidator
implements ProducerInvokeExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParameterValidator.class);
    private static ExecutableValidator executableValidator;

    public <T> void beforeMethodInvoke(SwaggerInvocation invocation, SwaggerProducerOperation producerOperation, Object[] args) throws ConstraintViolationException {
        Set violations;
        if (null == executableValidator) {
            ValidatorFactory factory = Validation.byDefaultProvider().configure().parameterNameProvider((ParameterNameProvider)new DefaultParameterNameProvider()).buildValidatorFactory();
            executableValidator = factory.getValidator().forExecutables();
        }
        if ((violations = executableValidator.validateParameters(producerOperation.getProducerInstance(), producerOperation.getProducerMethod(), args, new Class[]{Default.class})).size() > 0) {
            LOGGER.warn("Parameter validation failed : " + violations.toString());
            throw new ConstraintViolationException(violations);
        }
    }

    public int getOrder() {
        return 100;
    }
}

