/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.bootstrap.ServerBootstrap;
import java.util.Objects;
import java.util.function.Function;
import reactor.netty.ConnectionObserver;
import reactor.netty.channel.BootstrapHandlers;
import reactor.netty.http.server.HttpServer;
import reactor.netty.http.server.HttpServerOperator;
import reactor.netty.tcp.TcpServer;

final class HttpServerObserve
extends HttpServerOperator
implements Function<ServerBootstrap, ServerBootstrap> {
    final ConnectionObserver observer;

    HttpServerObserve(HttpServer client, ConnectionObserver observer) {
        super(client);
        this.observer = Objects.requireNonNull(observer, "observer");
    }

    @Override
    protected TcpServer tcpConfiguration() {
        return this.source.tcpConfiguration().bootstrap(this);
    }

    @Override
    public ServerBootstrap apply(ServerBootstrap b) {
        ConnectionObserver observer = BootstrapHandlers.childConnectionObserver(b);
        BootstrapHandlers.childConnectionObserver(b, observer.then(this.observer));
        return b;
    }
}

