/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.springmvc.processor.annotation;

import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.CookieParameter;
import org.apache.servicecomb.swagger.generator.core.OperationGenerator;
import org.apache.servicecomb.swagger.generator.core.processor.parameter.AbstractParameterProcessor;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.CookieValue;

public class CookieValueAnnotationProcessor
extends AbstractParameterProcessor<CookieParameter> {
    public String getAnnotationParameterName(Object annotation) {
        String value = ((CookieValue)annotation).value();
        if (value.isEmpty()) {
            value = ((CookieValue)annotation).name();
        }
        return value;
    }

    public CookieParameter createParameter() {
        return new CookieParameter();
    }

    protected void fillParameter(Object annotation, OperationGenerator operationGenerator, int paramIdx, CookieParameter parameter) {
        super.fillParameter(annotation, operationGenerator, paramIdx, (AbstractSerializableParameter)parameter);
        Object defaultValue = parameter.getDefaultValue();
        if (!ObjectUtils.isEmpty((Object)defaultValue)) {
            parameter.setRequired(false);
            return;
        }
        CookieValue cookie = (CookieValue)annotation;
        parameter.setRequired(cookie.required());
    }

    protected String getAnnotationParameterDefaultValue(Object annotation) {
        String defaultValue = ((CookieValue)annotation).defaultValue();
        if (defaultValue.equals("\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n")) {
            return "";
        }
        return defaultValue;
    }
}

