/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import com.rabbitmq.client.Channel;
import java.util.Map;
import org.springframework.amqp.rabbit.core.ChannelCallback;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.util.Assert;

public class RabbitHealthIndicator
extends AbstractHealthIndicator {
    private final RabbitTemplate rabbitTemplate;

    public RabbitHealthIndicator(RabbitTemplate rabbitTemplate) {
        Assert.notNull((Object)rabbitTemplate, (String)"RabbitTemplate must not be null.");
        this.rabbitTemplate = rabbitTemplate;
    }

    @Override
    protected void doHealthCheck(Health.Builder builder) throws Exception {
        builder.up().withDetail("version", this.getVersion());
    }

    private String getVersion() {
        return (String)this.rabbitTemplate.execute((ChannelCallback)new ChannelCallback<String>(){

            public String doInRabbit(Channel channel) throws Exception {
                Map serverProperties = channel.getConnection().getServerProperties();
                return serverProperties.get("version").toString();
            }
        });
    }
}

